/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NniPartnerType {
    V1("v1"),
    V2("v2"),
    NON_PARTNER("nonPartner"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NniPartnerType> VALUE_MAP;
    private final String value;

    private NniPartnerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NniPartnerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NniPartnerType> knownValues() {
        EnumSet<NniPartnerType> knownValues = EnumSet.allOf(NniPartnerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NniPartnerType.class, NniPartnerType::toString);
    }
}

