/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum GatewayType {
    VIRTUAL_PRIVATE_GATEWAY("virtualPrivateGateway"),
    TRANSIT_GATEWAY("transitGateway"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private GatewayType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GatewayType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(GatewayType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GatewayType> knownValues() {
        return Stream.of(GatewayType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

