/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.NewPublicVirtualInterfaceAllocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllocatePublicVirtualInterfaceRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, AllocatePublicVirtualInterfaceRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AllocatePublicVirtualInterfaceRequest.getter(AllocatePublicVirtualInterfaceRequest::connectionId)).setter(AllocatePublicVirtualInterfaceRequest.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AllocatePublicVirtualInterfaceRequest.getter(AllocatePublicVirtualInterfaceRequest::ownerAccount)).setter(AllocatePublicVirtualInterfaceRequest.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<NewPublicVirtualInterfaceAllocation> NEW_PUBLIC_VIRTUAL_INTERFACE_ALLOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AllocatePublicVirtualInterfaceRequest.getter(AllocatePublicVirtualInterfaceRequest::newPublicVirtualInterfaceAllocation)).setter(AllocatePublicVirtualInterfaceRequest.setter(Builder::newPublicVirtualInterfaceAllocation)).constructor(NewPublicVirtualInterfaceAllocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newPublicVirtualInterfaceAllocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD, OWNER_ACCOUNT_FIELD, NEW_PUBLIC_VIRTUAL_INTERFACE_ALLOCATION_FIELD));
    private final String connectionId;
    private final String ownerAccount;
    private final NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation;

    private AllocatePublicVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.ownerAccount = builder.ownerAccount;
        this.newPublicVirtualInterfaceAllocation = builder.newPublicVirtualInterfaceAllocation;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation() {
        return this.newPublicVirtualInterfaceAllocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.newPublicVirtualInterfaceAllocation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocatePublicVirtualInterfaceRequest)) {
            return false;
        }
        AllocatePublicVirtualInterfaceRequest other = (AllocatePublicVirtualInterfaceRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.newPublicVirtualInterfaceAllocation(), other.newPublicVirtualInterfaceAllocation());
    }

    public String toString() {
        return ToString.builder((String)"AllocatePublicVirtualInterfaceRequest").add("ConnectionId", (Object)this.connectionId()).add("OwnerAccount", (Object)this.ownerAccount()).add("NewPublicVirtualInterfaceAllocation", (Object)this.newPublicVirtualInterfaceAllocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "newPublicVirtualInterfaceAllocation": {
                return Optional.ofNullable(clazz.cast(this.newPublicVirtualInterfaceAllocation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllocatePublicVirtualInterfaceRequest, T> g) {
        return obj -> g.apply((AllocatePublicVirtualInterfaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private String ownerAccount;
        private NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocatePublicVirtualInterfaceRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.ownerAccount(model.ownerAccount);
            this.newPublicVirtualInterfaceAllocation(model.newPublicVirtualInterfaceAllocation);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final NewPublicVirtualInterfaceAllocation.Builder getNewPublicVirtualInterfaceAllocation() {
            return this.newPublicVirtualInterfaceAllocation != null ? this.newPublicVirtualInterfaceAllocation.toBuilder() : null;
        }

        @Override
        public final Builder newPublicVirtualInterfaceAllocation(NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation) {
            this.newPublicVirtualInterfaceAllocation = newPublicVirtualInterfaceAllocation;
            return this;
        }

        public final void setNewPublicVirtualInterfaceAllocation(NewPublicVirtualInterfaceAllocation.BuilderImpl newPublicVirtualInterfaceAllocation) {
            this.newPublicVirtualInterfaceAllocation = newPublicVirtualInterfaceAllocation != null ? newPublicVirtualInterfaceAllocation.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocatePublicVirtualInterfaceRequest build() {
            return new AllocatePublicVirtualInterfaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AllocatePublicVirtualInterfaceRequest> {
        public Builder connectionId(String var1);

        public Builder ownerAccount(String var1);

        public Builder newPublicVirtualInterfaceAllocation(NewPublicVirtualInterfaceAllocation var1);

        default public Builder newPublicVirtualInterfaceAllocation(Consumer<NewPublicVirtualInterfaceAllocation.Builder> newPublicVirtualInterfaceAllocation) {
            return this.newPublicVirtualInterfaceAllocation((NewPublicVirtualInterfaceAllocation)((NewPublicVirtualInterfaceAllocation.Builder)NewPublicVirtualInterfaceAllocation.builder().applyMutation(newPublicVirtualInterfaceAllocation)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

