/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse;
import software.amazon.awssdk.services.deadline.model.QueueMember;

public class ListQueueMembersIterable
implements SdkIterable<ListQueueMembersResponse> {
    private final DeadlineClient client;
    private final ListQueueMembersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQueueMembersIterable(DeadlineClient client, ListQueueMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListQueueMembersResponseFetcher();
    }

    public Iterator<ListQueueMembersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<QueueMember> members() {
        Function<ListQueueMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListQueueMembersResponseFetcher
    implements SyncPageFetcher<ListQueueMembersResponse> {
        private ListQueueMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListQueueMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQueueMembersResponse nextPage(ListQueueMembersResponse previousPage) {
            if (previousPage == null) {
                return ListQueueMembersIterable.this.client.listQueueMembers(ListQueueMembersIterable.this.firstRequest);
            }
            return ListQueueMembersIterable.this.client.listQueueMembers((ListQueueMembersRequest)((Object)ListQueueMembersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

