/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse;
import software.amazon.awssdk.services.deadline.model.QueueFleetAssociationSummary;

public class ListQueueFleetAssociationsPublisher
implements SdkPublisher<ListQueueFleetAssociationsResponse> {
    private final DeadlineAsyncClient client;
    private final ListQueueFleetAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQueueFleetAssociationsPublisher(DeadlineAsyncClient client, ListQueueFleetAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQueueFleetAssociationsPublisher(DeadlineAsyncClient client, ListQueueFleetAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQueueFleetAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQueueFleetAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<QueueFleetAssociationSummary> queueFleetAssociations() {
        Function<ListQueueFleetAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.queueFleetAssociations() != null) {
                return response.queueFleetAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListQueueFleetAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListQueueFleetAssociationsResponseFetcher
    implements AsyncPageFetcher<ListQueueFleetAssociationsResponse> {
        private ListQueueFleetAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListQueueFleetAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQueueFleetAssociationsResponse> nextPage(ListQueueFleetAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListQueueFleetAssociationsPublisher.this.client.listQueueFleetAssociations(ListQueueFleetAssociationsPublisher.this.firstRequest);
            }
            return ListQueueFleetAssociationsPublisher.this.client.listQueueFleetAssociations((ListQueueFleetAssociationsRequest)((Object)ListQueueFleetAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

