/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListJobParameterDefinitionsRequest;
import software.amazon.awssdk.services.deadline.model.ListJobParameterDefinitionsResponse;

public class ListJobParameterDefinitionsPublisher
implements SdkPublisher<ListJobParameterDefinitionsResponse> {
    private final DeadlineAsyncClient client;
    private final ListJobParameterDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJobParameterDefinitionsPublisher(DeadlineAsyncClient client, ListJobParameterDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJobParameterDefinitionsPublisher(DeadlineAsyncClient client, ListJobParameterDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJobParameterDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJobParameterDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Document> jobParameterDefinitions() {
        Function<ListJobParameterDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobParameterDefinitions() != null) {
                return response.jobParameterDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListJobParameterDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListJobParameterDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListJobParameterDefinitionsResponse> {
        private ListJobParameterDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobParameterDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListJobParameterDefinitionsResponse> nextPage(ListJobParameterDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListJobParameterDefinitionsPublisher.this.client.listJobParameterDefinitions(ListJobParameterDefinitionsPublisher.this.firstRequest);
            }
            return ListJobParameterDefinitionsPublisher.this.client.listJobParameterDefinitions((ListJobParameterDefinitionsRequest)((Object)ListJobParameterDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

