/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.StepSearchSummariesCopier;
import software.amazon.awssdk.services.deadline.model.StepSearchSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchStepsResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, SearchStepsResponse> {
    private static final SdkField<List<StepSearchSummary>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("steps").getter(SearchStepsResponse.getter(SearchStepsResponse::steps)).setter(SearchStepsResponse.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepSearchSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> NEXT_ITEM_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("nextItemOffset").getter(SearchStepsResponse.getter(SearchStepsResponse::nextItemOffset)).setter(SearchStepsResponse.setter(Builder::nextItemOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextItemOffset").build()}).build();
    private static final SdkField<Integer> TOTAL_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalResults").getter(SearchStepsResponse.getter(SearchStepsResponse::totalResults)).setter(SearchStepsResponse.setter(Builder::totalResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEPS_FIELD, NEXT_ITEM_OFFSET_FIELD, TOTAL_RESULTS_FIELD));
    private final List<StepSearchSummary> steps;
    private final Integer nextItemOffset;
    private final Integer totalResults;

    private SearchStepsResponse(BuilderImpl builder) {
        super(builder);
        this.steps = builder.steps;
        this.nextItemOffset = builder.nextItemOffset;
        this.totalResults = builder.totalResults;
    }

    public final boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public final List<StepSearchSummary> steps() {
        return this.steps;
    }

    public final Integer nextItemOffset() {
        return this.nextItemOffset;
    }

    public final Integer totalResults() {
        return this.totalResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSteps() ? this.steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextItemOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchStepsResponse)) {
            return false;
        }
        SearchStepsResponse other = (SearchStepsResponse)((Object)obj);
        return this.hasSteps() == other.hasSteps() && Objects.equals(this.steps(), other.steps()) && Objects.equals(this.nextItemOffset(), other.nextItemOffset()) && Objects.equals(this.totalResults(), other.totalResults());
    }

    public final String toString() {
        return ToString.builder((String)"SearchStepsResponse").add("Steps", this.hasSteps() ? this.steps() : null).add("NextItemOffset", (Object)this.nextItemOffset()).add("TotalResults", (Object)this.totalResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
            case "nextItemOffset": {
                return Optional.ofNullable(clazz.cast(this.nextItemOffset()));
            }
            case "totalResults": {
                return Optional.ofNullable(clazz.cast(this.totalResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchStepsResponse, T> g) {
        return obj -> g.apply((SearchStepsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private List<StepSearchSummary> steps = DefaultSdkAutoConstructList.getInstance();
        private Integer nextItemOffset;
        private Integer totalResults;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchStepsResponse model) {
            super(model);
            this.steps(model.steps);
            this.nextItemOffset(model.nextItemOffset);
            this.totalResults(model.totalResults);
        }

        public final List<StepSearchSummary.Builder> getSteps() {
            List<StepSearchSummary.Builder> result = StepSearchSummariesCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<StepSearchSummary.BuilderImpl> steps) {
            this.steps = StepSearchSummariesCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<StepSearchSummary> steps) {
            this.steps = StepSearchSummariesCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(StepSearchSummary ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<StepSearchSummary.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (StepSearchSummary)((StepSearchSummary.Builder)StepSearchSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getNextItemOffset() {
            return this.nextItemOffset;
        }

        public final void setNextItemOffset(Integer nextItemOffset) {
            this.nextItemOffset = nextItemOffset;
        }

        @Override
        public final Builder nextItemOffset(Integer nextItemOffset) {
            this.nextItemOffset = nextItemOffset;
            return this;
        }

        public final Integer getTotalResults() {
            return this.totalResults;
        }

        public final void setTotalResults(Integer totalResults) {
            this.totalResults = totalResults;
        }

        @Override
        public final Builder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        @Override
        public SearchStepsResponse build() {
            return new SearchStepsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchStepsResponse> {
        public Builder steps(Collection<StepSearchSummary> var1);

        public Builder steps(StepSearchSummary ... var1);

        public Builder steps(Consumer<StepSearchSummary.Builder> ... var1);

        public Builder nextItemOffset(Integer var1);

        public Builder totalResults(Integer var1);
    }
}

