/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Ec2MarketType {
    ON_DEMAND("on-demand"),
    SPOT("spot"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Ec2MarketType> VALUE_MAP;
    private final String value;

    private Ec2MarketType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Ec2MarketType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Ec2MarketType> knownValues() {
        EnumSet<Ec2MarketType> knownValues = EnumSet.allOf(Ec2MarketType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Ec2MarketType.class, Ec2MarketType::toString);
    }
}

