/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for worker capabilities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkerCapabilities implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkerCapabilities.Builder, WorkerCapabilities> {
    private static final SdkField<List<WorkerAmountCapability>> AMOUNTS_FIELD = SdkField
            .<List<WorkerAmountCapability>> builder(MarshallingType.LIST)
            .memberName("amounts")
            .getter(getter(WorkerCapabilities::amounts))
            .setter(setter(Builder::amounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkerAmountCapability> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkerAmountCapability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<WorkerAttributeCapability>> ATTRIBUTES_FIELD = SdkField
            .<List<WorkerAttributeCapability>> builder(MarshallingType.LIST)
            .memberName("attributes")
            .getter(getter(WorkerCapabilities::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkerAttributeCapability> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkerAttributeCapability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNTS_FIELD,
            ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<WorkerAmountCapability> amounts;

    private final List<WorkerAttributeCapability> attributes;

    private WorkerCapabilities(BuilderImpl builder) {
        this.amounts = builder.amounts;
        this.attributes = builder.attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Amounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAmounts() {
        return amounts != null && !(amounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The worker capabilities amounts on a list of worker capabilities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAmounts} method.
     * </p>
     * 
     * @return The worker capabilities amounts on a list of worker capabilities.
     */
    public final List<WorkerAmountCapability> amounts() {
        return amounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The worker attribute capabilities in the list of attribute capabilities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The worker attribute capabilities in the list of attribute capabilities.
     */
    public final List<WorkerAttributeCapability> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAmounts() ? amounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerCapabilities)) {
            return false;
        }
        WorkerCapabilities other = (WorkerCapabilities) obj;
        return hasAmounts() == other.hasAmounts() && Objects.equals(amounts(), other.amounts())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkerCapabilities").add("Amounts", hasAmounts() ? amounts() : null)
                .add("Attributes", hasAttributes() ? attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amounts":
            return Optional.ofNullable(clazz.cast(amounts()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkerCapabilities, T> g) {
        return obj -> g.apply((WorkerCapabilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkerCapabilities> {
        /**
         * <p>
         * The worker capabilities amounts on a list of worker capabilities.
         * </p>
         * 
         * @param amounts
         *        The worker capabilities amounts on a list of worker capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amounts(Collection<WorkerAmountCapability> amounts);

        /**
         * <p>
         * The worker capabilities amounts on a list of worker capabilities.
         * </p>
         * 
         * @param amounts
         *        The worker capabilities amounts on a list of worker capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amounts(WorkerAmountCapability... amounts);

        /**
         * <p>
         * The worker capabilities amounts on a list of worker capabilities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.WorkerAmountCapability.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.WorkerAmountCapability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.WorkerAmountCapability.Builder#build()} is called
         * immediately and its result is passed to {@link #amounts(List<WorkerAmountCapability>)}.
         * 
         * @param amounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.WorkerAmountCapability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amounts(java.util.Collection<WorkerAmountCapability>)
         */
        Builder amounts(Consumer<WorkerAmountCapability.Builder>... amounts);

        /**
         * <p>
         * The worker attribute capabilities in the list of attribute capabilities.
         * </p>
         * 
         * @param attributes
         *        The worker attribute capabilities in the list of attribute capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<WorkerAttributeCapability> attributes);

        /**
         * <p>
         * The worker attribute capabilities in the list of attribute capabilities.
         * </p>
         * 
         * @param attributes
         *        The worker attribute capabilities in the list of attribute capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(WorkerAttributeCapability... attributes);

        /**
         * <p>
         * The worker attribute capabilities in the list of attribute capabilities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.WorkerAttributeCapability.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.WorkerAttributeCapability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.WorkerAttributeCapability.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(List<WorkerAttributeCapability>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.WorkerAttributeCapability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(java.util.Collection<WorkerAttributeCapability>)
         */
        Builder attributes(Consumer<WorkerAttributeCapability.Builder>... attributes);
    }

    static final class BuilderImpl implements Builder {
        private List<WorkerAmountCapability> amounts = DefaultSdkAutoConstructList.getInstance();

        private List<WorkerAttributeCapability> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerCapabilities model) {
            amounts(model.amounts);
            attributes(model.attributes);
        }

        public final List<WorkerAmountCapability.Builder> getAmounts() {
            List<WorkerAmountCapability.Builder> result = WorkerAmountCapabilityListCopier.copyToBuilder(this.amounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmounts(Collection<WorkerAmountCapability.BuilderImpl> amounts) {
            this.amounts = WorkerAmountCapabilityListCopier.copyFromBuilder(amounts);
        }

        @Override
        public final Builder amounts(Collection<WorkerAmountCapability> amounts) {
            this.amounts = WorkerAmountCapabilityListCopier.copy(amounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(WorkerAmountCapability... amounts) {
            amounts(Arrays.asList(amounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(Consumer<WorkerAmountCapability.Builder>... amounts) {
            amounts(Stream.of(amounts).map(c -> WorkerAmountCapability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<WorkerAttributeCapability.Builder> getAttributes() {
            List<WorkerAttributeCapability.Builder> result = WorkerAttributeCapabilityListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<WorkerAttributeCapability.BuilderImpl> attributes) {
            this.attributes = WorkerAttributeCapabilityListCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<WorkerAttributeCapability> attributes) {
            this.attributes = WorkerAttributeCapabilityListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(WorkerAttributeCapability... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<WorkerAttributeCapability.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> WorkerAttributeCapability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public WorkerCapabilities build() {
            return new WorkerCapabilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
