/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Windows user details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WindowsUser implements SdkPojo, Serializable, ToCopyableBuilder<WindowsUser.Builder, WindowsUser> {
    private static final SdkField<String> USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("user")
            .getter(getter(WindowsUser::user)).setter(setter(Builder::user))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();

    private static final SdkField<String> PASSWORD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("passwordArn").getter(getter(WindowsUser::passwordArn)).setter(setter(Builder::passwordArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passwordArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(USER_FIELD, PASSWORD_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String user;

    private final String passwordArn;

    private WindowsUser(BuilderImpl builder) {
        this.user = builder.user;
        this.passwordArn = builder.passwordArn;
    }

    /**
     * <p>
     * The user.
     * </p>
     * 
     * @return The user.
     */
    public final String user() {
        return user;
    }

    /**
     * <p>
     * The password ARN for the Windows user.
     * </p>
     * 
     * @return The password ARN for the Windows user.
     */
    public final String passwordArn() {
        return passwordArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(passwordArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WindowsUser)) {
            return false;
        }
        WindowsUser other = (WindowsUser) obj;
        return Objects.equals(user(), other.user()) && Objects.equals(passwordArn(), other.passwordArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WindowsUser").add("User", user()).add("PasswordArn", passwordArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "user":
            return Optional.ofNullable(clazz.cast(user()));
        case "passwordArn":
            return Optional.ofNullable(clazz.cast(passwordArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WindowsUser, T> g) {
        return obj -> g.apply((WindowsUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WindowsUser> {
        /**
         * <p>
         * The user.
         * </p>
         * 
         * @param user
         *        The user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(String user);

        /**
         * <p>
         * The password ARN for the Windows user.
         * </p>
         * 
         * @param passwordArn
         *        The password ARN for the Windows user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordArn(String passwordArn);
    }

    static final class BuilderImpl implements Builder {
        private String user;

        private String passwordArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WindowsUser model) {
            user(model.user);
            passwordArn(model.passwordArn);
        }

        public final String getUser() {
            return user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final String getPasswordArn() {
            return passwordArn;
        }

        public final void setPasswordArn(String passwordArn) {
            this.passwordArn = passwordArn;
        }

        @Override
        public final Builder passwordArn(String passwordArn) {
            this.passwordArn = passwordArn;
            return this;
        }

        @Override
        public WindowsUser build() {
            return new WindowsUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
