/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMonitorRequest extends DeadlineRequest implements
        ToCopyableBuilder<UpdateMonitorRequest.Builder, UpdateMonitorRequest> {
    private static final SdkField<String> MONITOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monitorId").getter(getter(UpdateMonitorRequest::monitorId)).setter(setter(Builder::monitorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("monitorId").build()).build();

    private static final SdkField<String> SUBDOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subdomain").getter(getter(UpdateMonitorRequest::subdomain)).setter(setter(Builder::subdomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subdomain").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateMonitorRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateMonitorRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ID_FIELD,
            SUBDOMAIN_FIELD, DISPLAY_NAME_FIELD, ROLE_ARN_FIELD));

    private final String monitorId;

    private final String subdomain;

    private final String displayName;

    private final String roleArn;

    private UpdateMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.monitorId = builder.monitorId;
        this.subdomain = builder.subdomain;
        this.displayName = builder.displayName;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The unique identifier of the monitor to update.
     * </p>
     * 
     * @return The unique identifier of the monitor to update.
     */
    public final String monitorId() {
        return monitorId;
    }

    /**
     * <p>
     * The new value of the subdomain to use when forming the monitor URL.
     * </p>
     * 
     * @return The new value of the subdomain to use when forming the monitor URL.
     */
    public final String subdomain() {
        return subdomain;
    }

    /**
     * <p>
     * The new value to use for the monitor's display name.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The new value to use for the monitor's display name.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the new IAM role to use with the monitor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the new IAM role to use with the monitor.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitorId());
        hashCode = 31 * hashCode + Objects.hashCode(subdomain());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMonitorRequest)) {
            return false;
        }
        UpdateMonitorRequest other = (UpdateMonitorRequest) obj;
        return Objects.equals(monitorId(), other.monitorId()) && Objects.equals(subdomain(), other.subdomain())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMonitorRequest").add("MonitorId", monitorId()).add("Subdomain", subdomain())
                .add("DisplayName", displayName()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "monitorId":
            return Optional.ofNullable(clazz.cast(monitorId()));
        case "subdomain":
            return Optional.ofNullable(clazz.cast(subdomain()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMonitorRequest, T> g) {
        return obj -> g.apply((UpdateMonitorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMonitorRequest> {
        /**
         * <p>
         * The unique identifier of the monitor to update.
         * </p>
         * 
         * @param monitorId
         *        The unique identifier of the monitor to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorId(String monitorId);

        /**
         * <p>
         * The new value of the subdomain to use when forming the monitor URL.
         * </p>
         * 
         * @param subdomain
         *        The new value of the subdomain to use when forming the monitor URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdomain(String subdomain);

        /**
         * <p>
         * The new value to use for the monitor's display name.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param displayName
         *        The new value to use for the monitor's display name.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the new IAM role to use with the monitor.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the new IAM role to use with the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String monitorId;

        private String subdomain;

        private String displayName;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMonitorRequest model) {
            super(model);
            monitorId(model.monitorId);
            subdomain(model.subdomain);
            displayName(model.displayName);
            roleArn(model.roleArn);
        }

        public final String getMonitorId() {
            return monitorId;
        }

        public final void setMonitorId(String monitorId) {
            this.monitorId = monitorId;
        }

        @Override
        public final Builder monitorId(String monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public final String getSubdomain() {
            return subdomain;
        }

        public final void setSubdomain(String subdomain) {
            this.subdomain = subdomain;
        }

        @Override
        public final Builder subdomain(String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMonitorRequest build() {
            return new UpdateMonitorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
