/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateJobRequest extends DeadlineRequest implements
        ToCopyableBuilder<UpdateJobRequest.Builder, UpdateJobRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(UpdateJobRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(UpdateJobRequest::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(UpdateJobRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> TARGET_TASK_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetTaskRunStatus").getter(getter(UpdateJobRequest::targetTaskRunStatusAsString))
            .setter(setter(Builder::targetTaskRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTaskRunStatus").build())
            .build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(UpdateJobRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<Integer> MAX_FAILED_TASKS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxFailedTasksCount").getter(getter(UpdateJobRequest::maxFailedTasksCount))
            .setter(setter(Builder::maxFailedTasksCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFailedTasksCount").build())
            .build();

    private static final SdkField<Integer> MAX_RETRIES_PER_TASK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxRetriesPerTask").getter(getter(UpdateJobRequest::maxRetriesPerTask))
            .setter(setter(Builder::maxRetriesPerTask))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRetriesPerTask").build()).build();

    private static final SdkField<String> LIFECYCLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStatus").getter(getter(UpdateJobRequest::lifecycleStatusAsString))
            .setter(setter(Builder::lifecycleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            FARM_ID_FIELD, QUEUE_ID_FIELD, JOB_ID_FIELD, TARGET_TASK_RUN_STATUS_FIELD, PRIORITY_FIELD,
            MAX_FAILED_TASKS_COUNT_FIELD, MAX_RETRIES_PER_TASK_FIELD, LIFECYCLE_STATUS_FIELD));

    private final String clientToken;

    private final String farmId;

    private final String queueId;

    private final String jobId;

    private final String targetTaskRunStatus;

    private final Integer priority;

    private final Integer maxFailedTasksCount;

    private final Integer maxRetriesPerTask;

    private final String lifecycleStatus;

    private UpdateJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.queueId = builder.queueId;
        this.jobId = builder.jobId;
        this.targetTaskRunStatus = builder.targetTaskRunStatus;
        this.priority = builder.priority;
        this.maxFailedTasksCount = builder.maxFailedTasksCount;
        this.maxRetriesPerTask = builder.maxRetriesPerTask;
        this.lifecycleStatus = builder.lifecycleStatus;
    }

    /**
     * <p>
     * The unique token which the server uses to recognize retries of the same request.
     * </p>
     * 
     * @return The unique token which the server uses to recognize retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The farm ID of the job to update.
     * </p>
     * 
     * @return The farm ID of the job to update.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The queue ID of the job to update.
     * </p>
     * 
     * @return The queue ID of the job to update.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The job ID to update.
     * </p>
     * 
     * @return The job ID to update.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The task status to update the job's tasks to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetTaskRunStatus} will return {@link JobTargetTaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetTaskRunStatusAsString}.
     * </p>
     * 
     * @return The task status to update the job's tasks to.
     * @see JobTargetTaskRunStatus
     */
    public final JobTargetTaskRunStatus targetTaskRunStatus() {
        return JobTargetTaskRunStatus.fromValue(targetTaskRunStatus);
    }

    /**
     * <p>
     * The task status to update the job's tasks to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetTaskRunStatus} will return {@link JobTargetTaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetTaskRunStatusAsString}.
     * </p>
     * 
     * @return The task status to update the job's tasks to.
     * @see JobTargetTaskRunStatus
     */
    public final String targetTaskRunStatusAsString() {
        return targetTaskRunStatus;
    }

    /**
     * <p>
     * The job priority to update.
     * </p>
     * 
     * @return The job priority to update.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The number of task failures before the job stops running and is marked as <code>FAILED</code>.
     * </p>
     * 
     * @return The number of task failures before the job stops running and is marked as <code>FAILED</code>.
     */
    public final Integer maxFailedTasksCount() {
        return maxFailedTasksCount;
    }

    /**
     * <p>
     * The maximum number of retries for a job.
     * </p>
     * 
     * @return The maximum number of retries for a job.
     */
    public final Integer maxRetriesPerTask() {
        return maxRetriesPerTask;
    }

    /**
     * <p>
     * The status of a job in its lifecycle. When you change the status of the job to <code>ARCHIVED</code>, the job
     * can't be scheduled or archived.
     * </p>
     * <important>
     * <p>
     * An archived jobs and its steps and tasks are deleted after 120 days. The job can't be recovered.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStatus}
     * will return {@link UpdateJobLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleStatusAsString}.
     * </p>
     * 
     * @return The status of a job in its lifecycle. When you change the status of the job to <code>ARCHIVED</code>, the
     *         job can't be scheduled or archived.</p> <important>
     *         <p>
     *         An archived jobs and its steps and tasks are deleted after 120 days. The job can't be recovered.
     *         </p>
     * @see UpdateJobLifecycleStatus
     */
    public final UpdateJobLifecycleStatus lifecycleStatus() {
        return UpdateJobLifecycleStatus.fromValue(lifecycleStatus);
    }

    /**
     * <p>
     * The status of a job in its lifecycle. When you change the status of the job to <code>ARCHIVED</code>, the job
     * can't be scheduled or archived.
     * </p>
     * <important>
     * <p>
     * An archived jobs and its steps and tasks are deleted after 120 days. The job can't be recovered.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStatus}
     * will return {@link UpdateJobLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleStatusAsString}.
     * </p>
     * 
     * @return The status of a job in its lifecycle. When you change the status of the job to <code>ARCHIVED</code>, the
     *         job can't be scheduled or archived.</p> <important>
     *         <p>
     *         An archived jobs and its steps and tasks are deleted after 120 days. The job can't be recovered.
     *         </p>
     * @see UpdateJobLifecycleStatus
     */
    public final String lifecycleStatusAsString() {
        return lifecycleStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(targetTaskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(maxFailedTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetriesPerTask());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobRequest)) {
            return false;
        }
        UpdateJobRequest other = (UpdateJobRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(farmId(), other.farmId())
                && Objects.equals(queueId(), other.queueId()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(targetTaskRunStatusAsString(), other.targetTaskRunStatusAsString())
                && Objects.equals(priority(), other.priority())
                && Objects.equals(maxFailedTasksCount(), other.maxFailedTasksCount())
                && Objects.equals(maxRetriesPerTask(), other.maxRetriesPerTask())
                && Objects.equals(lifecycleStatusAsString(), other.lifecycleStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateJobRequest").add("ClientToken", clientToken()).add("FarmId", farmId())
                .add("QueueId", queueId()).add("JobId", jobId()).add("TargetTaskRunStatus", targetTaskRunStatusAsString())
                .add("Priority", priority()).add("MaxFailedTasksCount", maxFailedTasksCount())
                .add("MaxRetriesPerTask", maxRetriesPerTask()).add("LifecycleStatus", lifecycleStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "targetTaskRunStatus":
            return Optional.ofNullable(clazz.cast(targetTaskRunStatusAsString()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "maxFailedTasksCount":
            return Optional.ofNullable(clazz.cast(maxFailedTasksCount()));
        case "maxRetriesPerTask":
            return Optional.ofNullable(clazz.cast(maxRetriesPerTask()));
        case "lifecycleStatus":
            return Optional.ofNullable(clazz.cast(lifecycleStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobRequest, T> g) {
        return obj -> g.apply((UpdateJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateJobRequest> {
        /**
         * <p>
         * The unique token which the server uses to recognize retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        The unique token which the server uses to recognize retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The farm ID of the job to update.
         * </p>
         * 
         * @param farmId
         *        The farm ID of the job to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The queue ID of the job to update.
         * </p>
         * 
         * @param queueId
         *        The queue ID of the job to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The job ID to update.
         * </p>
         * 
         * @param jobId
         *        The job ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The task status to update the job's tasks to.
         * </p>
         * 
         * @param targetTaskRunStatus
         *        The task status to update the job's tasks to.
         * @see JobTargetTaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobTargetTaskRunStatus
         */
        Builder targetTaskRunStatus(String targetTaskRunStatus);

        /**
         * <p>
         * The task status to update the job's tasks to.
         * </p>
         * 
         * @param targetTaskRunStatus
         *        The task status to update the job's tasks to.
         * @see JobTargetTaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobTargetTaskRunStatus
         */
        Builder targetTaskRunStatus(JobTargetTaskRunStatus targetTaskRunStatus);

        /**
         * <p>
         * The job priority to update.
         * </p>
         * 
         * @param priority
         *        The job priority to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The number of task failures before the job stops running and is marked as <code>FAILED</code>.
         * </p>
         * 
         * @param maxFailedTasksCount
         *        The number of task failures before the job stops running and is marked as <code>FAILED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFailedTasksCount(Integer maxFailedTasksCount);

        /**
         * <p>
         * The maximum number of retries for a job.
         * </p>
         * 
         * @param maxRetriesPerTask
         *        The maximum number of retries for a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetriesPerTask(Integer maxRetriesPerTask);

        /**
         * <p>
         * The status of a job in its lifecycle. When you change the status of the job to <code>ARCHIVED</code>, the job
         * can't be scheduled or archived.
         * </p>
         * <important>
         * <p>
         * An archived jobs and its steps and tasks are deleted after 120 days. The job can't be recovered.
         * </p>
         * </important>
         * 
         * @param lifecycleStatus
         *        The status of a job in its lifecycle. When you change the status of the job to <code>ARCHIVED</code>,
         *        the job can't be scheduled or archived.</p> <important>
         *        <p>
         *        An archived jobs and its steps and tasks are deleted after 120 days. The job can't be recovered.
         *        </p>
         * @see UpdateJobLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateJobLifecycleStatus
         */
        Builder lifecycleStatus(String lifecycleStatus);

        /**
         * <p>
         * The status of a job in its lifecycle. When you change the status of the job to <code>ARCHIVED</code>, the job
         * can't be scheduled or archived.
         * </p>
         * <important>
         * <p>
         * An archived jobs and its steps and tasks are deleted after 120 days. The job can't be recovered.
         * </p>
         * </important>
         * 
         * @param lifecycleStatus
         *        The status of a job in its lifecycle. When you change the status of the job to <code>ARCHIVED</code>,
         *        the job can't be scheduled or archived.</p> <important>
         *        <p>
         *        An archived jobs and its steps and tasks are deleted after 120 days. The job can't be recovered.
         *        </p>
         * @see UpdateJobLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateJobLifecycleStatus
         */
        Builder lifecycleStatus(UpdateJobLifecycleStatus lifecycleStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String farmId;

        private String queueId;

        private String jobId;

        private String targetTaskRunStatus;

        private Integer priority;

        private Integer maxFailedTasksCount;

        private Integer maxRetriesPerTask;

        private String lifecycleStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobRequest model) {
            super(model);
            clientToken(model.clientToken);
            farmId(model.farmId);
            queueId(model.queueId);
            jobId(model.jobId);
            targetTaskRunStatus(model.targetTaskRunStatus);
            priority(model.priority);
            maxFailedTasksCount(model.maxFailedTasksCount);
            maxRetriesPerTask(model.maxRetriesPerTask);
            lifecycleStatus(model.lifecycleStatus);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getTargetTaskRunStatus() {
            return targetTaskRunStatus;
        }

        public final void setTargetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
        }

        @Override
        public final Builder targetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
            return this;
        }

        @Override
        public final Builder targetTaskRunStatus(JobTargetTaskRunStatus targetTaskRunStatus) {
            this.targetTaskRunStatus(targetTaskRunStatus == null ? null : targetTaskRunStatus.toString());
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Integer getMaxFailedTasksCount() {
            return maxFailedTasksCount;
        }

        public final void setMaxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
        }

        @Override
        public final Builder maxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
            return this;
        }

        public final Integer getMaxRetriesPerTask() {
            return maxRetriesPerTask;
        }

        public final void setMaxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
        }

        @Override
        public final Builder maxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
            return this;
        }

        public final String getLifecycleStatus() {
            return lifecycleStatus;
        }

        public final void setLifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
        }

        @Override
        public final Builder lifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        @Override
        public final Builder lifecycleStatus(UpdateJobLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus(lifecycleStatus == null ? null : lifecycleStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobRequest build() {
            return new UpdateJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
