/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSessionsStatisticsAggregationResponse extends DeadlineResponse implements
        ToCopyableBuilder<StartSessionsStatisticsAggregationResponse.Builder, StartSessionsStatisticsAggregationResponse> {
    private static final SdkField<String> AGGREGATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregationId").getter(getter(StartSessionsStatisticsAggregationResponse::aggregationId))
            .setter(setter(Builder::aggregationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_ID_FIELD));

    private final String aggregationId;

    private StartSessionsStatisticsAggregationResponse(BuilderImpl builder) {
        super(builder);
        this.aggregationId = builder.aggregationId;
    }

    /**
     * <p>
     * A unique identifier for the aggregated statistics. Use this identifier with the
     * <code>GetAggregatedStatisticsForSessions</code> operation to return the statistics.
     * </p>
     * 
     * @return A unique identifier for the aggregated statistics. Use this identifier with the
     *         <code>GetAggregatedStatisticsForSessions</code> operation to return the statistics.
     */
    public final String aggregationId() {
        return aggregationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aggregationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSessionsStatisticsAggregationResponse)) {
            return false;
        }
        StartSessionsStatisticsAggregationResponse other = (StartSessionsStatisticsAggregationResponse) obj;
        return Objects.equals(aggregationId(), other.aggregationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSessionsStatisticsAggregationResponse").add("AggregationId", aggregationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aggregationId":
            return Optional.ofNullable(clazz.cast(aggregationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSessionsStatisticsAggregationResponse, T> g) {
        return obj -> g.apply((StartSessionsStatisticsAggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartSessionsStatisticsAggregationResponse> {
        /**
         * <p>
         * A unique identifier for the aggregated statistics. Use this identifier with the
         * <code>GetAggregatedStatisticsForSessions</code> operation to return the statistics.
         * </p>
         * 
         * @param aggregationId
         *        A unique identifier for the aggregated statistics. Use this identifier with the
         *        <code>GetAggregatedStatisticsForSessions</code> operation to return the statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationId(String aggregationId);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private String aggregationId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSessionsStatisticsAggregationResponse model) {
            super(model);
            aggregationId(model.aggregationId);
        }

        public final String getAggregationId() {
            return aggregationId;
        }

        public final void setAggregationId(String aggregationId) {
            this.aggregationId = aggregationId;
        }

        @Override
        public final Builder aggregationId(String aggregationId) {
            this.aggregationId = aggregationId;
            return this;
        }

        @Override
        public StartSessionsStatisticsAggregationResponse build() {
            return new StartSessionsStatisticsAggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
