/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a job entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobEntity implements SdkPojo, Serializable, ToCopyableBuilder<JobEntity.Builder, JobEntity> {
    private static final SdkField<JobDetailsEntity> JOB_DETAILS_FIELD = SdkField
            .<JobDetailsEntity> builder(MarshallingType.SDK_POJO).memberName("jobDetails").getter(getter(JobEntity::jobDetails))
            .setter(setter(Builder::jobDetails)).constructor(JobDetailsEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDetails").build()).build();

    private static final SdkField<JobAttachmentDetailsEntity> JOB_ATTACHMENT_DETAILS_FIELD = SdkField
            .<JobAttachmentDetailsEntity> builder(MarshallingType.SDK_POJO).memberName("jobAttachmentDetails")
            .getter(getter(JobEntity::jobAttachmentDetails)).setter(setter(Builder::jobAttachmentDetails))
            .constructor(JobAttachmentDetailsEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobAttachmentDetails").build())
            .build();

    private static final SdkField<StepDetailsEntity> STEP_DETAILS_FIELD = SdkField
            .<StepDetailsEntity> builder(MarshallingType.SDK_POJO).memberName("stepDetails")
            .getter(getter(JobEntity::stepDetails)).setter(setter(Builder::stepDetails)).constructor(StepDetailsEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepDetails").build()).build();

    private static final SdkField<EnvironmentDetailsEntity> ENVIRONMENT_DETAILS_FIELD = SdkField
            .<EnvironmentDetailsEntity> builder(MarshallingType.SDK_POJO).memberName("environmentDetails")
            .getter(getter(JobEntity::environmentDetails)).setter(setter(Builder::environmentDetails))
            .constructor(EnvironmentDetailsEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DETAILS_FIELD,
            JOB_ATTACHMENT_DETAILS_FIELD, STEP_DETAILS_FIELD, ENVIRONMENT_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final JobDetailsEntity jobDetails;

    private final JobAttachmentDetailsEntity jobAttachmentDetails;

    private final StepDetailsEntity stepDetails;

    private final EnvironmentDetailsEntity environmentDetails;

    private final Type type;

    private JobEntity(BuilderImpl builder) {
        this.jobDetails = builder.jobDetails;
        this.jobAttachmentDetails = builder.jobAttachmentDetails;
        this.stepDetails = builder.stepDetails;
        this.environmentDetails = builder.environmentDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * The job details.
     * </p>
     * 
     * @return The job details.
     */
    public final JobDetailsEntity jobDetails() {
        return jobDetails;
    }

    /**
     * <p>
     * The job attachment details.
     * </p>
     * 
     * @return The job attachment details.
     */
    public final JobAttachmentDetailsEntity jobAttachmentDetails() {
        return jobAttachmentDetails;
    }

    /**
     * <p>
     * The step details.
     * </p>
     * 
     * @return The step details.
     */
    public final StepDetailsEntity stepDetails() {
        return stepDetails;
    }

    /**
     * <p>
     * The environment details for the job entity.
     * </p>
     * 
     * @return The environment details for the job entity.
     */
    public final EnvironmentDetailsEntity environmentDetails() {
        return environmentDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobDetails());
        hashCode = 31 * hashCode + Objects.hashCode(jobAttachmentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(stepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(environmentDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobEntity)) {
            return false;
        }
        JobEntity other = (JobEntity) obj;
        return Objects.equals(jobDetails(), other.jobDetails())
                && Objects.equals(jobAttachmentDetails(), other.jobAttachmentDetails())
                && Objects.equals(stepDetails(), other.stepDetails())
                && Objects.equals(environmentDetails(), other.environmentDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobEntity").add("JobDetails", jobDetails()).add("JobAttachmentDetails", jobAttachmentDetails())
                .add("StepDetails", stepDetails()).add("EnvironmentDetails", environmentDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDetails":
            return Optional.ofNullable(clazz.cast(jobDetails()));
        case "jobAttachmentDetails":
            return Optional.ofNullable(clazz.cast(jobAttachmentDetails()));
        case "stepDetails":
            return Optional.ofNullable(clazz.cast(stepDetails()));
        case "environmentDetails":
            return Optional.ofNullable(clazz.cast(environmentDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #jobDetails()} initialized to the given value.
     *
     * <p>
     * The job details.
     * </p>
     * 
     * @param jobDetails
     *        The job details.
     */
    public static JobEntity fromJobDetails(JobDetailsEntity jobDetails) {
        return builder().jobDetails(jobDetails).build();
    }

    /**
     * Create an instance of this class with {@link #jobDetails()} initialized to the given value.
     *
     * <p>
     * The job details.
     * </p>
     * 
     * @param jobDetails
     *        The job details.
     */
    public static JobEntity fromJobDetails(Consumer<JobDetailsEntity.Builder> jobDetails) {
        JobDetailsEntity.Builder builder = JobDetailsEntity.builder();
        jobDetails.accept(builder);
        return fromJobDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #jobAttachmentDetails()} initialized to the given value.
     *
     * <p>
     * The job attachment details.
     * </p>
     * 
     * @param jobAttachmentDetails
     *        The job attachment details.
     */
    public static JobEntity fromJobAttachmentDetails(JobAttachmentDetailsEntity jobAttachmentDetails) {
        return builder().jobAttachmentDetails(jobAttachmentDetails).build();
    }

    /**
     * Create an instance of this class with {@link #jobAttachmentDetails()} initialized to the given value.
     *
     * <p>
     * The job attachment details.
     * </p>
     * 
     * @param jobAttachmentDetails
     *        The job attachment details.
     */
    public static JobEntity fromJobAttachmentDetails(Consumer<JobAttachmentDetailsEntity.Builder> jobAttachmentDetails) {
        JobAttachmentDetailsEntity.Builder builder = JobAttachmentDetailsEntity.builder();
        jobAttachmentDetails.accept(builder);
        return fromJobAttachmentDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #stepDetails()} initialized to the given value.
     *
     * <p>
     * The step details.
     * </p>
     * 
     * @param stepDetails
     *        The step details.
     */
    public static JobEntity fromStepDetails(StepDetailsEntity stepDetails) {
        return builder().stepDetails(stepDetails).build();
    }

    /**
     * Create an instance of this class with {@link #stepDetails()} initialized to the given value.
     *
     * <p>
     * The step details.
     * </p>
     * 
     * @param stepDetails
     *        The step details.
     */
    public static JobEntity fromStepDetails(Consumer<StepDetailsEntity.Builder> stepDetails) {
        StepDetailsEntity.Builder builder = StepDetailsEntity.builder();
        stepDetails.accept(builder);
        return fromStepDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #environmentDetails()} initialized to the given value.
     *
     * <p>
     * The environment details for the job entity.
     * </p>
     * 
     * @param environmentDetails
     *        The environment details for the job entity.
     */
    public static JobEntity fromEnvironmentDetails(EnvironmentDetailsEntity environmentDetails) {
        return builder().environmentDetails(environmentDetails).build();
    }

    /**
     * Create an instance of this class with {@link #environmentDetails()} initialized to the given value.
     *
     * <p>
     * The environment details for the job entity.
     * </p>
     * 
     * @param environmentDetails
     *        The environment details for the job entity.
     */
    public static JobEntity fromEnvironmentDetails(Consumer<EnvironmentDetailsEntity.Builder> environmentDetails) {
        EnvironmentDetailsEntity.Builder builder = EnvironmentDetailsEntity.builder();
        environmentDetails.accept(builder);
        return fromEnvironmentDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobEntity, T> g) {
        return obj -> g.apply((JobEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobEntity> {
        /**
         * <p>
         * The job details.
         * </p>
         * 
         * @param jobDetails
         *        The job details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDetails(JobDetailsEntity jobDetails);

        /**
         * <p>
         * The job details.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobDetailsEntity.Builder} avoiding the
         * need to create one manually via {@link JobDetailsEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobDetailsEntity.Builder#build()} is called immediately and its
         * result is passed to {@link #jobDetails(JobDetailsEntity)}.
         * 
         * @param jobDetails
         *        a consumer that will call methods on {@link JobDetailsEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobDetails(JobDetailsEntity)
         */
        default Builder jobDetails(Consumer<JobDetailsEntity.Builder> jobDetails) {
            return jobDetails(JobDetailsEntity.builder().applyMutation(jobDetails).build());
        }

        /**
         * <p>
         * The job attachment details.
         * </p>
         * 
         * @param jobAttachmentDetails
         *        The job attachment details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobAttachmentDetails(JobAttachmentDetailsEntity jobAttachmentDetails);

        /**
         * <p>
         * The job attachment details.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobAttachmentDetailsEntity.Builder}
         * avoiding the need to create one manually via {@link JobAttachmentDetailsEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobAttachmentDetailsEntity.Builder#build()} is called immediately
         * and its result is passed to {@link #jobAttachmentDetails(JobAttachmentDetailsEntity)}.
         * 
         * @param jobAttachmentDetails
         *        a consumer that will call methods on {@link JobAttachmentDetailsEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobAttachmentDetails(JobAttachmentDetailsEntity)
         */
        default Builder jobAttachmentDetails(Consumer<JobAttachmentDetailsEntity.Builder> jobAttachmentDetails) {
            return jobAttachmentDetails(JobAttachmentDetailsEntity.builder().applyMutation(jobAttachmentDetails).build());
        }

        /**
         * <p>
         * The step details.
         * </p>
         * 
         * @param stepDetails
         *        The step details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepDetails(StepDetailsEntity stepDetails);

        /**
         * <p>
         * The step details.
         * </p>
         * This is a convenience method that creates an instance of the {@link StepDetailsEntity.Builder} avoiding the
         * need to create one manually via {@link StepDetailsEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StepDetailsEntity.Builder#build()} is called immediately and its
         * result is passed to {@link #stepDetails(StepDetailsEntity)}.
         * 
         * @param stepDetails
         *        a consumer that will call methods on {@link StepDetailsEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepDetails(StepDetailsEntity)
         */
        default Builder stepDetails(Consumer<StepDetailsEntity.Builder> stepDetails) {
            return stepDetails(StepDetailsEntity.builder().applyMutation(stepDetails).build());
        }

        /**
         * <p>
         * The environment details for the job entity.
         * </p>
         * 
         * @param environmentDetails
         *        The environment details for the job entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentDetails(EnvironmentDetailsEntity environmentDetails);

        /**
         * <p>
         * The environment details for the job entity.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentDetailsEntity.Builder}
         * avoiding the need to create one manually via {@link EnvironmentDetailsEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentDetailsEntity.Builder#build()} is called immediately
         * and its result is passed to {@link #environmentDetails(EnvironmentDetailsEntity)}.
         * 
         * @param environmentDetails
         *        a consumer that will call methods on {@link EnvironmentDetailsEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentDetails(EnvironmentDetailsEntity)
         */
        default Builder environmentDetails(Consumer<EnvironmentDetailsEntity.Builder> environmentDetails) {
            return environmentDetails(EnvironmentDetailsEntity.builder().applyMutation(environmentDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JobDetailsEntity jobDetails;

        private JobAttachmentDetailsEntity jobAttachmentDetails;

        private StepDetailsEntity stepDetails;

        private EnvironmentDetailsEntity environmentDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(JobEntity model) {
            jobDetails(model.jobDetails);
            jobAttachmentDetails(model.jobAttachmentDetails);
            stepDetails(model.stepDetails);
            environmentDetails(model.environmentDetails);
        }

        public final JobDetailsEntity.Builder getJobDetails() {
            return jobDetails != null ? jobDetails.toBuilder() : null;
        }

        public final void setJobDetails(JobDetailsEntity.BuilderImpl jobDetails) {
            Object oldValue = this.jobDetails;
            this.jobDetails = jobDetails != null ? jobDetails.build() : null;
            handleUnionValueChange(Type.JOB_DETAILS, oldValue, this.jobDetails);
        }

        @Override
        public final Builder jobDetails(JobDetailsEntity jobDetails) {
            Object oldValue = this.jobDetails;
            this.jobDetails = jobDetails;
            handleUnionValueChange(Type.JOB_DETAILS, oldValue, this.jobDetails);
            return this;
        }

        public final JobAttachmentDetailsEntity.Builder getJobAttachmentDetails() {
            return jobAttachmentDetails != null ? jobAttachmentDetails.toBuilder() : null;
        }

        public final void setJobAttachmentDetails(JobAttachmentDetailsEntity.BuilderImpl jobAttachmentDetails) {
            Object oldValue = this.jobAttachmentDetails;
            this.jobAttachmentDetails = jobAttachmentDetails != null ? jobAttachmentDetails.build() : null;
            handleUnionValueChange(Type.JOB_ATTACHMENT_DETAILS, oldValue, this.jobAttachmentDetails);
        }

        @Override
        public final Builder jobAttachmentDetails(JobAttachmentDetailsEntity jobAttachmentDetails) {
            Object oldValue = this.jobAttachmentDetails;
            this.jobAttachmentDetails = jobAttachmentDetails;
            handleUnionValueChange(Type.JOB_ATTACHMENT_DETAILS, oldValue, this.jobAttachmentDetails);
            return this;
        }

        public final StepDetailsEntity.Builder getStepDetails() {
            return stepDetails != null ? stepDetails.toBuilder() : null;
        }

        public final void setStepDetails(StepDetailsEntity.BuilderImpl stepDetails) {
            Object oldValue = this.stepDetails;
            this.stepDetails = stepDetails != null ? stepDetails.build() : null;
            handleUnionValueChange(Type.STEP_DETAILS, oldValue, this.stepDetails);
        }

        @Override
        public final Builder stepDetails(StepDetailsEntity stepDetails) {
            Object oldValue = this.stepDetails;
            this.stepDetails = stepDetails;
            handleUnionValueChange(Type.STEP_DETAILS, oldValue, this.stepDetails);
            return this;
        }

        public final EnvironmentDetailsEntity.Builder getEnvironmentDetails() {
            return environmentDetails != null ? environmentDetails.toBuilder() : null;
        }

        public final void setEnvironmentDetails(EnvironmentDetailsEntity.BuilderImpl environmentDetails) {
            Object oldValue = this.environmentDetails;
            this.environmentDetails = environmentDetails != null ? environmentDetails.build() : null;
            handleUnionValueChange(Type.ENVIRONMENT_DETAILS, oldValue, this.environmentDetails);
        }

        @Override
        public final Builder environmentDetails(EnvironmentDetailsEntity environmentDetails) {
            Object oldValue = this.environmentDetails;
            this.environmentDetails = environmentDetails;
            handleUnionValueChange(Type.ENVIRONMENT_DETAILS, oldValue, this.environmentDetails);
            return this;
        }

        @Override
        public JobEntity build() {
            return new JobEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see JobEntity#type()
     */
    public enum Type {
        JOB_DETAILS,

        JOB_ATTACHMENT_DETAILS,

        STEP_DETAILS,

        ENVIRONMENT_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
