/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The job attachment settings. These are the Amazon S3 bucket name and the Amazon S3 prefix.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobAttachmentSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<JobAttachmentSettings.Builder, JobAttachmentSettings> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3BucketName").getter(getter(JobAttachmentSettings::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketName").build()).build();

    private static final SdkField<String> ROOT_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rootPrefix").getter(getter(JobAttachmentSettings::rootPrefix)).setter(setter(Builder::rootPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD,
            ROOT_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3BucketName;

    private final String rootPrefix;

    private JobAttachmentSettings(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.rootPrefix = builder.rootPrefix;
    }

    /**
     * <p>
     * The Amazon S3 bucket name.
     * </p>
     * 
     * @return The Amazon S3 bucket name.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The root prefix.
     * </p>
     * 
     * @return The root prefix.
     */
    public final String rootPrefix() {
        return rootPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(rootPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobAttachmentSettings)) {
            return false;
        }
        JobAttachmentSettings other = (JobAttachmentSettings) obj;
        return Objects.equals(s3BucketName(), other.s3BucketName()) && Objects.equals(rootPrefix(), other.rootPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobAttachmentSettings").add("S3BucketName", s3BucketName()).add("RootPrefix", rootPrefix())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "rootPrefix":
            return Optional.ofNullable(clazz.cast(rootPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobAttachmentSettings, T> g) {
        return obj -> g.apply((JobAttachmentSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobAttachmentSettings> {
        /**
         * <p>
         * The Amazon S3 bucket name.
         * </p>
         * 
         * @param s3BucketName
         *        The Amazon S3 bucket name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The root prefix.
         * </p>
         * 
         * @param rootPrefix
         *        The root prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootPrefix(String rootPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String s3BucketName;

        private String rootPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(JobAttachmentSettings model) {
            s3BucketName(model.s3BucketName);
            rootPrefix(model.rootPrefix);
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getRootPrefix() {
            return rootPrefix;
        }

        public final void setRootPrefix(String rootPrefix) {
            this.rootPrefix = rootPrefix;
        }

        @Override
        public final Builder rootPrefix(String rootPrefix) {
            this.rootPrefix = rootPrefix;
            return this;
        }

        @Override
        public JobAttachmentSettings build() {
            return new JobAttachmentSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
