/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The IP addresses for a host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpAddresses implements SdkPojo, Serializable, ToCopyableBuilder<IpAddresses.Builder, IpAddresses> {
    private static final SdkField<List<String>> IP_V4_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ipV4Addresses")
            .getter(getter(IpAddresses::ipV4Addresses))
            .setter(setter(Builder::ipV4Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipV4Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IP_V6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ipV6Addresses")
            .getter(getter(IpAddresses::ipV6Addresses))
            .setter(setter(Builder::ipV6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipV6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_V4_ADDRESSES_FIELD,
            IP_V6_ADDRESSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> ipV4Addresses;

    private final List<String> ipV6Addresses;

    private IpAddresses(BuilderImpl builder) {
        this.ipV4Addresses = builder.ipV4Addresses;
        this.ipV6Addresses = builder.ipV6Addresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpV4Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpV4Addresses() {
        return ipV4Addresses != null && !(ipV4Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IpV4 address of the network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpV4Addresses} method.
     * </p>
     * 
     * @return The IpV4 address of the network.
     */
    public final List<String> ipV4Addresses() {
        return ipV4Addresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpV6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpV6Addresses() {
        return ipV6Addresses != null && !(ipV6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IpV6 address for the network and node component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpV6Addresses} method.
     * </p>
     * 
     * @return The IpV6 address for the network and node component.
     */
    public final List<String> ipV6Addresses() {
        return ipV6Addresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIpV4Addresses() ? ipV4Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIpV6Addresses() ? ipV6Addresses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAddresses)) {
            return false;
        }
        IpAddresses other = (IpAddresses) obj;
        return hasIpV4Addresses() == other.hasIpV4Addresses() && Objects.equals(ipV4Addresses(), other.ipV4Addresses())
                && hasIpV6Addresses() == other.hasIpV6Addresses() && Objects.equals(ipV6Addresses(), other.ipV6Addresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpAddresses").add("IpV4Addresses", hasIpV4Addresses() ? ipV4Addresses() : null)
                .add("IpV6Addresses", hasIpV6Addresses() ? ipV6Addresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ipV4Addresses":
            return Optional.ofNullable(clazz.cast(ipV4Addresses()));
        case "ipV6Addresses":
            return Optional.ofNullable(clazz.cast(ipV6Addresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpAddresses, T> g) {
        return obj -> g.apply((IpAddresses) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpAddresses> {
        /**
         * <p>
         * The IpV4 address of the network.
         * </p>
         * 
         * @param ipV4Addresses
         *        The IpV4 address of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV4Addresses(Collection<String> ipV4Addresses);

        /**
         * <p>
         * The IpV4 address of the network.
         * </p>
         * 
         * @param ipV4Addresses
         *        The IpV4 address of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV4Addresses(String... ipV4Addresses);

        /**
         * <p>
         * The IpV6 address for the network and node component.
         * </p>
         * 
         * @param ipV6Addresses
         *        The IpV6 address for the network and node component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV6Addresses(Collection<String> ipV6Addresses);

        /**
         * <p>
         * The IpV6 address for the network and node component.
         * </p>
         * 
         * @param ipV6Addresses
         *        The IpV6 address for the network and node component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV6Addresses(String... ipV6Addresses);
    }

    static final class BuilderImpl implements Builder {
        private List<String> ipV4Addresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> ipV6Addresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpAddresses model) {
            ipV4Addresses(model.ipV4Addresses);
            ipV6Addresses(model.ipV6Addresses);
        }

        public final Collection<String> getIpV4Addresses() {
            if (ipV4Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipV4Addresses;
        }

        public final void setIpV4Addresses(Collection<String> ipV4Addresses) {
            this.ipV4Addresses = IpV4AddressesCopier.copy(ipV4Addresses);
        }

        @Override
        public final Builder ipV4Addresses(Collection<String> ipV4Addresses) {
            this.ipV4Addresses = IpV4AddressesCopier.copy(ipV4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV4Addresses(String... ipV4Addresses) {
            ipV4Addresses(Arrays.asList(ipV4Addresses));
            return this;
        }

        public final Collection<String> getIpV6Addresses() {
            if (ipV6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipV6Addresses;
        }

        public final void setIpV6Addresses(Collection<String> ipV6Addresses) {
            this.ipV6Addresses = IpV6AddressesCopier.copy(ipV6Addresses);
        }

        @Override
        public final Builder ipV6Addresses(Collection<String> ipV6Addresses) {
            this.ipV6Addresses = IpV6AddressesCopier.copy(ipV6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV6Addresses(String... ipV6Addresses) {
            ipV6Addresses(Arrays.asList(ipV6Addresses));
            return this;
        }

        @Override
        public IpAddresses build() {
            return new IpAddresses(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
