/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStorageProfileResponse extends DeadlineResponse implements
        ToCopyableBuilder<GetStorageProfileResponse.Builder, GetStorageProfileResponse> {
    private static final SdkField<String> STORAGE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageProfileId").getter(getter(GetStorageProfileResponse::storageProfileId))
            .setter(setter(Builder::storageProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageProfileId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(GetStorageProfileResponse::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> OS_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("osFamily").getter(getter(GetStorageProfileResponse::osFamilyAsString)).setter(setter(Builder::osFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osFamily").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetStorageProfileResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetStorageProfileResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetStorageProfileResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(GetStorageProfileResponse::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<List<FileSystemLocation>> FILE_SYSTEM_LOCATIONS_FIELD = SdkField
            .<List<FileSystemLocation>> builder(MarshallingType.LIST)
            .memberName("fileSystemLocations")
            .getter(getter(GetStorageProfileResponse::fileSystemLocations))
            .setter(setter(Builder::fileSystemLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileSystemLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileSystemLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_PROFILE_ID_FIELD,
            DISPLAY_NAME_FIELD, OS_FAMILY_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD,
            FILE_SYSTEM_LOCATIONS_FIELD));

    private final String storageProfileId;

    private final String displayName;

    private final String osFamily;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private final List<FileSystemLocation> fileSystemLocations;

    private GetStorageProfileResponse(BuilderImpl builder) {
        super(builder);
        this.storageProfileId = builder.storageProfileId;
        this.displayName = builder.displayName;
        this.osFamily = builder.osFamily;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.fileSystemLocations = builder.fileSystemLocations;
    }

    /**
     * <p>
     * The storage profile ID.
     * </p>
     * 
     * @return The storage profile ID.
     */
    public final String storageProfileId() {
        return storageProfileId;
    }

    /**
     * <p>
     * The display name of the storage profile.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The display name of the storage profile.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The operating system (OS) for the storage profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osFamily} will
     * return {@link StorageProfileOperatingSystemFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #osFamilyAsString}.
     * </p>
     * 
     * @return The operating system (OS) for the storage profile.
     * @see StorageProfileOperatingSystemFamily
     */
    public final StorageProfileOperatingSystemFamily osFamily() {
        return StorageProfileOperatingSystemFamily.fromValue(osFamily);
    }

    /**
     * <p>
     * The operating system (OS) for the storage profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osFamily} will
     * return {@link StorageProfileOperatingSystemFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #osFamilyAsString}.
     * </p>
     * 
     * @return The operating system (OS) for the storage profile.
     * @see StorageProfileOperatingSystemFamily
     */
    public final String osFamilyAsString() {
        return osFamily;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user or system that created this resource.
     * </p>
     * 
     * @return The user or system that created this resource.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the resource was updated.
     * </p>
     * 
     * @return The date and time the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user or system that updated this resource.
     * </p>
     * 
     * @return The user or system that updated this resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileSystemLocations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFileSystemLocations() {
        return fileSystemLocations != null && !(fileSystemLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The location of the files for the storage profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileSystemLocations} method.
     * </p>
     * 
     * @return The location of the files for the storage profile.
     */
    public final List<FileSystemLocation> fileSystemLocations() {
        return fileSystemLocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(osFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasFileSystemLocations() ? fileSystemLocations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStorageProfileResponse)) {
            return false;
        }
        GetStorageProfileResponse other = (GetStorageProfileResponse) obj;
        return Objects.equals(storageProfileId(), other.storageProfileId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(osFamilyAsString(), other.osFamilyAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(updatedBy(), other.updatedBy()) && hasFileSystemLocations() == other.hasFileSystemLocations()
                && Objects.equals(fileSystemLocations(), other.fileSystemLocations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStorageProfileResponse").add("StorageProfileId", storageProfileId())
                .add("DisplayName", displayName()).add("OsFamily", osFamilyAsString()).add("CreatedAt", createdAt())
                .add("CreatedBy", createdBy()).add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy())
                .add("FileSystemLocations", fileSystemLocations() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storageProfileId":
            return Optional.ofNullable(clazz.cast(storageProfileId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "osFamily":
            return Optional.ofNullable(clazz.cast(osFamilyAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "fileSystemLocations":
            return Optional.ofNullable(clazz.cast(fileSystemLocations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStorageProfileResponse, T> g) {
        return obj -> g.apply((GetStorageProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStorageProfileResponse> {
        /**
         * <p>
         * The storage profile ID.
         * </p>
         * 
         * @param storageProfileId
         *        The storage profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageProfileId(String storageProfileId);

        /**
         * <p>
         * The display name of the storage profile.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param displayName
         *        The display name of the storage profile.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The operating system (OS) for the storage profile.
         * </p>
         * 
         * @param osFamily
         *        The operating system (OS) for the storage profile.
         * @see StorageProfileOperatingSystemFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageProfileOperatingSystemFamily
         */
        Builder osFamily(String osFamily);

        /**
         * <p>
         * The operating system (OS) for the storage profile.
         * </p>
         * 
         * @param osFamily
         *        The operating system (OS) for the storage profile.
         * @see StorageProfileOperatingSystemFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageProfileOperatingSystemFamily
         */
        Builder osFamily(StorageProfileOperatingSystemFamily osFamily);

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user or system that created this resource.
         * </p>
         * 
         * @param createdBy
         *        The user or system that created this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user or system that updated this resource.
         * </p>
         * 
         * @param updatedBy
         *        The user or system that updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The location of the files for the storage profile.
         * </p>
         * 
         * @param fileSystemLocations
         *        The location of the files for the storage profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemLocations(Collection<FileSystemLocation> fileSystemLocations);

        /**
         * <p>
         * The location of the files for the storage profile.
         * </p>
         * 
         * @param fileSystemLocations
         *        The location of the files for the storage profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemLocations(FileSystemLocation... fileSystemLocations);

        /**
         * <p>
         * The location of the files for the storage profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.FileSystemLocation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.deadline.model.FileSystemLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.FileSystemLocation.Builder#build()} is called
         * immediately and its result is passed to {@link #fileSystemLocations(List<FileSystemLocation>)}.
         * 
         * @param fileSystemLocations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.FileSystemLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemLocations(java.util.Collection<FileSystemLocation>)
         */
        Builder fileSystemLocations(Consumer<FileSystemLocation.Builder>... fileSystemLocations);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private String storageProfileId;

        private String displayName;

        private String osFamily;

        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private List<FileSystemLocation> fileSystemLocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetStorageProfileResponse model) {
            super(model);
            storageProfileId(model.storageProfileId);
            displayName(model.displayName);
            osFamily(model.osFamily);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            fileSystemLocations(model.fileSystemLocations);
        }

        public final String getStorageProfileId() {
            return storageProfileId;
        }

        public final void setStorageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
        }

        @Override
        public final Builder storageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getOsFamily() {
            return osFamily;
        }

        public final void setOsFamily(String osFamily) {
            this.osFamily = osFamily;
        }

        @Override
        public final Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        @Override
        public final Builder osFamily(StorageProfileOperatingSystemFamily osFamily) {
            this.osFamily(osFamily == null ? null : osFamily.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final List<FileSystemLocation.Builder> getFileSystemLocations() {
            List<FileSystemLocation.Builder> result = FileSystemLocationsListCopier.copyToBuilder(this.fileSystemLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemLocations(Collection<FileSystemLocation.BuilderImpl> fileSystemLocations) {
            this.fileSystemLocations = FileSystemLocationsListCopier.copyFromBuilder(fileSystemLocations);
        }

        @Override
        public final Builder fileSystemLocations(Collection<FileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = FileSystemLocationsListCopier.copy(fileSystemLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(FileSystemLocation... fileSystemLocations) {
            fileSystemLocations(Arrays.asList(fileSystemLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(Consumer<FileSystemLocation.Builder>... fileSystemLocations) {
            fileSystemLocations(Stream.of(fileSystemLocations).map(c -> FileSystemLocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetStorageProfileResponse build() {
            return new GetStorageProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
