/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStepResponse extends DeadlineResponse implements
        ToCopyableBuilder<GetStepResponse.Builder, GetStepResponse> {
    private static final SdkField<String> STEP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stepId")
            .getter(getter(GetStepResponse::stepId)).setter(setter(Builder::stepId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetStepResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> LIFECYCLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStatus").getter(getter(GetStepResponse::lifecycleStatusAsString))
            .setter(setter(Builder::lifecycleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatus").build()).build();

    private static final SdkField<String> LIFECYCLE_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStatusMessage").getter(getter(GetStepResponse::lifecycleStatusMessage))
            .setter(setter(Builder::lifecycleStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatusMessage").build())
            .build();

    private static final SdkField<String> TASK_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskRunStatus").getter(getter(GetStepResponse::taskRunStatusAsString))
            .setter(setter(Builder::taskRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatus").build()).build();

    private static final SdkField<Map<String, Integer>> TASK_RUN_STATUS_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("taskRunStatusCounts")
            .getter(getter(GetStepResponse::taskRunStatusCountsAsStrings))
            .setter(setter(Builder::taskRunStatusCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatusCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TARGET_TASK_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetTaskRunStatus").getter(getter(GetStepResponse::targetTaskRunStatusAsString))
            .setter(setter(Builder::targetTaskRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTaskRunStatus").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetStepResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetStepResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetStepResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(GetStepResponse::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(GetStepResponse::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(GetStepResponse::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<DependencyCounts> DEPENDENCY_COUNTS_FIELD = SdkField
            .<DependencyCounts> builder(MarshallingType.SDK_POJO).memberName("dependencyCounts")
            .getter(getter(GetStepResponse::dependencyCounts)).setter(setter(Builder::dependencyCounts))
            .constructor(DependencyCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencyCounts").build()).build();

    private static final SdkField<StepRequiredCapabilities> REQUIRED_CAPABILITIES_FIELD = SdkField
            .<StepRequiredCapabilities> builder(MarshallingType.SDK_POJO).memberName("requiredCapabilities")
            .getter(getter(GetStepResponse::requiredCapabilities)).setter(setter(Builder::requiredCapabilities))
            .constructor(StepRequiredCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredCapabilities").build())
            .build();

    private static final SdkField<ParameterSpace> PARAMETER_SPACE_FIELD = SdkField
            .<ParameterSpace> builder(MarshallingType.SDK_POJO).memberName("parameterSpace")
            .getter(getter(GetStepResponse::parameterSpace)).setter(setter(Builder::parameterSpace))
            .constructor(ParameterSpace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterSpace").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetStepResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_ID_FIELD, NAME_FIELD,
            LIFECYCLE_STATUS_FIELD, LIFECYCLE_STATUS_MESSAGE_FIELD, TASK_RUN_STATUS_FIELD, TASK_RUN_STATUS_COUNTS_FIELD,
            TARGET_TASK_RUN_STATUS_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD,
            STARTED_AT_FIELD, ENDED_AT_FIELD, DEPENDENCY_COUNTS_FIELD, REQUIRED_CAPABILITIES_FIELD, PARAMETER_SPACE_FIELD,
            DESCRIPTION_FIELD));

    private final String stepId;

    private final String name;

    private final String lifecycleStatus;

    private final String lifecycleStatusMessage;

    private final String taskRunStatus;

    private final Map<String, Integer> taskRunStatusCounts;

    private final String targetTaskRunStatus;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private final Instant startedAt;

    private final Instant endedAt;

    private final DependencyCounts dependencyCounts;

    private final StepRequiredCapabilities requiredCapabilities;

    private final ParameterSpace parameterSpace;

    private final String description;

    private GetStepResponse(BuilderImpl builder) {
        super(builder);
        this.stepId = builder.stepId;
        this.name = builder.name;
        this.lifecycleStatus = builder.lifecycleStatus;
        this.lifecycleStatusMessage = builder.lifecycleStatusMessage;
        this.taskRunStatus = builder.taskRunStatus;
        this.taskRunStatusCounts = builder.taskRunStatusCounts;
        this.targetTaskRunStatus = builder.targetTaskRunStatus;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.dependencyCounts = builder.dependencyCounts;
        this.requiredCapabilities = builder.requiredCapabilities;
        this.parameterSpace = builder.parameterSpace;
        this.description = builder.description;
    }

    /**
     * <p>
     * The step ID.
     * </p>
     * 
     * @return The step ID.
     */
    public final String stepId() {
        return stepId;
    }

    /**
     * <p>
     * The name of the step.
     * </p>
     * 
     * @return The name of the step.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The life cycle status of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStatus}
     * will return {@link StepLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status of the step.
     * @see StepLifecycleStatus
     */
    public final StepLifecycleStatus lifecycleStatus() {
        return StepLifecycleStatus.fromValue(lifecycleStatus);
    }

    /**
     * <p>
     * The life cycle status of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStatus}
     * will return {@link StepLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status of the step.
     * @see StepLifecycleStatus
     */
    public final String lifecycleStatusAsString() {
        return lifecycleStatus;
    }

    /**
     * <p>
     * A message that describes the lifecycle status of the step.
     * </p>
     * 
     * @return A message that describes the lifecycle status of the step.
     */
    public final String lifecycleStatusMessage() {
        return lifecycleStatusMessage;
    }

    /**
     * <p>
     * The task run status for the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskRunStatus}
     * will return {@link TaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskRunStatusAsString}.
     * </p>
     * 
     * @return The task run status for the job.
     * @see TaskRunStatus
     */
    public final TaskRunStatus taskRunStatus() {
        return TaskRunStatus.fromValue(taskRunStatus);
    }

    /**
     * <p>
     * The task run status for the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskRunStatus}
     * will return {@link TaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskRunStatusAsString}.
     * </p>
     * 
     * @return The task run status for the job.
     * @see TaskRunStatus
     */
    public final String taskRunStatusAsString() {
        return taskRunStatus;
    }

    /**
     * <p>
     * The number of tasks running on the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskRunStatusCounts} method.
     * </p>
     * 
     * @return The number of tasks running on the job.
     */
    public final Map<TaskRunStatus, Integer> taskRunStatusCounts() {
        return TaskRunStatusCountsCopier.copyStringToEnum(taskRunStatusCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskRunStatusCounts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskRunStatusCounts() {
        return taskRunStatusCounts != null && !(taskRunStatusCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The number of tasks running on the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskRunStatusCounts} method.
     * </p>
     * 
     * @return The number of tasks running on the job.
     */
    public final Map<String, Integer> taskRunStatusCountsAsStrings() {
        return taskRunStatusCounts;
    }

    /**
     * <p>
     * The task status with which the job started.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetTaskRunStatus} will return {@link StepTargetTaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetTaskRunStatusAsString}.
     * </p>
     * 
     * @return The task status with which the job started.
     * @see StepTargetTaskRunStatus
     */
    public final StepTargetTaskRunStatus targetTaskRunStatus() {
        return StepTargetTaskRunStatus.fromValue(targetTaskRunStatus);
    }

    /**
     * <p>
     * The task status with which the job started.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetTaskRunStatus} will return {@link StepTargetTaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetTaskRunStatusAsString}.
     * </p>
     * 
     * @return The task status with which the job started.
     * @see StepTargetTaskRunStatus
     */
    public final String targetTaskRunStatusAsString() {
        return targetTaskRunStatus;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user or system that created this resource.
     * </p>
     * 
     * @return The user or system that created this resource.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the resource was updated.
     * </p>
     * 
     * @return The date and time the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user or system that updated this resource.
     * </p>
     * 
     * @return The user or system that updated this resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * The date and time the resource started running.
     * </p>
     * 
     * @return The date and time the resource started running.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The date and time the resource ended running.
     * </p>
     * 
     * @return The date and time the resource ended running.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The number of dependencies in the step.
     * </p>
     * 
     * @return The number of dependencies in the step.
     */
    public final DependencyCounts dependencyCounts() {
        return dependencyCounts;
    }

    /**
     * <p>
     * The required capabilities of the step.
     * </p>
     * 
     * @return The required capabilities of the step.
     */
    public final StepRequiredCapabilities requiredCapabilities() {
        return requiredCapabilities;
    }

    /**
     * <p>
     * A list of step parameters and the combination expression for the step.
     * </p>
     * 
     * @return A list of step parameters and the combination expression for the step.
     */
    public final ParameterSpace parameterSpace() {
        return parameterSpace;
    }

    /**
     * <p>
     * The description of the step.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The description of the step.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stepId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(taskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskRunStatusCounts() ? taskRunStatusCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetTaskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(dependencyCounts());
        hashCode = 31 * hashCode + Objects.hashCode(requiredCapabilities());
        hashCode = 31 * hashCode + Objects.hashCode(parameterSpace());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStepResponse)) {
            return false;
        }
        GetStepResponse other = (GetStepResponse) obj;
        return Objects.equals(stepId(), other.stepId()) && Objects.equals(name(), other.name())
                && Objects.equals(lifecycleStatusAsString(), other.lifecycleStatusAsString())
                && Objects.equals(lifecycleStatusMessage(), other.lifecycleStatusMessage())
                && Objects.equals(taskRunStatusAsString(), other.taskRunStatusAsString())
                && hasTaskRunStatusCounts() == other.hasTaskRunStatusCounts()
                && Objects.equals(taskRunStatusCountsAsStrings(), other.taskRunStatusCountsAsStrings())
                && Objects.equals(targetTaskRunStatusAsString(), other.targetTaskRunStatusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(endedAt(), other.endedAt())
                && Objects.equals(dependencyCounts(), other.dependencyCounts())
                && Objects.equals(requiredCapabilities(), other.requiredCapabilities())
                && Objects.equals(parameterSpace(), other.parameterSpace()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStepResponse").add("StepId", stepId()).add("Name", name())
                .add("LifecycleStatus", lifecycleStatusAsString()).add("LifecycleStatusMessage", lifecycleStatusMessage())
                .add("TaskRunStatus", taskRunStatusAsString())
                .add("TaskRunStatusCounts", hasTaskRunStatusCounts() ? taskRunStatusCountsAsStrings() : null)
                .add("TargetTaskRunStatus", targetTaskRunStatusAsString()).add("CreatedAt", createdAt())
                .add("CreatedBy", createdBy()).add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy())
                .add("StartedAt", startedAt()).add("EndedAt", endedAt()).add("DependencyCounts", dependencyCounts())
                .add("RequiredCapabilities", requiredCapabilities()).add("ParameterSpace", parameterSpace())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepId":
            return Optional.ofNullable(clazz.cast(stepId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "lifecycleStatus":
            return Optional.ofNullable(clazz.cast(lifecycleStatusAsString()));
        case "lifecycleStatusMessage":
            return Optional.ofNullable(clazz.cast(lifecycleStatusMessage()));
        case "taskRunStatus":
            return Optional.ofNullable(clazz.cast(taskRunStatusAsString()));
        case "taskRunStatusCounts":
            return Optional.ofNullable(clazz.cast(taskRunStatusCountsAsStrings()));
        case "targetTaskRunStatus":
            return Optional.ofNullable(clazz.cast(targetTaskRunStatusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "dependencyCounts":
            return Optional.ofNullable(clazz.cast(dependencyCounts()));
        case "requiredCapabilities":
            return Optional.ofNullable(clazz.cast(requiredCapabilities()));
        case "parameterSpace":
            return Optional.ofNullable(clazz.cast(parameterSpace()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStepResponse, T> g) {
        return obj -> g.apply((GetStepResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStepResponse> {
        /**
         * <p>
         * The step ID.
         * </p>
         * 
         * @param stepId
         *        The step ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepId(String stepId);

        /**
         * <p>
         * The name of the step.
         * </p>
         * 
         * @param name
         *        The name of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The life cycle status of the step.
         * </p>
         * 
         * @param lifecycleStatus
         *        The life cycle status of the step.
         * @see StepLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepLifecycleStatus
         */
        Builder lifecycleStatus(String lifecycleStatus);

        /**
         * <p>
         * The life cycle status of the step.
         * </p>
         * 
         * @param lifecycleStatus
         *        The life cycle status of the step.
         * @see StepLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepLifecycleStatus
         */
        Builder lifecycleStatus(StepLifecycleStatus lifecycleStatus);

        /**
         * <p>
         * A message that describes the lifecycle status of the step.
         * </p>
         * 
         * @param lifecycleStatusMessage
         *        A message that describes the lifecycle status of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleStatusMessage(String lifecycleStatusMessage);

        /**
         * <p>
         * The task run status for the job.
         * </p>
         * 
         * @param taskRunStatus
         *        The task run status for the job.
         * @see TaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskRunStatus
         */
        Builder taskRunStatus(String taskRunStatus);

        /**
         * <p>
         * The task run status for the job.
         * </p>
         * 
         * @param taskRunStatus
         *        The task run status for the job.
         * @see TaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskRunStatus
         */
        Builder taskRunStatus(TaskRunStatus taskRunStatus);

        /**
         * <p>
         * The number of tasks running on the job.
         * </p>
         * 
         * @param taskRunStatusCounts
         *        The number of tasks running on the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRunStatusCountsWithStrings(Map<String, Integer> taskRunStatusCounts);

        /**
         * <p>
         * The number of tasks running on the job.
         * </p>
         * 
         * @param taskRunStatusCounts
         *        The number of tasks running on the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> taskRunStatusCounts);

        /**
         * <p>
         * The task status with which the job started.
         * </p>
         * 
         * @param targetTaskRunStatus
         *        The task status with which the job started.
         * @see StepTargetTaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepTargetTaskRunStatus
         */
        Builder targetTaskRunStatus(String targetTaskRunStatus);

        /**
         * <p>
         * The task status with which the job started.
         * </p>
         * 
         * @param targetTaskRunStatus
         *        The task status with which the job started.
         * @see StepTargetTaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepTargetTaskRunStatus
         */
        Builder targetTaskRunStatus(StepTargetTaskRunStatus targetTaskRunStatus);

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user or system that created this resource.
         * </p>
         * 
         * @param createdBy
         *        The user or system that created this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user or system that updated this resource.
         * </p>
         * 
         * @param updatedBy
         *        The user or system that updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The date and time the resource started running.
         * </p>
         * 
         * @param startedAt
         *        The date and time the resource started running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The date and time the resource ended running.
         * </p>
         * 
         * @param endedAt
         *        The date and time the resource ended running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The number of dependencies in the step.
         * </p>
         * 
         * @param dependencyCounts
         *        The number of dependencies in the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencyCounts(DependencyCounts dependencyCounts);

        /**
         * <p>
         * The number of dependencies in the step.
         * </p>
         * This is a convenience method that creates an instance of the {@link DependencyCounts.Builder} avoiding the
         * need to create one manually via {@link DependencyCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DependencyCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #dependencyCounts(DependencyCounts)}.
         * 
         * @param dependencyCounts
         *        a consumer that will call methods on {@link DependencyCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependencyCounts(DependencyCounts)
         */
        default Builder dependencyCounts(Consumer<DependencyCounts.Builder> dependencyCounts) {
            return dependencyCounts(DependencyCounts.builder().applyMutation(dependencyCounts).build());
        }

        /**
         * <p>
         * The required capabilities of the step.
         * </p>
         * 
         * @param requiredCapabilities
         *        The required capabilities of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredCapabilities(StepRequiredCapabilities requiredCapabilities);

        /**
         * <p>
         * The required capabilities of the step.
         * </p>
         * This is a convenience method that creates an instance of the {@link StepRequiredCapabilities.Builder}
         * avoiding the need to create one manually via {@link StepRequiredCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StepRequiredCapabilities.Builder#build()} is called immediately
         * and its result is passed to {@link #requiredCapabilities(StepRequiredCapabilities)}.
         * 
         * @param requiredCapabilities
         *        a consumer that will call methods on {@link StepRequiredCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requiredCapabilities(StepRequiredCapabilities)
         */
        default Builder requiredCapabilities(Consumer<StepRequiredCapabilities.Builder> requiredCapabilities) {
            return requiredCapabilities(StepRequiredCapabilities.builder().applyMutation(requiredCapabilities).build());
        }

        /**
         * <p>
         * A list of step parameters and the combination expression for the step.
         * </p>
         * 
         * @param parameterSpace
         *        A list of step parameters and the combination expression for the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterSpace(ParameterSpace parameterSpace);

        /**
         * <p>
         * A list of step parameters and the combination expression for the step.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterSpace.Builder} avoiding the need
         * to create one manually via {@link ParameterSpace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterSpace.Builder#build()} is called immediately and its
         * result is passed to {@link #parameterSpace(ParameterSpace)}.
         * 
         * @param parameterSpace
         *        a consumer that will call methods on {@link ParameterSpace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterSpace(ParameterSpace)
         */
        default Builder parameterSpace(Consumer<ParameterSpace.Builder> parameterSpace) {
            return parameterSpace(ParameterSpace.builder().applyMutation(parameterSpace).build());
        }

        /**
         * <p>
         * The description of the step.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param description
         *        The description of the step.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private String stepId;

        private String name;

        private String lifecycleStatus;

        private String lifecycleStatusMessage;

        private String taskRunStatus;

        private Map<String, Integer> taskRunStatusCounts = DefaultSdkAutoConstructMap.getInstance();

        private String targetTaskRunStatus;

        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private Instant startedAt;

        private Instant endedAt;

        private DependencyCounts dependencyCounts;

        private StepRequiredCapabilities requiredCapabilities;

        private ParameterSpace parameterSpace;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStepResponse model) {
            super(model);
            stepId(model.stepId);
            name(model.name);
            lifecycleStatus(model.lifecycleStatus);
            lifecycleStatusMessage(model.lifecycleStatusMessage);
            taskRunStatus(model.taskRunStatus);
            taskRunStatusCountsWithStrings(model.taskRunStatusCounts);
            targetTaskRunStatus(model.targetTaskRunStatus);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            startedAt(model.startedAt);
            endedAt(model.endedAt);
            dependencyCounts(model.dependencyCounts);
            requiredCapabilities(model.requiredCapabilities);
            parameterSpace(model.parameterSpace);
            description(model.description);
        }

        public final String getStepId() {
            return stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLifecycleStatus() {
            return lifecycleStatus;
        }

        public final void setLifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
        }

        @Override
        public final Builder lifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        @Override
        public final Builder lifecycleStatus(StepLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus(lifecycleStatus == null ? null : lifecycleStatus.toString());
            return this;
        }

        public final String getLifecycleStatusMessage() {
            return lifecycleStatusMessage;
        }

        public final void setLifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
        }

        @Override
        public final Builder lifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
            return this;
        }

        public final String getTaskRunStatus() {
            return taskRunStatus;
        }

        public final void setTaskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
        }

        @Override
        public final Builder taskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
            return this;
        }

        @Override
        public final Builder taskRunStatus(TaskRunStatus taskRunStatus) {
            this.taskRunStatus(taskRunStatus == null ? null : taskRunStatus.toString());
            return this;
        }

        public final Map<String, Integer> getTaskRunStatusCounts() {
            if (taskRunStatusCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return taskRunStatusCounts;
        }

        public final void setTaskRunStatusCounts(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
        }

        @Override
        public final Builder taskRunStatusCountsWithStrings(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
            return this;
        }

        @Override
        public final Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copyEnumToString(taskRunStatusCounts);
            return this;
        }

        public final String getTargetTaskRunStatus() {
            return targetTaskRunStatus;
        }

        public final void setTargetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
        }

        @Override
        public final Builder targetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
            return this;
        }

        @Override
        public final Builder targetTaskRunStatus(StepTargetTaskRunStatus targetTaskRunStatus) {
            this.targetTaskRunStatus(targetTaskRunStatus == null ? null : targetTaskRunStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final DependencyCounts.Builder getDependencyCounts() {
            return dependencyCounts != null ? dependencyCounts.toBuilder() : null;
        }

        public final void setDependencyCounts(DependencyCounts.BuilderImpl dependencyCounts) {
            this.dependencyCounts = dependencyCounts != null ? dependencyCounts.build() : null;
        }

        @Override
        public final Builder dependencyCounts(DependencyCounts dependencyCounts) {
            this.dependencyCounts = dependencyCounts;
            return this;
        }

        public final StepRequiredCapabilities.Builder getRequiredCapabilities() {
            return requiredCapabilities != null ? requiredCapabilities.toBuilder() : null;
        }

        public final void setRequiredCapabilities(StepRequiredCapabilities.BuilderImpl requiredCapabilities) {
            this.requiredCapabilities = requiredCapabilities != null ? requiredCapabilities.build() : null;
        }

        @Override
        public final Builder requiredCapabilities(StepRequiredCapabilities requiredCapabilities) {
            this.requiredCapabilities = requiredCapabilities;
            return this;
        }

        public final ParameterSpace.Builder getParameterSpace() {
            return parameterSpace != null ? parameterSpace.toBuilder() : null;
        }

        public final void setParameterSpace(ParameterSpace.BuilderImpl parameterSpace) {
            this.parameterSpace = parameterSpace != null ? parameterSpace.build() : null;
        }

        @Override
        public final Builder parameterSpace(ParameterSpace parameterSpace) {
            this.parameterSpace = parameterSpace;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public GetStepResponse build() {
            return new GetStepResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
