/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The fleet amount and attribute capabilities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetAmountCapability implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetAmountCapability.Builder, FleetAmountCapability> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(FleetAmountCapability::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Float> MIN_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("min")
            .getter(getter(FleetAmountCapability::min)).setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("min").build()).build();

    private static final SdkField<Float> MAX_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("max")
            .getter(getter(FleetAmountCapability::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("max").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MIN_FIELD,
            MAX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Float min;

    private final Float max;

    private FleetAmountCapability(BuilderImpl builder) {
        this.name = builder.name;
        this.min = builder.min;
        this.max = builder.max;
    }

    /**
     * <p>
     * The name of the fleet capability.
     * </p>
     * 
     * @return The name of the fleet capability.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The minimum amount of fleet worker capability.
     * </p>
     * 
     * @return The minimum amount of fleet worker capability.
     */
    public final Float min() {
        return min;
    }

    /**
     * <p>
     * The maximum amount of the fleet worker capability.
     * </p>
     * 
     * @return The maximum amount of the fleet worker capability.
     */
    public final Float max() {
        return max;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(min());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetAmountCapability)) {
            return false;
        }
        FleetAmountCapability other = (FleetAmountCapability) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(min(), other.min()) && Objects.equals(max(), other.max());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetAmountCapability").add("Name", name()).add("Min", min()).add("Max", max()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "min":
            return Optional.ofNullable(clazz.cast(min()));
        case "max":
            return Optional.ofNullable(clazz.cast(max()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetAmountCapability, T> g) {
        return obj -> g.apply((FleetAmountCapability) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetAmountCapability> {
        /**
         * <p>
         * The name of the fleet capability.
         * </p>
         * 
         * @param name
         *        The name of the fleet capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The minimum amount of fleet worker capability.
         * </p>
         * 
         * @param min
         *        The minimum amount of fleet worker capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(Float min);

        /**
         * <p>
         * The maximum amount of the fleet worker capability.
         * </p>
         * 
         * @param max
         *        The maximum amount of the fleet worker capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Float max);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Float min;

        private Float max;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetAmountCapability model) {
            name(model.name);
            min(model.min);
            max(model.max);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Float getMin() {
            return min;
        }

        public final void setMin(Float min) {
            this.min = min;
        }

        @Override
        public final Builder min(Float min) {
            this.min = min;
            return this;
        }

        public final Float getMax() {
            return max;
        }

        public final void setMax(Float max) {
            this.max = max;
        }

        @Override
        public final Builder max(Float max) {
            this.max = max;
            return this;
        }

        @Override
        public FleetAmountCapability build() {
            return new FleetAmountCapability(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
