/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The assigned session for the worker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssignedSession implements SdkPojo, Serializable, ToCopyableBuilder<AssignedSession.Builder, AssignedSession> {
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(AssignedSession::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(AssignedSession::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<List<AssignedSessionAction>> SESSION_ACTIONS_FIELD = SdkField
            .<List<AssignedSessionAction>> builder(MarshallingType.LIST)
            .memberName("sessionActions")
            .getter(getter(AssignedSession::sessionActions))
            .setter(setter(Builder::sessionActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssignedSessionAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssignedSessionAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<LogConfiguration> builder(MarshallingType.SDK_POJO).memberName("logConfiguration")
            .getter(getter(AssignedSession::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(LogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_ID_FIELD, JOB_ID_FIELD,
            SESSION_ACTIONS_FIELD, LOG_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String queueId;

    private final String jobId;

    private final List<AssignedSessionAction> sessionActions;

    private final LogConfiguration logConfiguration;

    private AssignedSession(BuilderImpl builder) {
        this.queueId = builder.queueId;
        this.jobId = builder.jobId;
        this.sessionActions = builder.sessionActions;
        this.logConfiguration = builder.logConfiguration;
    }

    /**
     * <p>
     * The queue ID of the assigned session.
     * </p>
     * 
     * @return The queue ID of the assigned session.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The job ID for the assigned session.
     * </p>
     * 
     * @return The job ID for the assigned session.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SessionActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSessionActions() {
        return sessionActions != null && !(sessionActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The session actions to apply to the assigned session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionActions} method.
     * </p>
     * 
     * @return The session actions to apply to the assigned session.
     */
    public final List<AssignedSessionAction> sessionActions() {
        return sessionActions;
    }

    /**
     * <p>
     * The log configuration for the worker's assigned session.
     * </p>
     * 
     * @return The log configuration for the worker's assigned session.
     */
    public final LogConfiguration logConfiguration() {
        return logConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSessionActions() ? sessionActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignedSession)) {
            return false;
        }
        AssignedSession other = (AssignedSession) obj;
        return Objects.equals(queueId(), other.queueId()) && Objects.equals(jobId(), other.jobId())
                && hasSessionActions() == other.hasSessionActions() && Objects.equals(sessionActions(), other.sessionActions())
                && Objects.equals(logConfiguration(), other.logConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssignedSession").add("QueueId", queueId()).add("JobId", jobId())
                .add("SessionActions", hasSessionActions() ? sessionActions() : null).add("LogConfiguration", logConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "sessionActions":
            return Optional.ofNullable(clazz.cast(sessionActions()));
        case "logConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssignedSession, T> g) {
        return obj -> g.apply((AssignedSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssignedSession> {
        /**
         * <p>
         * The queue ID of the assigned session.
         * </p>
         * 
         * @param queueId
         *        The queue ID of the assigned session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The job ID for the assigned session.
         * </p>
         * 
         * @param jobId
         *        The job ID for the assigned session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The session actions to apply to the assigned session.
         * </p>
         * 
         * @param sessionActions
         *        The session actions to apply to the assigned session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionActions(Collection<AssignedSessionAction> sessionActions);

        /**
         * <p>
         * The session actions to apply to the assigned session.
         * </p>
         * 
         * @param sessionActions
         *        The session actions to apply to the assigned session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionActions(AssignedSessionAction... sessionActions);

        /**
         * <p>
         * The session actions to apply to the assigned session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.AssignedSessionAction.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.AssignedSessionAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.AssignedSessionAction.Builder#build()} is called
         * immediately and its result is passed to {@link #sessionActions(List<AssignedSessionAction>)}.
         * 
         * @param sessionActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.AssignedSessionAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionActions(java.util.Collection<AssignedSessionAction>)
         */
        Builder sessionActions(Consumer<AssignedSessionAction.Builder>... sessionActions);

        /**
         * <p>
         * The log configuration for the worker's assigned session.
         * </p>
         * 
         * @param logConfiguration
         *        The log configuration for the worker's assigned session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(LogConfiguration logConfiguration);

        /**
         * <p>
         * The log configuration for the worker's assigned session.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #logConfiguration(LogConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link LogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(LogConfiguration)
         */
        default Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return logConfiguration(LogConfiguration.builder().applyMutation(logConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String queueId;

        private String jobId;

        private List<AssignedSessionAction> sessionActions = DefaultSdkAutoConstructList.getInstance();

        private LogConfiguration logConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignedSession model) {
            queueId(model.queueId);
            jobId(model.jobId);
            sessionActions(model.sessionActions);
            logConfiguration(model.logConfiguration);
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final List<AssignedSessionAction.Builder> getSessionActions() {
            List<AssignedSessionAction.Builder> result = AssignedSessionActionsCopier.copyToBuilder(this.sessionActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessionActions(Collection<AssignedSessionAction.BuilderImpl> sessionActions) {
            this.sessionActions = AssignedSessionActionsCopier.copyFromBuilder(sessionActions);
        }

        @Override
        public final Builder sessionActions(Collection<AssignedSessionAction> sessionActions) {
            this.sessionActions = AssignedSessionActionsCopier.copy(sessionActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionActions(AssignedSessionAction... sessionActions) {
            sessionActions(Arrays.asList(sessionActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionActions(Consumer<AssignedSessionAction.Builder>... sessionActions) {
            sessionActions(Stream.of(sessionActions).map(c -> AssignedSessionAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        @Override
        public AssignedSession build() {
            return new AssignedSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
