/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of a parameter group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterGroupStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterGroupStatus.Builder, ParameterGroupStatus> {
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupName").getter(getter(ParameterGroupStatus::parameterGroupName))
            .setter(setter(Builder::parameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build())
            .build();

    private static final SdkField<String> PARAMETER_APPLY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterApplyStatus").getter(getter(ParameterGroupStatus::parameterApplyStatus))
            .setter(setter(Builder::parameterApplyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterApplyStatus").build())
            .build();

    private static final SdkField<List<String>> NODE_IDS_TO_REBOOT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NodeIdsToReboot")
            .getter(getter(ParameterGroupStatus::nodeIdsToReboot))
            .setter(setter(Builder::nodeIdsToReboot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeIdsToReboot").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_GROUP_NAME_FIELD,
            PARAMETER_APPLY_STATUS_FIELD, NODE_IDS_TO_REBOOT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String parameterGroupName;

    private final String parameterApplyStatus;

    private final List<String> nodeIdsToReboot;

    private ParameterGroupStatus(BuilderImpl builder) {
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterApplyStatus = builder.parameterApplyStatus;
        this.nodeIdsToReboot = builder.nodeIdsToReboot;
    }

    /**
     * <p>
     * The name of the parameter group.
     * </p>
     * 
     * @return The name of the parameter group.
     */
    public final String parameterGroupName() {
        return parameterGroupName;
    }

    /**
     * <p>
     * The status of parameter updates.
     * </p>
     * 
     * @return The status of parameter updates.
     */
    public final String parameterApplyStatus() {
        return parameterApplyStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeIdsToReboot property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNodeIdsToReboot() {
        return nodeIdsToReboot != null && !(nodeIdsToReboot instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The node IDs of one or more nodes to be rebooted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeIdsToReboot} method.
     * </p>
     * 
     * @return The node IDs of one or more nodes to be rebooted.
     */
    public final List<String> nodeIdsToReboot() {
        return nodeIdsToReboot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterApplyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeIdsToReboot() ? nodeIdsToReboot() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterGroupStatus)) {
            return false;
        }
        ParameterGroupStatus other = (ParameterGroupStatus) obj;
        return Objects.equals(parameterGroupName(), other.parameterGroupName())
                && Objects.equals(parameterApplyStatus(), other.parameterApplyStatus())
                && hasNodeIdsToReboot() == other.hasNodeIdsToReboot()
                && Objects.equals(nodeIdsToReboot(), other.nodeIdsToReboot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterGroupStatus").add("ParameterGroupName", parameterGroupName())
                .add("ParameterApplyStatus", parameterApplyStatus())
                .add("NodeIdsToReboot", hasNodeIdsToReboot() ? nodeIdsToReboot() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterGroupName":
            return Optional.ofNullable(clazz.cast(parameterGroupName()));
        case "ParameterApplyStatus":
            return Optional.ofNullable(clazz.cast(parameterApplyStatus()));
        case "NodeIdsToReboot":
            return Optional.ofNullable(clazz.cast(nodeIdsToReboot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParameterGroupName", PARAMETER_GROUP_NAME_FIELD);
        map.put("ParameterApplyStatus", PARAMETER_APPLY_STATUS_FIELD);
        map.put("NodeIdsToReboot", NODE_IDS_TO_REBOOT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParameterGroupStatus, T> g) {
        return obj -> g.apply((ParameterGroupStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterGroupStatus> {
        /**
         * <p>
         * The name of the parameter group.
         * </p>
         * 
         * @param parameterGroupName
         *        The name of the parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupName(String parameterGroupName);

        /**
         * <p>
         * The status of parameter updates.
         * </p>
         * 
         * @param parameterApplyStatus
         *        The status of parameter updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterApplyStatus(String parameterApplyStatus);

        /**
         * <p>
         * The node IDs of one or more nodes to be rebooted.
         * </p>
         * 
         * @param nodeIdsToReboot
         *        The node IDs of one or more nodes to be rebooted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeIdsToReboot(Collection<String> nodeIdsToReboot);

        /**
         * <p>
         * The node IDs of one or more nodes to be rebooted.
         * </p>
         * 
         * @param nodeIdsToReboot
         *        The node IDs of one or more nodes to be rebooted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeIdsToReboot(String... nodeIdsToReboot);
    }

    static final class BuilderImpl implements Builder {
        private String parameterGroupName;

        private String parameterApplyStatus;

        private List<String> nodeIdsToReboot = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterGroupStatus model) {
            parameterGroupName(model.parameterGroupName);
            parameterApplyStatus(model.parameterApplyStatus);
            nodeIdsToReboot(model.nodeIdsToReboot);
        }

        public final String getParameterGroupName() {
            return parameterGroupName;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final String getParameterApplyStatus() {
            return parameterApplyStatus;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final Collection<String> getNodeIdsToReboot() {
            if (nodeIdsToReboot instanceof SdkAutoConstructList) {
                return null;
            }
            return nodeIdsToReboot;
        }

        public final void setNodeIdsToReboot(Collection<String> nodeIdsToReboot) {
            this.nodeIdsToReboot = NodeIdentifierListCopier.copy(nodeIdsToReboot);
        }

        @Override
        public final Builder nodeIdsToReboot(Collection<String> nodeIdsToReboot) {
            this.nodeIdsToReboot = NodeIdentifierListCopier.copy(nodeIdsToReboot);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIdsToReboot(String... nodeIdsToReboot) {
            nodeIdsToReboot(Arrays.asList(nodeIdsToReboot));
            return this;
        }

        @Override
        public ParameterGroupStatus build() {
            return new ParameterGroupStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
