/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteParameterGroupResponse extends DaxResponse implements
        ToCopyableBuilder<DeleteParameterGroupResponse.Builder, DeleteParameterGroupResponse> {
    private static final SdkField<String> DELETION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeletionMessage").getter(getter(DeleteParameterGroupResponse::deletionMessage))
            .setter(setter(Builder::deletionMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETION_MESSAGE_FIELD));

    private final String deletionMessage;

    private DeleteParameterGroupResponse(BuilderImpl builder) {
        super(builder);
        this.deletionMessage = builder.deletionMessage;
    }

    /**
     * <p>
     * A user-specified message for this action (i.e., a reason for deleting the parameter group).
     * </p>
     * 
     * @return A user-specified message for this action (i.e., a reason for deleting the parameter group).
     */
    public final String deletionMessage() {
        return deletionMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deletionMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteParameterGroupResponse)) {
            return false;
        }
        DeleteParameterGroupResponse other = (DeleteParameterGroupResponse) obj;
        return Objects.equals(deletionMessage(), other.deletionMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteParameterGroupResponse").add("DeletionMessage", deletionMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeletionMessage":
            return Optional.ofNullable(clazz.cast(deletionMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteParameterGroupResponse, T> g) {
        return obj -> g.apply((DeleteParameterGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DaxResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteParameterGroupResponse> {
        /**
         * <p>
         * A user-specified message for this action (i.e., a reason for deleting the parameter group).
         * </p>
         * 
         * @param deletionMessage
         *        A user-specified message for this action (i.e., a reason for deleting the parameter group).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionMessage(String deletionMessage);
    }

    static final class BuilderImpl extends DaxResponse.BuilderImpl implements Builder {
        private String deletionMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteParameterGroupResponse model) {
            super(model);
            deletionMessage(model.deletionMessage);
        }

        public final String getDeletionMessage() {
            return deletionMessage;
        }

        public final void setDeletionMessage(String deletionMessage) {
            this.deletionMessage = deletionMessage;
        }

        @Override
        public final Builder deletionMessage(String deletionMessage) {
            this.deletionMessage = deletionMessage;
            return this;
        }

        @Override
        public DeleteParameterGroupResponse build() {
            return new DeleteParameterGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
