/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the information required for client programs to connect to the endpoint for a DAX cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Endpoint implements SdkPojo, Serializable, ToCopyableBuilder<Endpoint.Builder, Endpoint> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Address")
            .getter(getter(Endpoint::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(Endpoint::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("URL")
            .getter(getter(Endpoint::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, PORT_FIELD,
            URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String address;

    private final Integer port;

    private final String url;

    private Endpoint(BuilderImpl builder) {
        this.address = builder.address;
        this.port = builder.port;
        this.url = builder.url;
    }

    /**
     * <p>
     * The DNS hostname of the endpoint.
     * </p>
     * 
     * @return The DNS hostname of the endpoint.
     */
    public final String address() {
        return address;
    }

    /**
     * <p>
     * The port number that applications should use to connect to the endpoint.
     * </p>
     * 
     * @return The port number that applications should use to connect to the endpoint.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The URL that applications should use to connect to the endpoint. The default ports are 8111 for the "dax"
     * protocol and 9111 for the "daxs" protocol.
     * </p>
     * 
     * @return The URL that applications should use to connect to the endpoint. The default ports are 8111 for the "dax"
     *         protocol and 9111 for the "daxs" protocol.
     */
    public final String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint) obj;
        return Objects.equals(address(), other.address()) && Objects.equals(port(), other.port())
                && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Endpoint").add("Address", address()).add("Port", port()).add("URL", url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "URL":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Endpoint, T> g) {
        return obj -> g.apply((Endpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Endpoint> {
        /**
         * <p>
         * The DNS hostname of the endpoint.
         * </p>
         * 
         * @param address
         *        The DNS hostname of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The port number that applications should use to connect to the endpoint.
         * </p>
         * 
         * @param port
         *        The port number that applications should use to connect to the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The URL that applications should use to connect to the endpoint. The default ports are 8111 for the "dax"
         * protocol and 9111 for the "daxs" protocol.
         * </p>
         * 
         * @param url
         *        The URL that applications should use to connect to the endpoint. The default ports are 8111 for the
         *        "dax" protocol and 9111 for the "daxs" protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String address;

        private Integer port;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(Endpoint model) {
            address(model.address);
            port(model.port);
            url(model.url);
        }

        public final String getAddress() {
            return address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        @Transient
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        @Transient
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        @Transient
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public Endpoint build() {
            return new Endpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
