/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.ActionParameters;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEnvironmentActionRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, UpdateEnvironmentActionRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateEnvironmentActionRequest.getter(UpdateEnvironmentActionRequest::description)).setter(UpdateEnvironmentActionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(UpdateEnvironmentActionRequest.getter(UpdateEnvironmentActionRequest::domainIdentifier)).setter(UpdateEnvironmentActionRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentIdentifier").getter(UpdateEnvironmentActionRequest.getter(UpdateEnvironmentActionRequest::environmentIdentifier)).setter(UpdateEnvironmentActionRequest.setter(Builder::environmentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentIdentifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(UpdateEnvironmentActionRequest.getter(UpdateEnvironmentActionRequest::identifier)).setter(UpdateEnvironmentActionRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateEnvironmentActionRequest.getter(UpdateEnvironmentActionRequest::name)).setter(UpdateEnvironmentActionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ActionParameters> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parameters").getter(UpdateEnvironmentActionRequest.getter(UpdateEnvironmentActionRequest::parameters)).setter(UpdateEnvironmentActionRequest.setter(Builder::parameters)).constructor(ActionParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, IDENTIFIER_FIELD, NAME_FIELD, PARAMETERS_FIELD));
    private final String description;
    private final String domainIdentifier;
    private final String environmentIdentifier;
    private final String identifier;
    private final String name;
    private final ActionParameters parameters;

    private UpdateEnvironmentActionRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.parameters = builder.parameters;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String environmentIdentifier() {
        return this.environmentIdentifier;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String name() {
        return this.name;
    }

    public final ActionParameters parameters() {
        return this.parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentActionRequest)) {
            return false;
        }
        UpdateEnvironmentActionRequest other = (UpdateEnvironmentActionRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.environmentIdentifier(), other.environmentIdentifier()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEnvironmentActionRequest").add("Description", (Object)this.description()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("EnvironmentIdentifier", (Object)this.environmentIdentifier()).add("Identifier", (Object)this.identifier()).add("Name", (Object)this.name()).add("Parameters", (Object)this.parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "environmentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentIdentifier()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentActionRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String description;
        private String domainIdentifier;
        private String environmentIdentifier;
        private String identifier;
        private String name;
        private ActionParameters parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentActionRequest model) {
            super(model);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.environmentIdentifier(model.environmentIdentifier);
            this.identifier(model.identifier);
            this.name(model.name);
            this.parameters(model.parameters);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ActionParameters.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        public final void setParameters(ActionParameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(ActionParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentActionRequest build() {
            return new UpdateEnvironmentActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEnvironmentActionRequest> {
        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder environmentIdentifier(String var1);

        public Builder identifier(String var1);

        public Builder name(String var1);

        public Builder parameters(ActionParameters var1);

        default public Builder parameters(Consumer<ActionParameters.Builder> parameters) {
            return this.parameters((ActionParameters)((ActionParameters.Builder)ActionParameters.builder().applyMutation(parameters)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

