/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDataSourceRunRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, StartDataSourceRunRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartDataSourceRunRequest.getter(StartDataSourceRunRequest::clientToken)).setter(StartDataSourceRunRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DATA_SOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceIdentifier").getter(StartDataSourceRunRequest.getter(StartDataSourceRunRequest::dataSourceIdentifier)).setter(StartDataSourceRunRequest.setter(Builder::dataSourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceIdentifier").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(StartDataSourceRunRequest.getter(StartDataSourceRunRequest::domainIdentifier)).setter(StartDataSourceRunRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DATA_SOURCE_IDENTIFIER_FIELD, DOMAIN_IDENTIFIER_FIELD));
    private final String clientToken;
    private final String dataSourceIdentifier;
    private final String domainIdentifier;

    private StartDataSourceRunRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dataSourceIdentifier = builder.dataSourceIdentifier;
        this.domainIdentifier = builder.domainIdentifier;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String dataSourceIdentifier() {
        return this.dataSourceIdentifier;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDataSourceRunRequest)) {
            return false;
        }
        StartDataSourceRunRequest other = (StartDataSourceRunRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dataSourceIdentifier(), other.dataSourceIdentifier()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"StartDataSourceRunRequest").add("ClientToken", (Object)this.clientToken()).add("DataSourceIdentifier", (Object)this.dataSourceIdentifier()).add("DomainIdentifier", (Object)this.domainIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "dataSourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dataSourceIdentifier()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDataSourceRunRequest, T> g) {
        return obj -> g.apply((StartDataSourceRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String dataSourceIdentifier;
        private String domainIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDataSourceRunRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.dataSourceIdentifier(model.dataSourceIdentifier);
            this.domainIdentifier(model.domainIdentifier);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDataSourceIdentifier() {
            return this.dataSourceIdentifier;
        }

        public final void setDataSourceIdentifier(String dataSourceIdentifier) {
            this.dataSourceIdentifier = dataSourceIdentifier;
        }

        @Override
        public final Builder dataSourceIdentifier(String dataSourceIdentifier) {
            this.dataSourceIdentifier = dataSourceIdentifier;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDataSourceRunRequest build() {
            return new StartDataSourceRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDataSourceRunRequest> {
        public Builder clientToken(String var1);

        public Builder dataSourceIdentifier(String var1);

        public Builder domainIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

