/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsRequest;
import software.amazon.awssdk.services.datazone.model.ListTimeSeriesDataPointsResponse;
import software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointSummaryFormOutput;

public class ListTimeSeriesDataPointsIterable
implements SdkIterable<ListTimeSeriesDataPointsResponse> {
    private final DataZoneClient client;
    private final ListTimeSeriesDataPointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTimeSeriesDataPointsIterable(DataZoneClient client, ListTimeSeriesDataPointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTimeSeriesDataPointsResponseFetcher();
    }

    public Iterator<ListTimeSeriesDataPointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TimeSeriesDataPointSummaryFormOutput> items() {
        Function<ListTimeSeriesDataPointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTimeSeriesDataPointsResponseFetcher
    implements SyncPageFetcher<ListTimeSeriesDataPointsResponse> {
        private ListTimeSeriesDataPointsResponseFetcher() {
        }

        public boolean hasNextPage(ListTimeSeriesDataPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTimeSeriesDataPointsResponse nextPage(ListTimeSeriesDataPointsResponse previousPage) {
            if (previousPage == null) {
                return ListTimeSeriesDataPointsIterable.this.client.listTimeSeriesDataPoints(ListTimeSeriesDataPointsIterable.this.firstRequest);
            }
            return ListTimeSeriesDataPointsIterable.this.client.listTimeSeriesDataPoints((ListTimeSeriesDataPointsRequest)((Object)ListTimeSeriesDataPointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

