/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.LineageNodeSummary;
import software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryRequest;
import software.amazon.awssdk.services.datazone.model.ListLineageNodeHistoryResponse;

public class ListLineageNodeHistoryPublisher
implements SdkPublisher<ListLineageNodeHistoryResponse> {
    private final DataZoneAsyncClient client;
    private final ListLineageNodeHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLineageNodeHistoryPublisher(DataZoneAsyncClient client, ListLineageNodeHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLineageNodeHistoryPublisher(DataZoneAsyncClient client, ListLineageNodeHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLineageNodeHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLineageNodeHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LineageNodeSummary> nodes() {
        Function<ListLineageNodeHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.nodes() != null) {
                return response.nodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLineageNodeHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLineageNodeHistoryResponseFetcher
    implements AsyncPageFetcher<ListLineageNodeHistoryResponse> {
        private ListLineageNodeHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListLineageNodeHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLineageNodeHistoryResponse> nextPage(ListLineageNodeHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListLineageNodeHistoryPublisher.this.client.listLineageNodeHistory(ListLineageNodeHistoryPublisher.this.firstRequest);
            }
            return ListLineageNodeHistoryPublisher.this.client.listLineageNodeHistory((ListLineageNodeHistoryRequest)((Object)ListLineageNodeHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

