/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UserSearchType {
    SSO_USER("SSO_USER"),
    DATAZONE_USER("DATAZONE_USER"),
    DATAZONE_SSO_USER("DATAZONE_SSO_USER"),
    DATAZONE_IAM_USER("DATAZONE_IAM_USER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UserSearchType> VALUE_MAP;
    private final String value;

    private UserSearchType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UserSearchType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UserSearchType> knownValues() {
        EnumSet<UserSearchType> knownValues = EnumSet.allOf(UserSearchType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UserSearchType.class, UserSearchType::toString);
    }
}

