/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TypesSearchScope {
    ASSET_TYPE("ASSET_TYPE"),
    FORM_TYPE("FORM_TYPE"),
    LINEAGE_NODE_TYPE("LINEAGE_NODE_TYPE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TypesSearchScope> VALUE_MAP;
    private final String value;

    private TypesSearchScope(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TypesSearchScope fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TypesSearchScope> knownValues() {
        EnumSet<TypesSearchScope> knownValues = EnumSet.allOf(TypesSearchScope.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TypesSearchScope.class, TypesSearchScope::toString);
    }
}

