/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchListingsResponse extends DataZoneResponse implements
        ToCopyableBuilder<SearchListingsResponse.Builder, SearchListingsResponse> {
    private static final SdkField<List<SearchResultItem>> ITEMS_FIELD = SdkField
            .<List<SearchResultItem>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(SearchListingsResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchResultItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchResultItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchListingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> TOTAL_MATCH_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalMatchCount").getter(getter(SearchListingsResponse::totalMatchCount))
            .setter(setter(Builder::totalMatchCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalMatchCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, NEXT_TOKEN_FIELD,
            TOTAL_MATCH_COUNT_FIELD));

    private final List<SearchResultItem> items;

    private final String nextToken;

    private final Integer totalMatchCount;

    private SearchListingsResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.nextToken = builder.nextToken;
        this.totalMatchCount = builder.totalMatchCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results of the <code>SearchListings</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The results of the <code>SearchListings</code> action.
     */
    public final List<SearchResultItem> items() {
        return items;
    }

    /**
     * <p>
     * When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you
     * explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response
     * includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a
     * subsequent call to <code>SearchListings</code> to list the next set of results.
     * </p>
     * 
     * @return When the number of results is greater than the default value for the <code>MaxResults</code> parameter,
     *         or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results,
     *         the response includes a pagination token named <code>NextToken</code>. You can specify this
     *         <code>NextToken</code> value in a subsequent call to <code>SearchListings</code> to list the next set of
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Total number of search results.
     * </p>
     * 
     * @return Total number of search results.
     */
    public final Integer totalMatchCount() {
        return totalMatchCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(totalMatchCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchListingsResponse)) {
            return false;
        }
        SearchListingsResponse other = (SearchListingsResponse) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(totalMatchCount(), other.totalMatchCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchListingsResponse").add("Items", hasItems() ? items() : null).add("NextToken", nextToken())
                .add("TotalMatchCount", totalMatchCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "totalMatchCount":
            return Optional.ofNullable(clazz.cast(totalMatchCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchListingsResponse, T> g) {
        return obj -> g.apply((SearchListingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchListingsResponse> {
        /**
         * <p>
         * The results of the <code>SearchListings</code> action.
         * </p>
         * 
         * @param items
         *        The results of the <code>SearchListings</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<SearchResultItem> items);

        /**
         * <p>
         * The results of the <code>SearchListings</code> action.
         * </p>
         * 
         * @param items
         *        The results of the <code>SearchListings</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(SearchResultItem... items);

        /**
         * <p>
         * The results of the <code>SearchListings</code> action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.SearchResultItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datazone.model.SearchResultItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.SearchResultItem.Builder#build()} is called immediately
         * and its result is passed to {@link #items(List<SearchResultItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.SearchResultItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<SearchResultItem>)
         */
        Builder items(Consumer<SearchResultItem.Builder>... items);

        /**
         * <p>
         * When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if
         * you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the
         * response includes a pagination token named <code>NextToken</code>. You can specify this
         * <code>NextToken</code> value in a subsequent call to <code>SearchListings</code> to list the next set of
         * results.
         * </p>
         * 
         * @param nextToken
         *        When the number of results is greater than the default value for the <code>MaxResults</code>
         *        parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the
         *        number of results, the response includes a pagination token named <code>NextToken</code>. You can
         *        specify this <code>NextToken</code> value in a subsequent call to <code>SearchListings</code> to list
         *        the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Total number of search results.
         * </p>
         * 
         * @param totalMatchCount
         *        Total number of search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalMatchCount(Integer totalMatchCount);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private List<SearchResultItem> items = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer totalMatchCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchListingsResponse model) {
            super(model);
            items(model.items);
            nextToken(model.nextToken);
            totalMatchCount(model.totalMatchCount);
        }

        public final List<SearchResultItem.Builder> getItems() {
            List<SearchResultItem.Builder> result = SearchResultItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<SearchResultItem.BuilderImpl> items) {
            this.items = SearchResultItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<SearchResultItem> items) {
            this.items = SearchResultItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(SearchResultItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<SearchResultItem.Builder>... items) {
            items(Stream.of(items).map(c -> SearchResultItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getTotalMatchCount() {
            return totalMatchCount;
        }

        public final void setTotalMatchCount(Integer totalMatchCount) {
            this.totalMatchCount = totalMatchCount;
        }

        @Override
        public final Builder totalMatchCount(Integer totalMatchCount) {
            this.totalMatchCount = totalMatchCount;
            return this;
        }

        @Override
        public SearchListingsResponse build() {
            return new SearchListingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
