/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchGroupProfilesRequest extends DataZoneRequest implements
        ToCopyableBuilder<SearchGroupProfilesRequest.Builder, SearchGroupProfilesRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(SearchGroupProfilesRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> GROUP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupType").getter(getter(SearchGroupProfilesRequest::groupTypeAsString))
            .setter(setter(Builder::groupType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupType").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(SearchGroupProfilesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchGroupProfilesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> SEARCH_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("searchText").getter(getter(SearchGroupProfilesRequest::searchText)).setter(setter(Builder::searchText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            GROUP_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SEARCH_TEXT_FIELD));

    private final String domainIdentifier;

    private final String groupType;

    private final Integer maxResults;

    private final String nextToken;

    private final String searchText;

    private SearchGroupProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.groupType = builder.groupType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.searchText = builder.searchText;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which you want to search group profiles.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which you want to search group profiles.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The group type for which to search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupType} will
     * return {@link GroupSearchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupTypeAsString}.
     * </p>
     * 
     * @return The group type for which to search.
     * @see GroupSearchType
     */
    public final GroupSearchType groupType() {
        return GroupSearchType.fromValue(groupType);
    }

    /**
     * <p>
     * The group type for which to search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupType} will
     * return {@link GroupSearchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupTypeAsString}.
     * </p>
     * 
     * @return The group type for which to search.
     * @see GroupSearchType
     */
    public final String groupTypeAsString() {
        return groupType;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call to <code>SearchGroupProfiles</code>. When the number of
     * results to be listed is greater than the value of <code>MaxResults</code>, the response contains a
     * <code>NextToken</code> value that you can use in a subsequent call to <code>SearchGroupProfiles</code> to list
     * the next set of results.
     * </p>
     * 
     * @return The maximum number of results to return in a single call to <code>SearchGroupProfiles</code>. When the
     *         number of results to be listed is greater than the value of <code>MaxResults</code>, the response
     *         contains a <code>NextToken</code> value that you can use in a subsequent call to
     *         <code>SearchGroupProfiles</code> to list the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if you
     * explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the response
     * includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a
     * subsequent call to <code>SearchGroupProfiles</code> to list the next set of results.
     * </p>
     * 
     * @return When the number of results is greater than the default value for the <code>MaxResults</code> parameter,
     *         or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of results,
     *         the response includes a pagination token named <code>NextToken</code>. You can specify this
     *         <code>NextToken</code> value in a subsequent call to <code>SearchGroupProfiles</code> to list the next
     *         set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the text for which to search.
     * </p>
     * 
     * @return Specifies the text for which to search.
     */
    public final String searchText() {
        return searchText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(groupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(searchText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchGroupProfilesRequest)) {
            return false;
        }
        SearchGroupProfilesRequest other = (SearchGroupProfilesRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(groupTypeAsString(), other.groupTypeAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(searchText(), other.searchText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchGroupProfilesRequest").add("DomainIdentifier", domainIdentifier())
                .add("GroupType", groupTypeAsString()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("SearchText", searchText() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "groupType":
            return Optional.ofNullable(clazz.cast(groupTypeAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "searchText":
            return Optional.ofNullable(clazz.cast(searchText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchGroupProfilesRequest, T> g) {
        return obj -> g.apply((SearchGroupProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchGroupProfilesRequest> {
        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which you want to search group profiles.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain in which you want to search group profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The group type for which to search.
         * </p>
         * 
         * @param groupType
         *        The group type for which to search.
         * @see GroupSearchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupSearchType
         */
        Builder groupType(String groupType);

        /**
         * <p>
         * The group type for which to search.
         * </p>
         * 
         * @param groupType
         *        The group type for which to search.
         * @see GroupSearchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupSearchType
         */
        Builder groupType(GroupSearchType groupType);

        /**
         * <p>
         * The maximum number of results to return in a single call to <code>SearchGroupProfiles</code>. When the number
         * of results to be listed is greater than the value of <code>MaxResults</code>, the response contains a
         * <code>NextToken</code> value that you can use in a subsequent call to <code>SearchGroupProfiles</code> to
         * list the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call to <code>SearchGroupProfiles</code>. When the
         *        number of results to be listed is greater than the value of <code>MaxResults</code>, the response
         *        contains a <code>NextToken</code> value that you can use in a subsequent call to
         *        <code>SearchGroupProfiles</code> to list the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of results is greater than the default value for the <code>MaxResults</code> parameter, or if
         * you explicitly specify a value for <code>MaxResults</code> that is less than the number of results, the
         * response includes a pagination token named <code>NextToken</code>. You can specify this
         * <code>NextToken</code> value in a subsequent call to <code>SearchGroupProfiles</code> to list the next set of
         * results.
         * </p>
         * 
         * @param nextToken
         *        When the number of results is greater than the default value for the <code>MaxResults</code>
         *        parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the
         *        number of results, the response includes a pagination token named <code>NextToken</code>. You can
         *        specify this <code>NextToken</code> value in a subsequent call to <code>SearchGroupProfiles</code> to
         *        list the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the text for which to search.
         * </p>
         * 
         * @param searchText
         *        Specifies the text for which to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchText(String searchText);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private String groupType;

        private Integer maxResults;

        private String nextToken;

        private String searchText;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchGroupProfilesRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            groupType(model.groupType);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            searchText(model.searchText);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getGroupType() {
            return groupType;
        }

        public final void setGroupType(String groupType) {
            this.groupType = groupType;
        }

        @Override
        public final Builder groupType(String groupType) {
            this.groupType = groupType;
            return this;
        }

        @Override
        public final Builder groupType(GroupSearchType groupType) {
            this.groupType(groupType == null ? null : groupType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSearchText() {
            return searchText;
        }

        public final void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        @Override
        public final Builder searchText(String searchText) {
            this.searchText = searchText;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchGroupProfilesRequest build() {
            return new SearchGroupProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
