/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The project policy grant principal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectPolicyGrantPrincipal implements SdkPojo, Serializable,
        ToCopyableBuilder<ProjectPolicyGrantPrincipal.Builder, ProjectPolicyGrantPrincipal> {
    private static final SdkField<String> PROJECT_DESIGNATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectDesignation").getter(getter(ProjectPolicyGrantPrincipal::projectDesignationAsString))
            .setter(setter(Builder::projectDesignation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectDesignation").build())
            .build();

    private static final SdkField<ProjectGrantFilter> PROJECT_GRANT_FILTER_FIELD = SdkField
            .<ProjectGrantFilter> builder(MarshallingType.SDK_POJO).memberName("projectGrantFilter")
            .getter(getter(ProjectPolicyGrantPrincipal::projectGrantFilter)).setter(setter(Builder::projectGrantFilter))
            .constructor(ProjectGrantFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectGrantFilter").build())
            .build();

    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectIdentifier").getter(getter(ProjectPolicyGrantPrincipal::projectIdentifier))
            .setter(setter(Builder::projectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_DESIGNATION_FIELD,
            PROJECT_GRANT_FILTER_FIELD, PROJECT_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String projectDesignation;

    private final ProjectGrantFilter projectGrantFilter;

    private final String projectIdentifier;

    private ProjectPolicyGrantPrincipal(BuilderImpl builder) {
        this.projectDesignation = builder.projectDesignation;
        this.projectGrantFilter = builder.projectGrantFilter;
        this.projectIdentifier = builder.projectIdentifier;
    }

    /**
     * <p>
     * The project designation of the project policy grant principal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #projectDesignation} will return {@link ProjectDesignation#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #projectDesignationAsString}.
     * </p>
     * 
     * @return The project designation of the project policy grant principal.
     * @see ProjectDesignation
     */
    public final ProjectDesignation projectDesignation() {
        return ProjectDesignation.fromValue(projectDesignation);
    }

    /**
     * <p>
     * The project designation of the project policy grant principal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #projectDesignation} will return {@link ProjectDesignation#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #projectDesignationAsString}.
     * </p>
     * 
     * @return The project designation of the project policy grant principal.
     * @see ProjectDesignation
     */
    public final String projectDesignationAsString() {
        return projectDesignation;
    }

    /**
     * <p>
     * The project grant filter of the project policy grant principal.
     * </p>
     * 
     * @return The project grant filter of the project policy grant principal.
     */
    public final ProjectGrantFilter projectGrantFilter() {
        return projectGrantFilter;
    }

    /**
     * <p>
     * The project ID of the project policy grant principal.
     * </p>
     * 
     * @return The project ID of the project policy grant principal.
     */
    public final String projectIdentifier() {
        return projectIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectDesignationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(projectGrantFilter());
        hashCode = 31 * hashCode + Objects.hashCode(projectIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectPolicyGrantPrincipal)) {
            return false;
        }
        ProjectPolicyGrantPrincipal other = (ProjectPolicyGrantPrincipal) obj;
        return Objects.equals(projectDesignationAsString(), other.projectDesignationAsString())
                && Objects.equals(projectGrantFilter(), other.projectGrantFilter())
                && Objects.equals(projectIdentifier(), other.projectIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectPolicyGrantPrincipal").add("ProjectDesignation", projectDesignationAsString())
                .add("ProjectGrantFilter", projectGrantFilter()).add("ProjectIdentifier", projectIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectDesignation":
            return Optional.ofNullable(clazz.cast(projectDesignationAsString()));
        case "projectGrantFilter":
            return Optional.ofNullable(clazz.cast(projectGrantFilter()));
        case "projectIdentifier":
            return Optional.ofNullable(clazz.cast(projectIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectPolicyGrantPrincipal, T> g) {
        return obj -> g.apply((ProjectPolicyGrantPrincipal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectPolicyGrantPrincipal> {
        /**
         * <p>
         * The project designation of the project policy grant principal.
         * </p>
         * 
         * @param projectDesignation
         *        The project designation of the project policy grant principal.
         * @see ProjectDesignation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectDesignation
         */
        Builder projectDesignation(String projectDesignation);

        /**
         * <p>
         * The project designation of the project policy grant principal.
         * </p>
         * 
         * @param projectDesignation
         *        The project designation of the project policy grant principal.
         * @see ProjectDesignation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectDesignation
         */
        Builder projectDesignation(ProjectDesignation projectDesignation);

        /**
         * <p>
         * The project grant filter of the project policy grant principal.
         * </p>
         * 
         * @param projectGrantFilter
         *        The project grant filter of the project policy grant principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectGrantFilter(ProjectGrantFilter projectGrantFilter);

        /**
         * <p>
         * The project grant filter of the project policy grant principal.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProjectGrantFilter.Builder} avoiding the
         * need to create one manually via {@link ProjectGrantFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProjectGrantFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #projectGrantFilter(ProjectGrantFilter)}.
         * 
         * @param projectGrantFilter
         *        a consumer that will call methods on {@link ProjectGrantFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectGrantFilter(ProjectGrantFilter)
         */
        default Builder projectGrantFilter(Consumer<ProjectGrantFilter.Builder> projectGrantFilter) {
            return projectGrantFilter(ProjectGrantFilter.builder().applyMutation(projectGrantFilter).build());
        }

        /**
         * <p>
         * The project ID of the project policy grant principal.
         * </p>
         * 
         * @param projectIdentifier
         *        The project ID of the project policy grant principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectIdentifier(String projectIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String projectDesignation;

        private ProjectGrantFilter projectGrantFilter;

        private String projectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectPolicyGrantPrincipal model) {
            projectDesignation(model.projectDesignation);
            projectGrantFilter(model.projectGrantFilter);
            projectIdentifier(model.projectIdentifier);
        }

        public final String getProjectDesignation() {
            return projectDesignation;
        }

        public final void setProjectDesignation(String projectDesignation) {
            this.projectDesignation = projectDesignation;
        }

        @Override
        public final Builder projectDesignation(String projectDesignation) {
            this.projectDesignation = projectDesignation;
            return this;
        }

        @Override
        public final Builder projectDesignation(ProjectDesignation projectDesignation) {
            this.projectDesignation(projectDesignation == null ? null : projectDesignation.toString());
            return this;
        }

        public final ProjectGrantFilter.Builder getProjectGrantFilter() {
            return projectGrantFilter != null ? projectGrantFilter.toBuilder() : null;
        }

        public final void setProjectGrantFilter(ProjectGrantFilter.BuilderImpl projectGrantFilter) {
            this.projectGrantFilter = projectGrantFilter != null ? projectGrantFilter.build() : null;
        }

        @Override
        public final Builder projectGrantFilter(ProjectGrantFilter projectGrantFilter) {
            this.projectGrantFilter = projectGrantFilter;
            return this;
        }

        public final String getProjectIdentifier() {
            return projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        @Override
        public ProjectPolicyGrantPrincipal build() {
            return new ProjectPolicyGrantPrincipal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
