/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the policy grant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyGrantDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyGrantDetail.Builder, PolicyGrantDetail> {
    private static final SdkField<AddToProjectMemberPoolPolicyGrantDetail> ADD_TO_PROJECT_MEMBER_POOL_FIELD = SdkField
            .<AddToProjectMemberPoolPolicyGrantDetail> builder(MarshallingType.SDK_POJO).memberName("addToProjectMemberPool")
            .getter(getter(PolicyGrantDetail::addToProjectMemberPool)).setter(setter(Builder::addToProjectMemberPool))
            .constructor(AddToProjectMemberPoolPolicyGrantDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addToProjectMemberPool").build())
            .build();

    private static final SdkField<CreateAssetTypePolicyGrantDetail> CREATE_ASSET_TYPE_FIELD = SdkField
            .<CreateAssetTypePolicyGrantDetail> builder(MarshallingType.SDK_POJO).memberName("createAssetType")
            .getter(getter(PolicyGrantDetail::createAssetType)).setter(setter(Builder::createAssetType))
            .constructor(CreateAssetTypePolicyGrantDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createAssetType").build()).build();

    private static final SdkField<CreateDomainUnitPolicyGrantDetail> CREATE_DOMAIN_UNIT_FIELD = SdkField
            .<CreateDomainUnitPolicyGrantDetail> builder(MarshallingType.SDK_POJO).memberName("createDomainUnit")
            .getter(getter(PolicyGrantDetail::createDomainUnit)).setter(setter(Builder::createDomainUnit))
            .constructor(CreateDomainUnitPolicyGrantDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createDomainUnit").build()).build();

    private static final SdkField<Unit> CREATE_ENVIRONMENT_FIELD = SdkField.<Unit> builder(MarshallingType.SDK_POJO)
            .memberName("createEnvironment").getter(getter(PolicyGrantDetail::createEnvironment))
            .setter(setter(Builder::createEnvironment)).constructor(Unit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createEnvironment").build()).build();

    private static final SdkField<CreateEnvironmentProfilePolicyGrantDetail> CREATE_ENVIRONMENT_PROFILE_FIELD = SdkField
            .<CreateEnvironmentProfilePolicyGrantDetail> builder(MarshallingType.SDK_POJO).memberName("createEnvironmentProfile")
            .getter(getter(PolicyGrantDetail::createEnvironmentProfile)).setter(setter(Builder::createEnvironmentProfile))
            .constructor(CreateEnvironmentProfilePolicyGrantDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createEnvironmentProfile").build())
            .build();

    private static final SdkField<CreateFormTypePolicyGrantDetail> CREATE_FORM_TYPE_FIELD = SdkField
            .<CreateFormTypePolicyGrantDetail> builder(MarshallingType.SDK_POJO).memberName("createFormType")
            .getter(getter(PolicyGrantDetail::createFormType)).setter(setter(Builder::createFormType))
            .constructor(CreateFormTypePolicyGrantDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createFormType").build()).build();

    private static final SdkField<CreateGlossaryPolicyGrantDetail> CREATE_GLOSSARY_FIELD = SdkField
            .<CreateGlossaryPolicyGrantDetail> builder(MarshallingType.SDK_POJO).memberName("createGlossary")
            .getter(getter(PolicyGrantDetail::createGlossary)).setter(setter(Builder::createGlossary))
            .constructor(CreateGlossaryPolicyGrantDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createGlossary").build()).build();

    private static final SdkField<CreateProjectPolicyGrantDetail> CREATE_PROJECT_FIELD = SdkField
            .<CreateProjectPolicyGrantDetail> builder(MarshallingType.SDK_POJO).memberName("createProject")
            .getter(getter(PolicyGrantDetail::createProject)).setter(setter(Builder::createProject))
            .constructor(CreateProjectPolicyGrantDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createProject").build()).build();

    private static final SdkField<Unit> DELEGATE_CREATE_ENVIRONMENT_PROFILE_FIELD = SdkField
            .<Unit> builder(MarshallingType.SDK_POJO)
            .memberName("delegateCreateEnvironmentProfile")
            .getter(getter(PolicyGrantDetail::delegateCreateEnvironmentProfile))
            .setter(setter(Builder::delegateCreateEnvironmentProfile))
            .constructor(Unit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegateCreateEnvironmentProfile")
                    .build()).build();

    private static final SdkField<OverrideDomainUnitOwnersPolicyGrantDetail> OVERRIDE_DOMAIN_UNIT_OWNERS_FIELD = SdkField
            .<OverrideDomainUnitOwnersPolicyGrantDetail> builder(MarshallingType.SDK_POJO).memberName("overrideDomainUnitOwners")
            .getter(getter(PolicyGrantDetail::overrideDomainUnitOwners)).setter(setter(Builder::overrideDomainUnitOwners))
            .constructor(OverrideDomainUnitOwnersPolicyGrantDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideDomainUnitOwners").build())
            .build();

    private static final SdkField<OverrideProjectOwnersPolicyGrantDetail> OVERRIDE_PROJECT_OWNERS_FIELD = SdkField
            .<OverrideProjectOwnersPolicyGrantDetail> builder(MarshallingType.SDK_POJO).memberName("overrideProjectOwners")
            .getter(getter(PolicyGrantDetail::overrideProjectOwners)).setter(setter(Builder::overrideProjectOwners))
            .constructor(OverrideProjectOwnersPolicyGrantDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideProjectOwners").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADD_TO_PROJECT_MEMBER_POOL_FIELD, CREATE_ASSET_TYPE_FIELD, CREATE_DOMAIN_UNIT_FIELD, CREATE_ENVIRONMENT_FIELD,
            CREATE_ENVIRONMENT_PROFILE_FIELD, CREATE_FORM_TYPE_FIELD, CREATE_GLOSSARY_FIELD, CREATE_PROJECT_FIELD,
            DELEGATE_CREATE_ENVIRONMENT_PROFILE_FIELD, OVERRIDE_DOMAIN_UNIT_OWNERS_FIELD, OVERRIDE_PROJECT_OWNERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AddToProjectMemberPoolPolicyGrantDetail addToProjectMemberPool;

    private final CreateAssetTypePolicyGrantDetail createAssetType;

    private final CreateDomainUnitPolicyGrantDetail createDomainUnit;

    private final Unit createEnvironment;

    private final CreateEnvironmentProfilePolicyGrantDetail createEnvironmentProfile;

    private final CreateFormTypePolicyGrantDetail createFormType;

    private final CreateGlossaryPolicyGrantDetail createGlossary;

    private final CreateProjectPolicyGrantDetail createProject;

    private final Unit delegateCreateEnvironmentProfile;

    private final OverrideDomainUnitOwnersPolicyGrantDetail overrideDomainUnitOwners;

    private final OverrideProjectOwnersPolicyGrantDetail overrideProjectOwners;

    private final Type type;

    private PolicyGrantDetail(BuilderImpl builder) {
        this.addToProjectMemberPool = builder.addToProjectMemberPool;
        this.createAssetType = builder.createAssetType;
        this.createDomainUnit = builder.createDomainUnit;
        this.createEnvironment = builder.createEnvironment;
        this.createEnvironmentProfile = builder.createEnvironmentProfile;
        this.createFormType = builder.createFormType;
        this.createGlossary = builder.createGlossary;
        this.createProject = builder.createProject;
        this.delegateCreateEnvironmentProfile = builder.delegateCreateEnvironmentProfile;
        this.overrideDomainUnitOwners = builder.overrideDomainUnitOwners;
        this.overrideProjectOwners = builder.overrideProjectOwners;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies that the policy grant is to be added to the members of the project.
     * </p>
     * 
     * @return Specifies that the policy grant is to be added to the members of the project.
     */
    public final AddToProjectMemberPoolPolicyGrantDetail addToProjectMemberPool() {
        return addToProjectMemberPool;
    }

    /**
     * <p>
     * Specifies that this is a create asset type policy.
     * </p>
     * 
     * @return Specifies that this is a create asset type policy.
     */
    public final CreateAssetTypePolicyGrantDetail createAssetType() {
        return createAssetType;
    }

    /**
     * <p>
     * Specifies that this is a create domain unit policy.
     * </p>
     * 
     * @return Specifies that this is a create domain unit policy.
     */
    public final CreateDomainUnitPolicyGrantDetail createDomainUnit() {
        return createDomainUnit;
    }

    /**
     * <p>
     * Specifies that this is a create environment policy.
     * </p>
     * 
     * @return Specifies that this is a create environment policy.
     */
    public final Unit createEnvironment() {
        return createEnvironment;
    }

    /**
     * <p>
     * Specifies that this is a create environment profile policy.
     * </p>
     * 
     * @return Specifies that this is a create environment profile policy.
     */
    public final CreateEnvironmentProfilePolicyGrantDetail createEnvironmentProfile() {
        return createEnvironmentProfile;
    }

    /**
     * <p>
     * Specifies that this is a create form type policy.
     * </p>
     * 
     * @return Specifies that this is a create form type policy.
     */
    public final CreateFormTypePolicyGrantDetail createFormType() {
        return createFormType;
    }

    /**
     * <p>
     * Specifies that this is a create glossary policy.
     * </p>
     * 
     * @return Specifies that this is a create glossary policy.
     */
    public final CreateGlossaryPolicyGrantDetail createGlossary() {
        return createGlossary;
    }

    /**
     * <p>
     * Specifies that this is a create project policy.
     * </p>
     * 
     * @return Specifies that this is a create project policy.
     */
    public final CreateProjectPolicyGrantDetail createProject() {
        return createProject;
    }

    /**
     * <p>
     * Specifies that this is the delegation of the create environment profile policy.
     * </p>
     * 
     * @return Specifies that this is the delegation of the create environment profile policy.
     */
    public final Unit delegateCreateEnvironmentProfile() {
        return delegateCreateEnvironmentProfile;
    }

    /**
     * <p>
     * Specifies whether to override domain unit owners.
     * </p>
     * 
     * @return Specifies whether to override domain unit owners.
     */
    public final OverrideDomainUnitOwnersPolicyGrantDetail overrideDomainUnitOwners() {
        return overrideDomainUnitOwners;
    }

    /**
     * <p>
     * Specifies whether to override project owners.
     * </p>
     * 
     * @return Specifies whether to override project owners.
     */
    public final OverrideProjectOwnersPolicyGrantDetail overrideProjectOwners() {
        return overrideProjectOwners;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addToProjectMemberPool());
        hashCode = 31 * hashCode + Objects.hashCode(createAssetType());
        hashCode = 31 * hashCode + Objects.hashCode(createDomainUnit());
        hashCode = 31 * hashCode + Objects.hashCode(createEnvironment());
        hashCode = 31 * hashCode + Objects.hashCode(createEnvironmentProfile());
        hashCode = 31 * hashCode + Objects.hashCode(createFormType());
        hashCode = 31 * hashCode + Objects.hashCode(createGlossary());
        hashCode = 31 * hashCode + Objects.hashCode(createProject());
        hashCode = 31 * hashCode + Objects.hashCode(delegateCreateEnvironmentProfile());
        hashCode = 31 * hashCode + Objects.hashCode(overrideDomainUnitOwners());
        hashCode = 31 * hashCode + Objects.hashCode(overrideProjectOwners());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyGrantDetail)) {
            return false;
        }
        PolicyGrantDetail other = (PolicyGrantDetail) obj;
        return Objects.equals(addToProjectMemberPool(), other.addToProjectMemberPool())
                && Objects.equals(createAssetType(), other.createAssetType())
                && Objects.equals(createDomainUnit(), other.createDomainUnit())
                && Objects.equals(createEnvironment(), other.createEnvironment())
                && Objects.equals(createEnvironmentProfile(), other.createEnvironmentProfile())
                && Objects.equals(createFormType(), other.createFormType())
                && Objects.equals(createGlossary(), other.createGlossary())
                && Objects.equals(createProject(), other.createProject())
                && Objects.equals(delegateCreateEnvironmentProfile(), other.delegateCreateEnvironmentProfile())
                && Objects.equals(overrideDomainUnitOwners(), other.overrideDomainUnitOwners())
                && Objects.equals(overrideProjectOwners(), other.overrideProjectOwners());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyGrantDetail").add("AddToProjectMemberPool", addToProjectMemberPool())
                .add("CreateAssetType", createAssetType()).add("CreateDomainUnit", createDomainUnit())
                .add("CreateEnvironment", createEnvironment()).add("CreateEnvironmentProfile", createEnvironmentProfile())
                .add("CreateFormType", createFormType()).add("CreateGlossary", createGlossary())
                .add("CreateProject", createProject())
                .add("DelegateCreateEnvironmentProfile", delegateCreateEnvironmentProfile())
                .add("OverrideDomainUnitOwners", overrideDomainUnitOwners())
                .add("OverrideProjectOwners", overrideProjectOwners()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addToProjectMemberPool":
            return Optional.ofNullable(clazz.cast(addToProjectMemberPool()));
        case "createAssetType":
            return Optional.ofNullable(clazz.cast(createAssetType()));
        case "createDomainUnit":
            return Optional.ofNullable(clazz.cast(createDomainUnit()));
        case "createEnvironment":
            return Optional.ofNullable(clazz.cast(createEnvironment()));
        case "createEnvironmentProfile":
            return Optional.ofNullable(clazz.cast(createEnvironmentProfile()));
        case "createFormType":
            return Optional.ofNullable(clazz.cast(createFormType()));
        case "createGlossary":
            return Optional.ofNullable(clazz.cast(createGlossary()));
        case "createProject":
            return Optional.ofNullable(clazz.cast(createProject()));
        case "delegateCreateEnvironmentProfile":
            return Optional.ofNullable(clazz.cast(delegateCreateEnvironmentProfile()));
        case "overrideDomainUnitOwners":
            return Optional.ofNullable(clazz.cast(overrideDomainUnitOwners()));
        case "overrideProjectOwners":
            return Optional.ofNullable(clazz.cast(overrideProjectOwners()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #addToProjectMemberPool()} initialized to the given value.
     *
     * <p>
     * Specifies that the policy grant is to be added to the members of the project.
     * </p>
     * 
     * @param addToProjectMemberPool
     *        Specifies that the policy grant is to be added to the members of the project.
     */
    public static PolicyGrantDetail fromAddToProjectMemberPool(AddToProjectMemberPoolPolicyGrantDetail addToProjectMemberPool) {
        return builder().addToProjectMemberPool(addToProjectMemberPool).build();
    }

    /**
     * Create an instance of this class with {@link #addToProjectMemberPool()} initialized to the given value.
     *
     * <p>
     * Specifies that the policy grant is to be added to the members of the project.
     * </p>
     * 
     * @param addToProjectMemberPool
     *        Specifies that the policy grant is to be added to the members of the project.
     */
    public static PolicyGrantDetail fromAddToProjectMemberPool(
            Consumer<AddToProjectMemberPoolPolicyGrantDetail.Builder> addToProjectMemberPool) {
        AddToProjectMemberPoolPolicyGrantDetail.Builder builder = AddToProjectMemberPoolPolicyGrantDetail.builder();
        addToProjectMemberPool.accept(builder);
        return fromAddToProjectMemberPool(builder.build());
    }

    /**
     * Create an instance of this class with {@link #createAssetType()} initialized to the given value.
     *
     * <p>
     * Specifies that this is a create asset type policy.
     * </p>
     * 
     * @param createAssetType
     *        Specifies that this is a create asset type policy.
     */
    public static PolicyGrantDetail fromCreateAssetType(CreateAssetTypePolicyGrantDetail createAssetType) {
        return builder().createAssetType(createAssetType).build();
    }

    /**
     * Create an instance of this class with {@link #createAssetType()} initialized to the given value.
     *
     * <p>
     * Specifies that this is a create asset type policy.
     * </p>
     * 
     * @param createAssetType
     *        Specifies that this is a create asset type policy.
     */
    public static PolicyGrantDetail fromCreateAssetType(Consumer<CreateAssetTypePolicyGrantDetail.Builder> createAssetType) {
        CreateAssetTypePolicyGrantDetail.Builder builder = CreateAssetTypePolicyGrantDetail.builder();
        createAssetType.accept(builder);
        return fromCreateAssetType(builder.build());
    }

    /**
     * Create an instance of this class with {@link #createDomainUnit()} initialized to the given value.
     *
     * <p>
     * Specifies that this is a create domain unit policy.
     * </p>
     * 
     * @param createDomainUnit
     *        Specifies that this is a create domain unit policy.
     */
    public static PolicyGrantDetail fromCreateDomainUnit(CreateDomainUnitPolicyGrantDetail createDomainUnit) {
        return builder().createDomainUnit(createDomainUnit).build();
    }

    /**
     * Create an instance of this class with {@link #createDomainUnit()} initialized to the given value.
     *
     * <p>
     * Specifies that this is a create domain unit policy.
     * </p>
     * 
     * @param createDomainUnit
     *        Specifies that this is a create domain unit policy.
     */
    public static PolicyGrantDetail fromCreateDomainUnit(Consumer<CreateDomainUnitPolicyGrantDetail.Builder> createDomainUnit) {
        CreateDomainUnitPolicyGrantDetail.Builder builder = CreateDomainUnitPolicyGrantDetail.builder();
        createDomainUnit.accept(builder);
        return fromCreateDomainUnit(builder.build());
    }

    /**
     * Create an instance of this class with {@link #createEnvironment()} initialized to the given value.
     *
     * <p>
     * Specifies that this is a create environment policy.
     * </p>
     * 
     * @param createEnvironment
     *        Specifies that this is a create environment policy.
     */
    public static PolicyGrantDetail fromCreateEnvironment(Unit createEnvironment) {
        return builder().createEnvironment(createEnvironment).build();
    }

    /**
     * Create an instance of this class with {@link #createEnvironment()} initialized to the given value.
     *
     * <p>
     * Specifies that this is a create environment policy.
     * </p>
     * 
     * @param createEnvironment
     *        Specifies that this is a create environment policy.
     */
    public static PolicyGrantDetail fromCreateEnvironment(Consumer<Unit.Builder> createEnvironment) {
        Unit.Builder builder = Unit.builder();
        createEnvironment.accept(builder);
        return fromCreateEnvironment(builder.build());
    }

    /**
     * Create an instance of this class with {@link #createEnvironmentProfile()} initialized to the given value.
     *
     * <p>
     * Specifies that this is a create environment profile policy.
     * </p>
     * 
     * @param createEnvironmentProfile
     *        Specifies that this is a create environment profile policy.
     */
    public static PolicyGrantDetail fromCreateEnvironmentProfile(
            CreateEnvironmentProfilePolicyGrantDetail createEnvironmentProfile) {
        return builder().createEnvironmentProfile(createEnvironmentProfile).build();
    }

    /**
     * Create an instance of this class with {@link #createEnvironmentProfile()} initialized to the given value.
     *
     * <p>
     * Specifies that this is a create environment profile policy.
     * </p>
     * 
     * @param createEnvironmentProfile
     *        Specifies that this is a create environment profile policy.
     */
    public static PolicyGrantDetail fromCreateEnvironmentProfile(
            Consumer<CreateEnvironmentProfilePolicyGrantDetail.Builder> createEnvironmentProfile) {
        CreateEnvironmentProfilePolicyGrantDetail.Builder builder = CreateEnvironmentProfilePolicyGrantDetail.builder();
        createEnvironmentProfile.accept(builder);
        return fromCreateEnvironmentProfile(builder.build());
    }

    /**
     * Create an instance of this class with {@link #createFormType()} initialized to the given value.
     *
     * <p>
     * Specifies that this is a create form type policy.
     * </p>
     * 
     * @param createFormType
     *        Specifies that this is a create form type policy.
     */
    public static PolicyGrantDetail fromCreateFormType(CreateFormTypePolicyGrantDetail createFormType) {
        return builder().createFormType(createFormType).build();
    }

    /**
     * Create an instance of this class with {@link #createFormType()} initialized to the given value.
     *
     * <p>
     * Specifies that this is a create form type policy.
     * </p>
     * 
     * @param createFormType
     *        Specifies that this is a create form type policy.
     */
    public static PolicyGrantDetail fromCreateFormType(Consumer<CreateFormTypePolicyGrantDetail.Builder> createFormType) {
        CreateFormTypePolicyGrantDetail.Builder builder = CreateFormTypePolicyGrantDetail.builder();
        createFormType.accept(builder);
        return fromCreateFormType(builder.build());
    }

    /**
     * Create an instance of this class with {@link #createGlossary()} initialized to the given value.
     *
     * <p>
     * Specifies that this is a create glossary policy.
     * </p>
     * 
     * @param createGlossary
     *        Specifies that this is a create glossary policy.
     */
    public static PolicyGrantDetail fromCreateGlossary(CreateGlossaryPolicyGrantDetail createGlossary) {
        return builder().createGlossary(createGlossary).build();
    }

    /**
     * Create an instance of this class with {@link #createGlossary()} initialized to the given value.
     *
     * <p>
     * Specifies that this is a create glossary policy.
     * </p>
     * 
     * @param createGlossary
     *        Specifies that this is a create glossary policy.
     */
    public static PolicyGrantDetail fromCreateGlossary(Consumer<CreateGlossaryPolicyGrantDetail.Builder> createGlossary) {
        CreateGlossaryPolicyGrantDetail.Builder builder = CreateGlossaryPolicyGrantDetail.builder();
        createGlossary.accept(builder);
        return fromCreateGlossary(builder.build());
    }

    /**
     * Create an instance of this class with {@link #createProject()} initialized to the given value.
     *
     * <p>
     * Specifies that this is a create project policy.
     * </p>
     * 
     * @param createProject
     *        Specifies that this is a create project policy.
     */
    public static PolicyGrantDetail fromCreateProject(CreateProjectPolicyGrantDetail createProject) {
        return builder().createProject(createProject).build();
    }

    /**
     * Create an instance of this class with {@link #createProject()} initialized to the given value.
     *
     * <p>
     * Specifies that this is a create project policy.
     * </p>
     * 
     * @param createProject
     *        Specifies that this is a create project policy.
     */
    public static PolicyGrantDetail fromCreateProject(Consumer<CreateProjectPolicyGrantDetail.Builder> createProject) {
        CreateProjectPolicyGrantDetail.Builder builder = CreateProjectPolicyGrantDetail.builder();
        createProject.accept(builder);
        return fromCreateProject(builder.build());
    }

    /**
     * Create an instance of this class with {@link #delegateCreateEnvironmentProfile()} initialized to the given value.
     *
     * <p>
     * Specifies that this is the delegation of the create environment profile policy.
     * </p>
     * 
     * @param delegateCreateEnvironmentProfile
     *        Specifies that this is the delegation of the create environment profile policy.
     */
    public static PolicyGrantDetail fromDelegateCreateEnvironmentProfile(Unit delegateCreateEnvironmentProfile) {
        return builder().delegateCreateEnvironmentProfile(delegateCreateEnvironmentProfile).build();
    }

    /**
     * Create an instance of this class with {@link #delegateCreateEnvironmentProfile()} initialized to the given value.
     *
     * <p>
     * Specifies that this is the delegation of the create environment profile policy.
     * </p>
     * 
     * @param delegateCreateEnvironmentProfile
     *        Specifies that this is the delegation of the create environment profile policy.
     */
    public static PolicyGrantDetail fromDelegateCreateEnvironmentProfile(Consumer<Unit.Builder> delegateCreateEnvironmentProfile) {
        Unit.Builder builder = Unit.builder();
        delegateCreateEnvironmentProfile.accept(builder);
        return fromDelegateCreateEnvironmentProfile(builder.build());
    }

    /**
     * Create an instance of this class with {@link #overrideDomainUnitOwners()} initialized to the given value.
     *
     * <p>
     * Specifies whether to override domain unit owners.
     * </p>
     * 
     * @param overrideDomainUnitOwners
     *        Specifies whether to override domain unit owners.
     */
    public static PolicyGrantDetail fromOverrideDomainUnitOwners(
            OverrideDomainUnitOwnersPolicyGrantDetail overrideDomainUnitOwners) {
        return builder().overrideDomainUnitOwners(overrideDomainUnitOwners).build();
    }

    /**
     * Create an instance of this class with {@link #overrideDomainUnitOwners()} initialized to the given value.
     *
     * <p>
     * Specifies whether to override domain unit owners.
     * </p>
     * 
     * @param overrideDomainUnitOwners
     *        Specifies whether to override domain unit owners.
     */
    public static PolicyGrantDetail fromOverrideDomainUnitOwners(
            Consumer<OverrideDomainUnitOwnersPolicyGrantDetail.Builder> overrideDomainUnitOwners) {
        OverrideDomainUnitOwnersPolicyGrantDetail.Builder builder = OverrideDomainUnitOwnersPolicyGrantDetail.builder();
        overrideDomainUnitOwners.accept(builder);
        return fromOverrideDomainUnitOwners(builder.build());
    }

    /**
     * Create an instance of this class with {@link #overrideProjectOwners()} initialized to the given value.
     *
     * <p>
     * Specifies whether to override project owners.
     * </p>
     * 
     * @param overrideProjectOwners
     *        Specifies whether to override project owners.
     */
    public static PolicyGrantDetail fromOverrideProjectOwners(OverrideProjectOwnersPolicyGrantDetail overrideProjectOwners) {
        return builder().overrideProjectOwners(overrideProjectOwners).build();
    }

    /**
     * Create an instance of this class with {@link #overrideProjectOwners()} initialized to the given value.
     *
     * <p>
     * Specifies whether to override project owners.
     * </p>
     * 
     * @param overrideProjectOwners
     *        Specifies whether to override project owners.
     */
    public static PolicyGrantDetail fromOverrideProjectOwners(
            Consumer<OverrideProjectOwnersPolicyGrantDetail.Builder> overrideProjectOwners) {
        OverrideProjectOwnersPolicyGrantDetail.Builder builder = OverrideProjectOwnersPolicyGrantDetail.builder();
        overrideProjectOwners.accept(builder);
        return fromOverrideProjectOwners(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyGrantDetail, T> g) {
        return obj -> g.apply((PolicyGrantDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyGrantDetail> {
        /**
         * <p>
         * Specifies that the policy grant is to be added to the members of the project.
         * </p>
         * 
         * @param addToProjectMemberPool
         *        Specifies that the policy grant is to be added to the members of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addToProjectMemberPool(AddToProjectMemberPoolPolicyGrantDetail addToProjectMemberPool);

        /**
         * <p>
         * Specifies that the policy grant is to be added to the members of the project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AddToProjectMemberPoolPolicyGrantDetail.Builder} avoiding the need to create one manually via
         * {@link AddToProjectMemberPoolPolicyGrantDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddToProjectMemberPoolPolicyGrantDetail.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #addToProjectMemberPool(AddToProjectMemberPoolPolicyGrantDetail)}.
         * 
         * @param addToProjectMemberPool
         *        a consumer that will call methods on {@link AddToProjectMemberPoolPolicyGrantDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addToProjectMemberPool(AddToProjectMemberPoolPolicyGrantDetail)
         */
        default Builder addToProjectMemberPool(Consumer<AddToProjectMemberPoolPolicyGrantDetail.Builder> addToProjectMemberPool) {
            return addToProjectMemberPool(AddToProjectMemberPoolPolicyGrantDetail.builder().applyMutation(addToProjectMemberPool)
                    .build());
        }

        /**
         * <p>
         * Specifies that this is a create asset type policy.
         * </p>
         * 
         * @param createAssetType
         *        Specifies that this is a create asset type policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createAssetType(CreateAssetTypePolicyGrantDetail createAssetType);

        /**
         * <p>
         * Specifies that this is a create asset type policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateAssetTypePolicyGrantDetail.Builder}
         * avoiding the need to create one manually via {@link CreateAssetTypePolicyGrantDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateAssetTypePolicyGrantDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #createAssetType(CreateAssetTypePolicyGrantDetail)}.
         * 
         * @param createAssetType
         *        a consumer that will call methods on {@link CreateAssetTypePolicyGrantDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createAssetType(CreateAssetTypePolicyGrantDetail)
         */
        default Builder createAssetType(Consumer<CreateAssetTypePolicyGrantDetail.Builder> createAssetType) {
            return createAssetType(CreateAssetTypePolicyGrantDetail.builder().applyMutation(createAssetType).build());
        }

        /**
         * <p>
         * Specifies that this is a create domain unit policy.
         * </p>
         * 
         * @param createDomainUnit
         *        Specifies that this is a create domain unit policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDomainUnit(CreateDomainUnitPolicyGrantDetail createDomainUnit);

        /**
         * <p>
         * Specifies that this is a create domain unit policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateDomainUnitPolicyGrantDetail.Builder} avoiding the need to create one manually via
         * {@link CreateDomainUnitPolicyGrantDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateDomainUnitPolicyGrantDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #createDomainUnit(CreateDomainUnitPolicyGrantDetail)}.
         * 
         * @param createDomainUnit
         *        a consumer that will call methods on {@link CreateDomainUnitPolicyGrantDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createDomainUnit(CreateDomainUnitPolicyGrantDetail)
         */
        default Builder createDomainUnit(Consumer<CreateDomainUnitPolicyGrantDetail.Builder> createDomainUnit) {
            return createDomainUnit(CreateDomainUnitPolicyGrantDetail.builder().applyMutation(createDomainUnit).build());
        }

        /**
         * <p>
         * Specifies that this is a create environment policy.
         * </p>
         * 
         * @param createEnvironment
         *        Specifies that this is a create environment policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createEnvironment(Unit createEnvironment);

        /**
         * <p>
         * Specifies that this is a create environment policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link Unit.Builder} avoiding the need to create
         * one manually via {@link Unit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Unit.Builder#build()} is called immediately and its result is
         * passed to {@link #createEnvironment(Unit)}.
         * 
         * @param createEnvironment
         *        a consumer that will call methods on {@link Unit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createEnvironment(Unit)
         */
        default Builder createEnvironment(Consumer<Unit.Builder> createEnvironment) {
            return createEnvironment(Unit.builder().applyMutation(createEnvironment).build());
        }

        /**
         * <p>
         * Specifies that this is a create environment profile policy.
         * </p>
         * 
         * @param createEnvironmentProfile
         *        Specifies that this is a create environment profile policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createEnvironmentProfile(CreateEnvironmentProfilePolicyGrantDetail createEnvironmentProfile);

        /**
         * <p>
         * Specifies that this is a create environment profile policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateEnvironmentProfilePolicyGrantDetail.Builder} avoiding the need to create one manually via
         * {@link CreateEnvironmentProfilePolicyGrantDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateEnvironmentProfilePolicyGrantDetail.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #createEnvironmentProfile(CreateEnvironmentProfilePolicyGrantDetail)}.
         * 
         * @param createEnvironmentProfile
         *        a consumer that will call methods on {@link CreateEnvironmentProfilePolicyGrantDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createEnvironmentProfile(CreateEnvironmentProfilePolicyGrantDetail)
         */
        default Builder createEnvironmentProfile(
                Consumer<CreateEnvironmentProfilePolicyGrantDetail.Builder> createEnvironmentProfile) {
            return createEnvironmentProfile(CreateEnvironmentProfilePolicyGrantDetail.builder()
                    .applyMutation(createEnvironmentProfile).build());
        }

        /**
         * <p>
         * Specifies that this is a create form type policy.
         * </p>
         * 
         * @param createFormType
         *        Specifies that this is a create form type policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createFormType(CreateFormTypePolicyGrantDetail createFormType);

        /**
         * <p>
         * Specifies that this is a create form type policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateFormTypePolicyGrantDetail.Builder}
         * avoiding the need to create one manually via {@link CreateFormTypePolicyGrantDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateFormTypePolicyGrantDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #createFormType(CreateFormTypePolicyGrantDetail)}.
         * 
         * @param createFormType
         *        a consumer that will call methods on {@link CreateFormTypePolicyGrantDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createFormType(CreateFormTypePolicyGrantDetail)
         */
        default Builder createFormType(Consumer<CreateFormTypePolicyGrantDetail.Builder> createFormType) {
            return createFormType(CreateFormTypePolicyGrantDetail.builder().applyMutation(createFormType).build());
        }

        /**
         * <p>
         * Specifies that this is a create glossary policy.
         * </p>
         * 
         * @param createGlossary
         *        Specifies that this is a create glossary policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createGlossary(CreateGlossaryPolicyGrantDetail createGlossary);

        /**
         * <p>
         * Specifies that this is a create glossary policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateGlossaryPolicyGrantDetail.Builder}
         * avoiding the need to create one manually via {@link CreateGlossaryPolicyGrantDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateGlossaryPolicyGrantDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #createGlossary(CreateGlossaryPolicyGrantDetail)}.
         * 
         * @param createGlossary
         *        a consumer that will call methods on {@link CreateGlossaryPolicyGrantDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createGlossary(CreateGlossaryPolicyGrantDetail)
         */
        default Builder createGlossary(Consumer<CreateGlossaryPolicyGrantDetail.Builder> createGlossary) {
            return createGlossary(CreateGlossaryPolicyGrantDetail.builder().applyMutation(createGlossary).build());
        }

        /**
         * <p>
         * Specifies that this is a create project policy.
         * </p>
         * 
         * @param createProject
         *        Specifies that this is a create project policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createProject(CreateProjectPolicyGrantDetail createProject);

        /**
         * <p>
         * Specifies that this is a create project policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateProjectPolicyGrantDetail.Builder}
         * avoiding the need to create one manually via {@link CreateProjectPolicyGrantDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateProjectPolicyGrantDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #createProject(CreateProjectPolicyGrantDetail)}.
         * 
         * @param createProject
         *        a consumer that will call methods on {@link CreateProjectPolicyGrantDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createProject(CreateProjectPolicyGrantDetail)
         */
        default Builder createProject(Consumer<CreateProjectPolicyGrantDetail.Builder> createProject) {
            return createProject(CreateProjectPolicyGrantDetail.builder().applyMutation(createProject).build());
        }

        /**
         * <p>
         * Specifies that this is the delegation of the create environment profile policy.
         * </p>
         * 
         * @param delegateCreateEnvironmentProfile
         *        Specifies that this is the delegation of the create environment profile policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegateCreateEnvironmentProfile(Unit delegateCreateEnvironmentProfile);

        /**
         * <p>
         * Specifies that this is the delegation of the create environment profile policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link Unit.Builder} avoiding the need to create
         * one manually via {@link Unit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Unit.Builder#build()} is called immediately and its result is
         * passed to {@link #delegateCreateEnvironmentProfile(Unit)}.
         * 
         * @param delegateCreateEnvironmentProfile
         *        a consumer that will call methods on {@link Unit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegateCreateEnvironmentProfile(Unit)
         */
        default Builder delegateCreateEnvironmentProfile(Consumer<Unit.Builder> delegateCreateEnvironmentProfile) {
            return delegateCreateEnvironmentProfile(Unit.builder().applyMutation(delegateCreateEnvironmentProfile).build());
        }

        /**
         * <p>
         * Specifies whether to override domain unit owners.
         * </p>
         * 
         * @param overrideDomainUnitOwners
         *        Specifies whether to override domain unit owners.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideDomainUnitOwners(OverrideDomainUnitOwnersPolicyGrantDetail overrideDomainUnitOwners);

        /**
         * <p>
         * Specifies whether to override domain unit owners.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OverrideDomainUnitOwnersPolicyGrantDetail.Builder} avoiding the need to create one manually via
         * {@link OverrideDomainUnitOwnersPolicyGrantDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OverrideDomainUnitOwnersPolicyGrantDetail.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #overrideDomainUnitOwners(OverrideDomainUnitOwnersPolicyGrantDetail)}.
         * 
         * @param overrideDomainUnitOwners
         *        a consumer that will call methods on {@link OverrideDomainUnitOwnersPolicyGrantDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideDomainUnitOwners(OverrideDomainUnitOwnersPolicyGrantDetail)
         */
        default Builder overrideDomainUnitOwners(
                Consumer<OverrideDomainUnitOwnersPolicyGrantDetail.Builder> overrideDomainUnitOwners) {
            return overrideDomainUnitOwners(OverrideDomainUnitOwnersPolicyGrantDetail.builder()
                    .applyMutation(overrideDomainUnitOwners).build());
        }

        /**
         * <p>
         * Specifies whether to override project owners.
         * </p>
         * 
         * @param overrideProjectOwners
         *        Specifies whether to override project owners.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideProjectOwners(OverrideProjectOwnersPolicyGrantDetail overrideProjectOwners);

        /**
         * <p>
         * Specifies whether to override project owners.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OverrideProjectOwnersPolicyGrantDetail.Builder} avoiding the need to create one manually via
         * {@link OverrideProjectOwnersPolicyGrantDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OverrideProjectOwnersPolicyGrantDetail.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #overrideProjectOwners(OverrideProjectOwnersPolicyGrantDetail)}.
         * 
         * @param overrideProjectOwners
         *        a consumer that will call methods on {@link OverrideProjectOwnersPolicyGrantDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideProjectOwners(OverrideProjectOwnersPolicyGrantDetail)
         */
        default Builder overrideProjectOwners(Consumer<OverrideProjectOwnersPolicyGrantDetail.Builder> overrideProjectOwners) {
            return overrideProjectOwners(OverrideProjectOwnersPolicyGrantDetail.builder().applyMutation(overrideProjectOwners)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AddToProjectMemberPoolPolicyGrantDetail addToProjectMemberPool;

        private CreateAssetTypePolicyGrantDetail createAssetType;

        private CreateDomainUnitPolicyGrantDetail createDomainUnit;

        private Unit createEnvironment;

        private CreateEnvironmentProfilePolicyGrantDetail createEnvironmentProfile;

        private CreateFormTypePolicyGrantDetail createFormType;

        private CreateGlossaryPolicyGrantDetail createGlossary;

        private CreateProjectPolicyGrantDetail createProject;

        private Unit delegateCreateEnvironmentProfile;

        private OverrideDomainUnitOwnersPolicyGrantDetail overrideDomainUnitOwners;

        private OverrideProjectOwnersPolicyGrantDetail overrideProjectOwners;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyGrantDetail model) {
            addToProjectMemberPool(model.addToProjectMemberPool);
            createAssetType(model.createAssetType);
            createDomainUnit(model.createDomainUnit);
            createEnvironment(model.createEnvironment);
            createEnvironmentProfile(model.createEnvironmentProfile);
            createFormType(model.createFormType);
            createGlossary(model.createGlossary);
            createProject(model.createProject);
            delegateCreateEnvironmentProfile(model.delegateCreateEnvironmentProfile);
            overrideDomainUnitOwners(model.overrideDomainUnitOwners);
            overrideProjectOwners(model.overrideProjectOwners);
        }

        public final AddToProjectMemberPoolPolicyGrantDetail.Builder getAddToProjectMemberPool() {
            return addToProjectMemberPool != null ? addToProjectMemberPool.toBuilder() : null;
        }

        public final void setAddToProjectMemberPool(AddToProjectMemberPoolPolicyGrantDetail.BuilderImpl addToProjectMemberPool) {
            Object oldValue = this.addToProjectMemberPool;
            this.addToProjectMemberPool = addToProjectMemberPool != null ? addToProjectMemberPool.build() : null;
            handleUnionValueChange(Type.ADD_TO_PROJECT_MEMBER_POOL, oldValue, this.addToProjectMemberPool);
        }

        @Override
        public final Builder addToProjectMemberPool(AddToProjectMemberPoolPolicyGrantDetail addToProjectMemberPool) {
            Object oldValue = this.addToProjectMemberPool;
            this.addToProjectMemberPool = addToProjectMemberPool;
            handleUnionValueChange(Type.ADD_TO_PROJECT_MEMBER_POOL, oldValue, this.addToProjectMemberPool);
            return this;
        }

        public final CreateAssetTypePolicyGrantDetail.Builder getCreateAssetType() {
            return createAssetType != null ? createAssetType.toBuilder() : null;
        }

        public final void setCreateAssetType(CreateAssetTypePolicyGrantDetail.BuilderImpl createAssetType) {
            Object oldValue = this.createAssetType;
            this.createAssetType = createAssetType != null ? createAssetType.build() : null;
            handleUnionValueChange(Type.CREATE_ASSET_TYPE, oldValue, this.createAssetType);
        }

        @Override
        public final Builder createAssetType(CreateAssetTypePolicyGrantDetail createAssetType) {
            Object oldValue = this.createAssetType;
            this.createAssetType = createAssetType;
            handleUnionValueChange(Type.CREATE_ASSET_TYPE, oldValue, this.createAssetType);
            return this;
        }

        public final CreateDomainUnitPolicyGrantDetail.Builder getCreateDomainUnit() {
            return createDomainUnit != null ? createDomainUnit.toBuilder() : null;
        }

        public final void setCreateDomainUnit(CreateDomainUnitPolicyGrantDetail.BuilderImpl createDomainUnit) {
            Object oldValue = this.createDomainUnit;
            this.createDomainUnit = createDomainUnit != null ? createDomainUnit.build() : null;
            handleUnionValueChange(Type.CREATE_DOMAIN_UNIT, oldValue, this.createDomainUnit);
        }

        @Override
        public final Builder createDomainUnit(CreateDomainUnitPolicyGrantDetail createDomainUnit) {
            Object oldValue = this.createDomainUnit;
            this.createDomainUnit = createDomainUnit;
            handleUnionValueChange(Type.CREATE_DOMAIN_UNIT, oldValue, this.createDomainUnit);
            return this;
        }

        public final Unit.Builder getCreateEnvironment() {
            return createEnvironment != null ? createEnvironment.toBuilder() : null;
        }

        public final void setCreateEnvironment(Unit.BuilderImpl createEnvironment) {
            Object oldValue = this.createEnvironment;
            this.createEnvironment = createEnvironment != null ? createEnvironment.build() : null;
            handleUnionValueChange(Type.CREATE_ENVIRONMENT, oldValue, this.createEnvironment);
        }

        @Override
        public final Builder createEnvironment(Unit createEnvironment) {
            Object oldValue = this.createEnvironment;
            this.createEnvironment = createEnvironment;
            handleUnionValueChange(Type.CREATE_ENVIRONMENT, oldValue, this.createEnvironment);
            return this;
        }

        public final CreateEnvironmentProfilePolicyGrantDetail.Builder getCreateEnvironmentProfile() {
            return createEnvironmentProfile != null ? createEnvironmentProfile.toBuilder() : null;
        }

        public final void setCreateEnvironmentProfile(
                CreateEnvironmentProfilePolicyGrantDetail.BuilderImpl createEnvironmentProfile) {
            Object oldValue = this.createEnvironmentProfile;
            this.createEnvironmentProfile = createEnvironmentProfile != null ? createEnvironmentProfile.build() : null;
            handleUnionValueChange(Type.CREATE_ENVIRONMENT_PROFILE, oldValue, this.createEnvironmentProfile);
        }

        @Override
        public final Builder createEnvironmentProfile(CreateEnvironmentProfilePolicyGrantDetail createEnvironmentProfile) {
            Object oldValue = this.createEnvironmentProfile;
            this.createEnvironmentProfile = createEnvironmentProfile;
            handleUnionValueChange(Type.CREATE_ENVIRONMENT_PROFILE, oldValue, this.createEnvironmentProfile);
            return this;
        }

        public final CreateFormTypePolicyGrantDetail.Builder getCreateFormType() {
            return createFormType != null ? createFormType.toBuilder() : null;
        }

        public final void setCreateFormType(CreateFormTypePolicyGrantDetail.BuilderImpl createFormType) {
            Object oldValue = this.createFormType;
            this.createFormType = createFormType != null ? createFormType.build() : null;
            handleUnionValueChange(Type.CREATE_FORM_TYPE, oldValue, this.createFormType);
        }

        @Override
        public final Builder createFormType(CreateFormTypePolicyGrantDetail createFormType) {
            Object oldValue = this.createFormType;
            this.createFormType = createFormType;
            handleUnionValueChange(Type.CREATE_FORM_TYPE, oldValue, this.createFormType);
            return this;
        }

        public final CreateGlossaryPolicyGrantDetail.Builder getCreateGlossary() {
            return createGlossary != null ? createGlossary.toBuilder() : null;
        }

        public final void setCreateGlossary(CreateGlossaryPolicyGrantDetail.BuilderImpl createGlossary) {
            Object oldValue = this.createGlossary;
            this.createGlossary = createGlossary != null ? createGlossary.build() : null;
            handleUnionValueChange(Type.CREATE_GLOSSARY, oldValue, this.createGlossary);
        }

        @Override
        public final Builder createGlossary(CreateGlossaryPolicyGrantDetail createGlossary) {
            Object oldValue = this.createGlossary;
            this.createGlossary = createGlossary;
            handleUnionValueChange(Type.CREATE_GLOSSARY, oldValue, this.createGlossary);
            return this;
        }

        public final CreateProjectPolicyGrantDetail.Builder getCreateProject() {
            return createProject != null ? createProject.toBuilder() : null;
        }

        public final void setCreateProject(CreateProjectPolicyGrantDetail.BuilderImpl createProject) {
            Object oldValue = this.createProject;
            this.createProject = createProject != null ? createProject.build() : null;
            handleUnionValueChange(Type.CREATE_PROJECT, oldValue, this.createProject);
        }

        @Override
        public final Builder createProject(CreateProjectPolicyGrantDetail createProject) {
            Object oldValue = this.createProject;
            this.createProject = createProject;
            handleUnionValueChange(Type.CREATE_PROJECT, oldValue, this.createProject);
            return this;
        }

        public final Unit.Builder getDelegateCreateEnvironmentProfile() {
            return delegateCreateEnvironmentProfile != null ? delegateCreateEnvironmentProfile.toBuilder() : null;
        }

        public final void setDelegateCreateEnvironmentProfile(Unit.BuilderImpl delegateCreateEnvironmentProfile) {
            Object oldValue = this.delegateCreateEnvironmentProfile;
            this.delegateCreateEnvironmentProfile = delegateCreateEnvironmentProfile != null ? delegateCreateEnvironmentProfile
                    .build() : null;
            handleUnionValueChange(Type.DELEGATE_CREATE_ENVIRONMENT_PROFILE, oldValue, this.delegateCreateEnvironmentProfile);
        }

        @Override
        public final Builder delegateCreateEnvironmentProfile(Unit delegateCreateEnvironmentProfile) {
            Object oldValue = this.delegateCreateEnvironmentProfile;
            this.delegateCreateEnvironmentProfile = delegateCreateEnvironmentProfile;
            handleUnionValueChange(Type.DELEGATE_CREATE_ENVIRONMENT_PROFILE, oldValue, this.delegateCreateEnvironmentProfile);
            return this;
        }

        public final OverrideDomainUnitOwnersPolicyGrantDetail.Builder getOverrideDomainUnitOwners() {
            return overrideDomainUnitOwners != null ? overrideDomainUnitOwners.toBuilder() : null;
        }

        public final void setOverrideDomainUnitOwners(
                OverrideDomainUnitOwnersPolicyGrantDetail.BuilderImpl overrideDomainUnitOwners) {
            Object oldValue = this.overrideDomainUnitOwners;
            this.overrideDomainUnitOwners = overrideDomainUnitOwners != null ? overrideDomainUnitOwners.build() : null;
            handleUnionValueChange(Type.OVERRIDE_DOMAIN_UNIT_OWNERS, oldValue, this.overrideDomainUnitOwners);
        }

        @Override
        public final Builder overrideDomainUnitOwners(OverrideDomainUnitOwnersPolicyGrantDetail overrideDomainUnitOwners) {
            Object oldValue = this.overrideDomainUnitOwners;
            this.overrideDomainUnitOwners = overrideDomainUnitOwners;
            handleUnionValueChange(Type.OVERRIDE_DOMAIN_UNIT_OWNERS, oldValue, this.overrideDomainUnitOwners);
            return this;
        }

        public final OverrideProjectOwnersPolicyGrantDetail.Builder getOverrideProjectOwners() {
            return overrideProjectOwners != null ? overrideProjectOwners.toBuilder() : null;
        }

        public final void setOverrideProjectOwners(OverrideProjectOwnersPolicyGrantDetail.BuilderImpl overrideProjectOwners) {
            Object oldValue = this.overrideProjectOwners;
            this.overrideProjectOwners = overrideProjectOwners != null ? overrideProjectOwners.build() : null;
            handleUnionValueChange(Type.OVERRIDE_PROJECT_OWNERS, oldValue, this.overrideProjectOwners);
        }

        @Override
        public final Builder overrideProjectOwners(OverrideProjectOwnersPolicyGrantDetail overrideProjectOwners) {
            Object oldValue = this.overrideProjectOwners;
            this.overrideProjectOwners = overrideProjectOwners;
            handleUnionValueChange(Type.OVERRIDE_PROJECT_OWNERS, oldValue, this.overrideProjectOwners);
            return this;
        }

        @Override
        public PolicyGrantDetail build() {
            return new PolicyGrantDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PolicyGrantDetail#type()
     */
    public enum Type {
        ADD_TO_PROJECT_MEMBER_POOL,

        CREATE_ASSET_TYPE,

        CREATE_DOMAIN_UNIT,

        CREATE_ENVIRONMENT,

        CREATE_ENVIRONMENT_PROFILE,

        CREATE_FORM_TYPE,

        CREATE_GLOSSARY,

        CREATE_PROJECT,

        DELEGATE_CREATE_ENVIRONMENT_PROFILE,

        OVERRIDE_DOMAIN_UNIT_OWNERS,

        OVERRIDE_PROJECT_OWNERS,

        UNKNOWN_TO_SDK_VERSION
    }
}
