/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPolicyGrantsResponse extends DataZoneResponse implements
        ToCopyableBuilder<ListPolicyGrantsResponse.Builder, ListPolicyGrantsResponse> {
    private static final SdkField<List<PolicyGrantMember>> GRANT_LIST_FIELD = SdkField
            .<List<PolicyGrantMember>> builder(MarshallingType.LIST)
            .memberName("grantList")
            .getter(getter(ListPolicyGrantsResponse::grantList))
            .setter(setter(Builder::grantList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyGrantMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyGrantMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPolicyGrantsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANT_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PolicyGrantMember> grantList;

    private final String nextToken;

    private ListPolicyGrantsResponse(BuilderImpl builder) {
        super(builder);
        this.grantList = builder.grantList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the GrantList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGrantList() {
        return grantList != null && !(grantList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results of this action - the listed grants.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGrantList} method.
     * </p>
     * 
     * @return The results of this action - the listed grants.
     */
    public final List<PolicyGrantMember> grantList() {
        return grantList;
    }

    /**
     * <p>
     * When the number of grants is greater than the default value for the <code>MaxResults</code> parameter, or if you
     * explicitly specify a value for <code>MaxResults</code> that is less than the number of grants, the response
     * includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a
     * subsequent call to <code>ListPolicyGrants</code> to list the next set of grants.
     * </p>
     * 
     * @return When the number of grants is greater than the default value for the <code>MaxResults</code> parameter, or
     *         if you explicitly specify a value for <code>MaxResults</code> that is less than the number of grants, the
     *         response includes a pagination token named <code>NextToken</code>. You can specify this
     *         <code>NextToken</code> value in a subsequent call to <code>ListPolicyGrants</code> to list the next set
     *         of grants.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGrantList() ? grantList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyGrantsResponse)) {
            return false;
        }
        ListPolicyGrantsResponse other = (ListPolicyGrantsResponse) obj;
        return hasGrantList() == other.hasGrantList() && Objects.equals(grantList(), other.grantList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPolicyGrantsResponse").add("GrantList", hasGrantList() ? grantList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "grantList":
            return Optional.ofNullable(clazz.cast(grantList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyGrantsResponse, T> g) {
        return obj -> g.apply((ListPolicyGrantsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPolicyGrantsResponse> {
        /**
         * <p>
         * The results of this action - the listed grants.
         * </p>
         * 
         * @param grantList
         *        The results of this action - the listed grants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantList(Collection<PolicyGrantMember> grantList);

        /**
         * <p>
         * The results of this action - the listed grants.
         * </p>
         * 
         * @param grantList
         *        The results of this action - the listed grants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantList(PolicyGrantMember... grantList);

        /**
         * <p>
         * The results of this action - the listed grants.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.PolicyGrantMember.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datazone.model.PolicyGrantMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.PolicyGrantMember.Builder#build()} is called
         * immediately and its result is passed to {@link #grantList(List<PolicyGrantMember>)}.
         * 
         * @param grantList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.PolicyGrantMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grantList(java.util.Collection<PolicyGrantMember>)
         */
        Builder grantList(Consumer<PolicyGrantMember.Builder>... grantList);

        /**
         * <p>
         * When the number of grants is greater than the default value for the <code>MaxResults</code> parameter, or if
         * you explicitly specify a value for <code>MaxResults</code> that is less than the number of grants, the
         * response includes a pagination token named <code>NextToken</code>. You can specify this
         * <code>NextToken</code> value in a subsequent call to <code>ListPolicyGrants</code> to list the next set of
         * grants.
         * </p>
         * 
         * @param nextToken
         *        When the number of grants is greater than the default value for the <code>MaxResults</code> parameter,
         *        or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
         *        grants, the response includes a pagination token named <code>NextToken</code>. You can specify this
         *        <code>NextToken</code> value in a subsequent call to <code>ListPolicyGrants</code> to list the next
         *        set of grants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private List<PolicyGrantMember> grantList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyGrantsResponse model) {
            super(model);
            grantList(model.grantList);
            nextToken(model.nextToken);
        }

        public final List<PolicyGrantMember.Builder> getGrantList() {
            List<PolicyGrantMember.Builder> result = PolicyGrantListCopier.copyToBuilder(this.grantList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrantList(Collection<PolicyGrantMember.BuilderImpl> grantList) {
            this.grantList = PolicyGrantListCopier.copyFromBuilder(grantList);
        }

        @Override
        public final Builder grantList(Collection<PolicyGrantMember> grantList) {
            this.grantList = PolicyGrantListCopier.copy(grantList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantList(PolicyGrantMember... grantList) {
            grantList(Arrays.asList(grantList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantList(Consumer<PolicyGrantMember.Builder>... grantList) {
            grantList(Stream.of(grantList).map(c -> PolicyGrantMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPolicyGrantsResponse build() {
            return new ListPolicyGrantsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
