/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLineageNodeHistoryRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListLineageNodeHistoryRequest.Builder, ListLineageNodeHistoryRequest> {
    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("direction").getter(getter(ListLineageNodeHistoryRequest::directionAsString))
            .setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("direction").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListLineageNodeHistoryRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<Instant> EVENT_TIMESTAMP_GTE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("eventTimestampGTE").getter(getter(ListLineageNodeHistoryRequest::eventTimestampGTE))
            .setter(setter(Builder::eventTimestampGTE))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("timestampGTE").build()).build();

    private static final SdkField<Instant> EVENT_TIMESTAMP_LTE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("eventTimestampLTE").getter(getter(ListLineageNodeHistoryRequest::eventTimestampLTE))
            .setter(setter(Builder::eventTimestampLTE))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("timestampLTE").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(ListLineageNodeHistoryRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListLineageNodeHistoryRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListLineageNodeHistoryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListLineageNodeHistoryRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTION_FIELD,
            DOMAIN_IDENTIFIER_FIELD, EVENT_TIMESTAMP_GTE_FIELD, EVENT_TIMESTAMP_LTE_FIELD, IDENTIFIER_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, SORT_ORDER_FIELD));

    private final String direction;

    private final String domainIdentifier;

    private final Instant eventTimestampGTE;

    private final Instant eventTimestampLTE;

    private final String identifier;

    private final Integer maxResults;

    private final String nextToken;

    private final String sortOrder;

    private ListLineageNodeHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.direction = builder.direction;
        this.domainIdentifier = builder.domainIdentifier;
        this.eventTimestampGTE = builder.eventTimestampGTE;
        this.eventTimestampLTE = builder.eventTimestampLTE;
        this.identifier = builder.identifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The direction of the data lineage node refers to the lineage node having neighbors in that direction. For
     * example, if direction is <code>UPSTREAM</code>, the <code>ListLineageNodeHistory</code> API responds with
     * historical versions with upstream neighbors only.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link EdgeDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return The direction of the data lineage node refers to the lineage node having neighbors in that direction. For
     *         example, if direction is <code>UPSTREAM</code>, the <code>ListLineageNodeHistory</code> API responds with
     *         historical versions with upstream neighbors only.
     * @see EdgeDirection
     */
    public final EdgeDirection direction() {
        return EdgeDirection.fromValue(direction);
    }

    /**
     * <p>
     * The direction of the data lineage node refers to the lineage node having neighbors in that direction. For
     * example, if direction is <code>UPSTREAM</code>, the <code>ListLineageNodeHistory</code> API responds with
     * historical versions with upstream neighbors only.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link EdgeDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return The direction of the data lineage node refers to the lineage node having neighbors in that direction. For
     *         example, if direction is <code>UPSTREAM</code>, the <code>ListLineageNodeHistory</code> API responds with
     *         historical versions with upstream neighbors only.
     * @see EdgeDirection
     */
    public final String directionAsString() {
        return direction;
    }

    /**
     * <p>
     * The ID of the domain where you want to list the history of the specified data lineage node.
     * </p>
     * 
     * @return The ID of the domain where you want to list the history of the specified data lineage node.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * Specifies whether the action is to return data lineage node history from the time after the event timestamp.
     * </p>
     * 
     * @return Specifies whether the action is to return data lineage node history from the time after the event
     *         timestamp.
     */
    public final Instant eventTimestampGTE() {
        return eventTimestampGTE;
    }

    /**
     * <p>
     * Specifies whether the action is to return data lineage node history from the time prior of the event timestamp.
     * </p>
     * 
     * @return Specifies whether the action is to return data lineage node history from the time prior of the event
     *         timestamp.
     */
    public final Instant eventTimestampLTE() {
        return eventTimestampLTE;
    }

    /**
     * <p>
     * The ID of the data lineage node whose history you want to list.
     * </p>
     * 
     * @return The ID of the data lineage node whose history you want to list.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The maximum number of history items to return in a single call to ListLineageNodeHistory. When the number of
     * memberships to be listed is greater than the value of MaxResults, the response contains a NextToken value that
     * you can use in a subsequent call to ListLineageNodeHistory to list the next set of items.
     * </p>
     * 
     * @return The maximum number of history items to return in a single call to ListLineageNodeHistory. When the number
     *         of memberships to be listed is greater than the value of MaxResults, the response contains a NextToken
     *         value that you can use in a subsequent call to ListLineageNodeHistory to list the next set of items.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of history items is greater than the default value for the MaxResults parameter, or if you
     * explicitly specify a value for MaxResults that is less than the number of items, the response includes a
     * pagination token named NextToken. You can specify this NextToken value in a subsequent call to
     * ListLineageNodeHistory to list the next set of items.
     * </p>
     * 
     * @return When the number of history items is greater than the default value for the MaxResults parameter, or if
     *         you explicitly specify a value for MaxResults that is less than the number of items, the response
     *         includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call to
     *         ListLineageNodeHistory to list the next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The order by which you want data lineage node history to be sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order by which you want data lineage node history to be sorted.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order by which you want data lineage node history to be sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order by which you want data lineage node history to be sorted.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimestampGTE());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimestampLTE());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLineageNodeHistoryRequest)) {
            return false;
        }
        ListLineageNodeHistoryRequest other = (ListLineageNodeHistoryRequest) obj;
        return Objects.equals(directionAsString(), other.directionAsString())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(eventTimestampGTE(), other.eventTimestampGTE())
                && Objects.equals(eventTimestampLTE(), other.eventTimestampLTE())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLineageNodeHistoryRequest").add("Direction", directionAsString())
                .add("DomainIdentifier", domainIdentifier()).add("EventTimestampGTE", eventTimestampGTE())
                .add("EventTimestampLTE", eventTimestampLTE()).add("Identifier", identifier()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "direction":
            return Optional.ofNullable(clazz.cast(directionAsString()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "eventTimestampGTE":
            return Optional.ofNullable(clazz.cast(eventTimestampGTE()));
        case "eventTimestampLTE":
            return Optional.ofNullable(clazz.cast(eventTimestampLTE()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLineageNodeHistoryRequest, T> g) {
        return obj -> g.apply((ListLineageNodeHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListLineageNodeHistoryRequest> {
        /**
         * <p>
         * The direction of the data lineage node refers to the lineage node having neighbors in that direction. For
         * example, if direction is <code>UPSTREAM</code>, the <code>ListLineageNodeHistory</code> API responds with
         * historical versions with upstream neighbors only.
         * </p>
         * 
         * @param direction
         *        The direction of the data lineage node refers to the lineage node having neighbors in that direction.
         *        For example, if direction is <code>UPSTREAM</code>, the <code>ListLineageNodeHistory</code> API
         *        responds with historical versions with upstream neighbors only.
         * @see EdgeDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdgeDirection
         */
        Builder direction(String direction);

        /**
         * <p>
         * The direction of the data lineage node refers to the lineage node having neighbors in that direction. For
         * example, if direction is <code>UPSTREAM</code>, the <code>ListLineageNodeHistory</code> API responds with
         * historical versions with upstream neighbors only.
         * </p>
         * 
         * @param direction
         *        The direction of the data lineage node refers to the lineage node having neighbors in that direction.
         *        For example, if direction is <code>UPSTREAM</code>, the <code>ListLineageNodeHistory</code> API
         *        responds with historical versions with upstream neighbors only.
         * @see EdgeDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdgeDirection
         */
        Builder direction(EdgeDirection direction);

        /**
         * <p>
         * The ID of the domain where you want to list the history of the specified data lineage node.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain where you want to list the history of the specified data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * Specifies whether the action is to return data lineage node history from the time after the event timestamp.
         * </p>
         * 
         * @param eventTimestampGTE
         *        Specifies whether the action is to return data lineage node history from the time after the event
         *        timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestampGTE(Instant eventTimestampGTE);

        /**
         * <p>
         * Specifies whether the action is to return data lineage node history from the time prior of the event
         * timestamp.
         * </p>
         * 
         * @param eventTimestampLTE
         *        Specifies whether the action is to return data lineage node history from the time prior of the event
         *        timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestampLTE(Instant eventTimestampLTE);

        /**
         * <p>
         * The ID of the data lineage node whose history you want to list.
         * </p>
         * 
         * @param identifier
         *        The ID of the data lineage node whose history you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The maximum number of history items to return in a single call to ListLineageNodeHistory. When the number of
         * memberships to be listed is greater than the value of MaxResults, the response contains a NextToken value
         * that you can use in a subsequent call to ListLineageNodeHistory to list the next set of items.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of history items to return in a single call to ListLineageNodeHistory. When the
         *        number of memberships to be listed is greater than the value of MaxResults, the response contains a
         *        NextToken value that you can use in a subsequent call to ListLineageNodeHistory to list the next set
         *        of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of history items is greater than the default value for the MaxResults parameter, or if you
         * explicitly specify a value for MaxResults that is less than the number of items, the response includes a
         * pagination token named NextToken. You can specify this NextToken value in a subsequent call to
         * ListLineageNodeHistory to list the next set of items.
         * </p>
         * 
         * @param nextToken
         *        When the number of history items is greater than the default value for the MaxResults parameter, or if
         *        you explicitly specify a value for MaxResults that is less than the number of items, the response
         *        includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call
         *        to ListLineageNodeHistory to list the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The order by which you want data lineage node history to be sorted.
         * </p>
         * 
         * @param sortOrder
         *        The order by which you want data lineage node history to be sorted.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order by which you want data lineage node history to be sorted.
         * </p>
         * 
         * @param sortOrder
         *        The order by which you want data lineage node history to be sorted.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String direction;

        private String domainIdentifier;

        private Instant eventTimestampGTE;

        private Instant eventTimestampLTE;

        private String identifier;

        private Integer maxResults;

        private String nextToken;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLineageNodeHistoryRequest model) {
            super(model);
            direction(model.direction);
            domainIdentifier(model.domainIdentifier);
            eventTimestampGTE(model.eventTimestampGTE);
            eventTimestampLTE(model.eventTimestampLTE);
            identifier(model.identifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortOrder(model.sortOrder);
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(EdgeDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Instant getEventTimestampGTE() {
            return eventTimestampGTE;
        }

        public final void setEventTimestampGTE(Instant eventTimestampGTE) {
            this.eventTimestampGTE = eventTimestampGTE;
        }

        @Override
        public final Builder eventTimestampGTE(Instant eventTimestampGTE) {
            this.eventTimestampGTE = eventTimestampGTE;
            return this;
        }

        public final Instant getEventTimestampLTE() {
            return eventTimestampLTE;
        }

        public final void setEventTimestampLTE(Instant eventTimestampLTE) {
            this.eventTimestampLTE = eventTimestampLTE;
        }

        @Override
        public final Builder eventTimestampLTE(Instant eventTimestampLTE) {
            this.eventTimestampLTE = eventTimestampLTE;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLineageNodeHistoryRequest build() {
            return new ListLineageNodeHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
