/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data product listing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProductListing implements SdkPojo, Serializable,
        ToCopyableBuilder<DataProductListing.Builder, DataProductListing> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DataProductListing::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DATA_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataProductId").getter(getter(DataProductListing::dataProductId)).setter(setter(Builder::dataProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProductId").build()).build();

    private static final SdkField<String> DATA_PRODUCT_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataProductRevision").getter(getter(DataProductListing::dataProductRevision))
            .setter(setter(Builder::dataProductRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProductRevision").build())
            .build();

    private static final SdkField<String> FORMS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("forms")
            .getter(getter(DataProductListing::forms)).setter(setter(Builder::forms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forms").build()).build();

    private static final SdkField<List<DetailedGlossaryTerm>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<DetailedGlossaryTerm>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(DataProductListing::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetailedGlossaryTerm> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetailedGlossaryTerm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ListingSummary>> ITEMS_FIELD = SdkField
            .<List<ListingSummary>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(DataProductListing::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListingSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListingSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectId").getter(getter(DataProductListing::owningProjectId))
            .setter(setter(Builder::owningProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DATA_PRODUCT_ID_FIELD, DATA_PRODUCT_REVISION_FIELD, FORMS_FIELD, GLOSSARY_TERMS_FIELD, ITEMS_FIELD,
            OWNING_PROJECT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String dataProductId;

    private final String dataProductRevision;

    private final String forms;

    private final List<DetailedGlossaryTerm> glossaryTerms;

    private final List<ListingSummary> items;

    private final String owningProjectId;

    private DataProductListing(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.dataProductId = builder.dataProductId;
        this.dataProductRevision = builder.dataProductRevision;
        this.forms = builder.forms;
        this.glossaryTerms = builder.glossaryTerms;
        this.items = builder.items;
        this.owningProjectId = builder.owningProjectId;
    }

    /**
     * <p>
     * The timestamp at which the data product listing was created.
     * </p>
     * 
     * @return The timestamp at which the data product listing was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID of the data product listing.
     * </p>
     * 
     * @return The ID of the data product listing.
     */
    public final String dataProductId() {
        return dataProductId;
    }

    /**
     * <p>
     * The revision of the data product listing.
     * </p>
     * 
     * @return The revision of the data product listing.
     */
    public final String dataProductRevision() {
        return dataProductRevision;
    }

    /**
     * <p>
     * The metadata forms of the data product listing.
     * </p>
     * 
     * @return The metadata forms of the data product listing.
     */
    public final String forms() {
        return forms;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The glossary terms of the data product listing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The glossary terms of the data product listing.
     */
    public final List<DetailedGlossaryTerm> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data assets of the data product listing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The data assets of the data product listing.
     */
    public final List<ListingSummary> items() {
        return items;
    }

    /**
     * <p>
     * The ID of the owning project of the data product listing.
     * </p>
     * 
     * @return The ID of the owning project of the data product listing.
     */
    public final String owningProjectId() {
        return owningProjectId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(dataProductId());
        hashCode = 31 * hashCode + Objects.hashCode(dataProductRevision());
        hashCode = 31 * hashCode + Objects.hashCode(forms());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProductListing)) {
            return false;
        }
        DataProductListing other = (DataProductListing) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(dataProductId(), other.dataProductId())
                && Objects.equals(dataProductRevision(), other.dataProductRevision()) && Objects.equals(forms(), other.forms())
                && hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(glossaryTerms(), other.glossaryTerms())
                && hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(owningProjectId(), other.owningProjectId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProductListing").add("CreatedAt", createdAt()).add("DataProductId", dataProductId())
                .add("DataProductRevision", dataProductRevision()).add("Forms", forms())
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null).add("Items", hasItems() ? items() : null)
                .add("OwningProjectId", owningProjectId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "dataProductId":
            return Optional.ofNullable(clazz.cast(dataProductId()));
        case "dataProductRevision":
            return Optional.ofNullable(clazz.cast(dataProductRevision()));
        case "forms":
            return Optional.ofNullable(clazz.cast(forms()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        case "owningProjectId":
            return Optional.ofNullable(clazz.cast(owningProjectId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataProductListing, T> g) {
        return obj -> g.apply((DataProductListing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProductListing> {
        /**
         * <p>
         * The timestamp at which the data product listing was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp at which the data product listing was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ID of the data product listing.
         * </p>
         * 
         * @param dataProductId
         *        The ID of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProductId(String dataProductId);

        /**
         * <p>
         * The revision of the data product listing.
         * </p>
         * 
         * @param dataProductRevision
         *        The revision of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProductRevision(String dataProductRevision);

        /**
         * <p>
         * The metadata forms of the data product listing.
         * </p>
         * 
         * @param forms
         *        The metadata forms of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forms(String forms);

        /**
         * <p>
         * The glossary terms of the data product listing.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms);

        /**
         * <p>
         * The glossary terms of the data product listing.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(DetailedGlossaryTerm... glossaryTerms);

        /**
         * <p>
         * The glossary terms of the data product listing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder#build()} is called
         * immediately and its result is passed to {@link #glossaryTerms(List<DetailedGlossaryTerm>)}.
         * 
         * @param glossaryTerms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glossaryTerms(java.util.Collection<DetailedGlossaryTerm>)
         */
        Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder>... glossaryTerms);

        /**
         * <p>
         * The data assets of the data product listing.
         * </p>
         * 
         * @param items
         *        The data assets of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<ListingSummary> items);

        /**
         * <p>
         * The data assets of the data product listing.
         * </p>
         * 
         * @param items
         *        The data assets of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(ListingSummary... items);

        /**
         * <p>
         * The data assets of the data product listing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.ListingSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.ListingSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.ListingSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #items(List<ListingSummary>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.ListingSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<ListingSummary>)
         */
        Builder items(Consumer<ListingSummary.Builder>... items);

        /**
         * <p>
         * The ID of the owning project of the data product listing.
         * </p>
         * 
         * @param owningProjectId
         *        The ID of the owning project of the data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectId(String owningProjectId);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String dataProductId;

        private String dataProductRevision;

        private String forms;

        private List<DetailedGlossaryTerm> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private List<ListingSummary> items = DefaultSdkAutoConstructList.getInstance();

        private String owningProjectId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProductListing model) {
            createdAt(model.createdAt);
            dataProductId(model.dataProductId);
            dataProductRevision(model.dataProductRevision);
            forms(model.forms);
            glossaryTerms(model.glossaryTerms);
            items(model.items);
            owningProjectId(model.owningProjectId);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDataProductId() {
            return dataProductId;
        }

        public final void setDataProductId(String dataProductId) {
            this.dataProductId = dataProductId;
        }

        @Override
        public final Builder dataProductId(String dataProductId) {
            this.dataProductId = dataProductId;
            return this;
        }

        public final String getDataProductRevision() {
            return dataProductRevision;
        }

        public final void setDataProductRevision(String dataProductRevision) {
            this.dataProductRevision = dataProductRevision;
        }

        @Override
        public final Builder dataProductRevision(String dataProductRevision) {
            this.dataProductRevision = dataProductRevision;
            return this;
        }

        public final String getForms() {
            return forms;
        }

        public final void setForms(String forms) {
            this.forms = forms;
        }

        @Override
        public final Builder forms(String forms) {
            this.forms = forms;
            return this;
        }

        public final List<DetailedGlossaryTerm.Builder> getGlossaryTerms() {
            List<DetailedGlossaryTerm.Builder> result = DetailedGlossaryTermsCopier.copyToBuilder(this.glossaryTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlossaryTerms(Collection<DetailedGlossaryTerm.BuilderImpl> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copyFromBuilder(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(DetailedGlossaryTerm... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder>... glossaryTerms) {
            glossaryTerms(Stream.of(glossaryTerms).map(c -> DetailedGlossaryTerm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ListingSummary.Builder> getItems() {
            List<ListingSummary.Builder> result = ListingSummariesCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ListingSummary.BuilderImpl> items) {
            this.items = ListingSummariesCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<ListingSummary> items) {
            this.items = ListingSummariesCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ListingSummary... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ListingSummary.Builder>... items) {
            items(Stream.of(items).map(c -> ListingSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOwningProjectId() {
            return owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        @Override
        public DataProductListing build() {
            return new DataProductListing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
