/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssetFilterResponse extends DataZoneResponse implements
        ToCopyableBuilder<CreateAssetFilterResponse.Builder, CreateAssetFilterResponse> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(CreateAssetFilterResponse::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<AssetFilterConfiguration> CONFIGURATION_FIELD = SdkField
            .<AssetFilterConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(CreateAssetFilterResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(AssetFilterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CreateAssetFilterResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAssetFilterResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(CreateAssetFilterResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<List<String>> EFFECTIVE_COLUMN_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("effectiveColumnNames")
            .getter(getter(CreateAssetFilterResponse::effectiveColumnNames))
            .setter(setter(Builder::effectiveColumnNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveColumnNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EFFECTIVE_ROW_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("effectiveRowFilter").getter(getter(CreateAssetFilterResponse::effectiveRowFilter))
            .setter(setter(Builder::effectiveRowFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveRowFilter").build())
            .build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(CreateAssetFilterResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateAssetFilterResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAssetFilterResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateAssetFilterResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            CONFIGURATION_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, EFFECTIVE_COLUMN_NAMES_FIELD,
            EFFECTIVE_ROW_FILTER_FIELD, ERROR_MESSAGE_FIELD, ID_FIELD, NAME_FIELD, STATUS_FIELD));

    private final String assetId;

    private final AssetFilterConfiguration configuration;

    private final Instant createdAt;

    private final String description;

    private final String domainId;

    private final List<String> effectiveColumnNames;

    private final String effectiveRowFilter;

    private final String errorMessage;

    private final String id;

    private final String name;

    private final String status;

    private CreateAssetFilterResponse(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.configuration = builder.configuration;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.effectiveColumnNames = builder.effectiveColumnNames;
        this.effectiveRowFilter = builder.effectiveRowFilter;
        this.errorMessage = builder.errorMessage;
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the asset.
     * </p>
     * 
     * @return The ID of the asset.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The configuration of the asset filter.
     * </p>
     * 
     * @return The configuration of the asset filter.
     */
    public final AssetFilterConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The timestamp at which the asset filter was created.
     * </p>
     * 
     * @return The timestamp at which the asset filter was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description of the asset filter.
     * </p>
     * 
     * @return The description of the asset filter.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the domain where the asset filter is created.
     * </p>
     * 
     * @return The ID of the domain where the asset filter is created.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EffectiveColumnNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEffectiveColumnNames() {
        return effectiveColumnNames != null && !(effectiveColumnNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The column names in the asset filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEffectiveColumnNames} method.
     * </p>
     * 
     * @return The column names in the asset filter.
     */
    public final List<String> effectiveColumnNames() {
        return effectiveColumnNames;
    }

    /**
     * <p>
     * The row filter in the asset filter.
     * </p>
     * 
     * @return The row filter in the asset filter.
     */
    public final String effectiveRowFilter() {
        return effectiveRowFilter;
    }

    /**
     * <p>
     * The error message that is displayed if the asset filter is not created successfully.
     * </p>
     * 
     * @return The error message that is displayed if the asset filter is not created successfully.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The ID of the asset filter.
     * </p>
     * 
     * @return The ID of the asset filter.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the asset filter.
     * </p>
     * 
     * @return The name of the asset filter.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the asset filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FilterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the asset filter.
     * @see FilterStatus
     */
    public final FilterStatus status() {
        return FilterStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the asset filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FilterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the asset filter.
     * @see FilterStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEffectiveColumnNames() ? effectiveColumnNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(effectiveRowFilter());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetFilterResponse)) {
            return false;
        }
        CreateAssetFilterResponse other = (CreateAssetFilterResponse) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(domainId(), other.domainId()) && hasEffectiveColumnNames() == other.hasEffectiveColumnNames()
                && Objects.equals(effectiveColumnNames(), other.effectiveColumnNames())
                && Objects.equals(effectiveRowFilter(), other.effectiveRowFilter())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssetFilterResponse").add("AssetId", assetId()).add("Configuration", configuration())
                .add("CreatedAt", createdAt())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("EffectiveColumnNames", hasEffectiveColumnNames() ? effectiveColumnNames() : null)
                .add("EffectiveRowFilter", effectiveRowFilter()).add("ErrorMessage", errorMessage()).add("Id", id())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "effectiveColumnNames":
            return Optional.ofNullable(clazz.cast(effectiveColumnNames()));
        case "effectiveRowFilter":
            return Optional.ofNullable(clazz.cast(effectiveRowFilter()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetFilterResponse, T> g) {
        return obj -> g.apply((CreateAssetFilterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAssetFilterResponse> {
        /**
         * <p>
         * The ID of the asset.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The configuration of the asset filter.
         * </p>
         * 
         * @param configuration
         *        The configuration of the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AssetFilterConfiguration configuration);

        /**
         * <p>
         * The configuration of the asset filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetFilterConfiguration.Builder}
         * avoiding the need to create one manually via {@link AssetFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetFilterConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(AssetFilterConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AssetFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AssetFilterConfiguration)
         */
        default Builder configuration(Consumer<AssetFilterConfiguration.Builder> configuration) {
            return configuration(AssetFilterConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The timestamp at which the asset filter was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp at which the asset filter was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description of the asset filter.
         * </p>
         * 
         * @param description
         *        The description of the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the domain where the asset filter is created.
         * </p>
         * 
         * @param domainId
         *        The ID of the domain where the asset filter is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The column names in the asset filter.
         * </p>
         * 
         * @param effectiveColumnNames
         *        The column names in the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveColumnNames(Collection<String> effectiveColumnNames);

        /**
         * <p>
         * The column names in the asset filter.
         * </p>
         * 
         * @param effectiveColumnNames
         *        The column names in the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveColumnNames(String... effectiveColumnNames);

        /**
         * <p>
         * The row filter in the asset filter.
         * </p>
         * 
         * @param effectiveRowFilter
         *        The row filter in the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveRowFilter(String effectiveRowFilter);

        /**
         * <p>
         * The error message that is displayed if the asset filter is not created successfully.
         * </p>
         * 
         * @param errorMessage
         *        The error message that is displayed if the asset filter is not created successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The ID of the asset filter.
         * </p>
         * 
         * @param id
         *        The ID of the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the asset filter.
         * </p>
         * 
         * @param name
         *        The name of the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the asset filter.
         * </p>
         * 
         * @param status
         *        The status of the asset filter.
         * @see FilterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the asset filter.
         * </p>
         * 
         * @param status
         *        The status of the asset filter.
         * @see FilterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterStatus
         */
        Builder status(FilterStatus status);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String assetId;

        private AssetFilterConfiguration configuration;

        private Instant createdAt;

        private String description;

        private String domainId;

        private List<String> effectiveColumnNames = DefaultSdkAutoConstructList.getInstance();

        private String effectiveRowFilter;

        private String errorMessage;

        private String id;

        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetFilterResponse model) {
            super(model);
            assetId(model.assetId);
            configuration(model.configuration);
            createdAt(model.createdAt);
            description(model.description);
            domainId(model.domainId);
            effectiveColumnNames(model.effectiveColumnNames);
            effectiveRowFilter(model.effectiveRowFilter);
            errorMessage(model.errorMessage);
            id(model.id);
            name(model.name);
            status(model.status);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final AssetFilterConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AssetFilterConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AssetFilterConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Collection<String> getEffectiveColumnNames() {
            if (effectiveColumnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return effectiveColumnNames;
        }

        public final void setEffectiveColumnNames(Collection<String> effectiveColumnNames) {
            this.effectiveColumnNames = ColumnNameListCopier.copy(effectiveColumnNames);
        }

        @Override
        public final Builder effectiveColumnNames(Collection<String> effectiveColumnNames) {
            this.effectiveColumnNames = ColumnNameListCopier.copy(effectiveColumnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveColumnNames(String... effectiveColumnNames) {
            effectiveColumnNames(Arrays.asList(effectiveColumnNames));
            return this;
        }

        public final String getEffectiveRowFilter() {
            return effectiveRowFilter;
        }

        public final void setEffectiveRowFilter(String effectiveRowFilter) {
            this.effectiveRowFilter = effectiveRowFilter;
        }

        @Override
        public final Builder effectiveRowFilter(String effectiveRowFilter) {
            this.effectiveRowFilter = effectiveRowFilter;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FilterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateAssetFilterResponse build() {
            return new CreateAssetFilterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
