/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details of an environment blueprint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentBlueprintConfigurationItem implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentBlueprintConfigurationItem.Builder, EnvironmentBlueprintConfigurationItem> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(EnvironmentBlueprintConfigurationItem::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(EnvironmentBlueprintConfigurationItem::domainId))
            .setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<List<String>> ENABLED_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("enabledRegions")
            .getter(getter(EnvironmentBlueprintConfigurationItem::enabledRegions))
            .setter(setter(Builder::enabledRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentBlueprintId").getter(getter(EnvironmentBlueprintConfigurationItem::environmentBlueprintId))
            .setter(setter(Builder::environmentBlueprintId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentBlueprintId").build())
            .build();

    private static final SdkField<String> MANAGE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("manageAccessRoleArn").getter(getter(EnvironmentBlueprintConfigurationItem::manageAccessRoleArn))
            .setter(setter(Builder::manageAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageAccessRoleArn").build())
            .build();

    private static final SdkField<String> PROVISIONING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provisioningRoleArn").getter(getter(EnvironmentBlueprintConfigurationItem::provisioningRoleArn))
            .setter(setter(Builder::provisioningRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningRoleArn").build())
            .build();

    private static final SdkField<Map<String, Map<String, String>>> REGIONAL_PARAMETERS_FIELD = SdkField
            .<Map<String, Map<String, String>>> builder(MarshallingType.MAP)
            .memberName("regionalParameters")
            .getter(getter(EnvironmentBlueprintConfigurationItem::regionalParameters))
            .setter(setter(Builder::regionalParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(EnvironmentBlueprintConfigurationItem::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DOMAIN_ID_FIELD, ENABLED_REGIONS_FIELD, ENVIRONMENT_BLUEPRINT_ID_FIELD, MANAGE_ACCESS_ROLE_ARN_FIELD,
            PROVISIONING_ROLE_ARN_FIELD, REGIONAL_PARAMETERS_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String domainId;

    private final List<String> enabledRegions;

    private final String environmentBlueprintId;

    private final String manageAccessRoleArn;

    private final String provisioningRoleArn;

    private final Map<String, Map<String, String>> regionalParameters;

    private final Instant updatedAt;

    private EnvironmentBlueprintConfigurationItem(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.domainId = builder.domainId;
        this.enabledRegions = builder.enabledRegions;
        this.environmentBlueprintId = builder.environmentBlueprintId;
        this.manageAccessRoleArn = builder.manageAccessRoleArn;
        this.provisioningRoleArn = builder.provisioningRoleArn;
        this.regionalParameters = builder.regionalParameters;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The timestamp of when an environment blueprint was created.
     * </p>
     * 
     * @return The timestamp of when an environment blueprint was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which an environment blueprint exists.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which an environment blueprint exists.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledRegions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnabledRegions() {
        return enabledRegions != null && !(enabledRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The enabled Amazon Web Services Regions specified in a blueprint configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledRegions} method.
     * </p>
     * 
     * @return The enabled Amazon Web Services Regions specified in a blueprint configuration.
     */
    public final List<String> enabledRegions() {
        return enabledRegions;
    }

    /**
     * <p>
     * The identifier of the environment blueprint.
     * </p>
     * 
     * @return The identifier of the environment blueprint.
     */
    public final String environmentBlueprintId() {
        return environmentBlueprintId;
    }

    /**
     * <p>
     * The ARN of the manage access role specified in the environment blueprint configuration.
     * </p>
     * 
     * @return The ARN of the manage access role specified in the environment blueprint configuration.
     */
    public final String manageAccessRoleArn() {
        return manageAccessRoleArn;
    }

    /**
     * <p>
     * The ARN of the provisioning role specified in the environment blueprint configuration.
     * </p>
     * 
     * @return The ARN of the provisioning role specified in the environment blueprint configuration.
     */
    public final String provisioningRoleArn() {
        return provisioningRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionalParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegionalParameters() {
        return regionalParameters != null && !(regionalParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The regional parameters of the environment blueprint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionalParameters} method.
     * </p>
     * 
     * @return The regional parameters of the environment blueprint.
     */
    public final Map<String, Map<String, String>> regionalParameters() {
        return regionalParameters;
    }

    /**
     * <p>
     * The timestamp of when the environment blueprint was updated.
     * </p>
     * 
     * @return The timestamp of when the environment blueprint was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledRegions() ? enabledRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(environmentBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(manageAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionalParameters() ? regionalParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentBlueprintConfigurationItem)) {
            return false;
        }
        EnvironmentBlueprintConfigurationItem other = (EnvironmentBlueprintConfigurationItem) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(domainId(), other.domainId())
                && hasEnabledRegions() == other.hasEnabledRegions() && Objects.equals(enabledRegions(), other.enabledRegions())
                && Objects.equals(environmentBlueprintId(), other.environmentBlueprintId())
                && Objects.equals(manageAccessRoleArn(), other.manageAccessRoleArn())
                && Objects.equals(provisioningRoleArn(), other.provisioningRoleArn())
                && hasRegionalParameters() == other.hasRegionalParameters()
                && Objects.equals(regionalParameters(), other.regionalParameters())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentBlueprintConfigurationItem").add("CreatedAt", createdAt())
                .add("DomainId", domainId()).add("EnabledRegions", hasEnabledRegions() ? enabledRegions() : null)
                .add("EnvironmentBlueprintId", environmentBlueprintId()).add("ManageAccessRoleArn", manageAccessRoleArn())
                .add("ProvisioningRoleArn", provisioningRoleArn())
                .add("RegionalParameters", hasRegionalParameters() ? regionalParameters() : null).add("UpdatedAt", updatedAt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "enabledRegions":
            return Optional.ofNullable(clazz.cast(enabledRegions()));
        case "environmentBlueprintId":
            return Optional.ofNullable(clazz.cast(environmentBlueprintId()));
        case "manageAccessRoleArn":
            return Optional.ofNullable(clazz.cast(manageAccessRoleArn()));
        case "provisioningRoleArn":
            return Optional.ofNullable(clazz.cast(provisioningRoleArn()));
        case "regionalParameters":
            return Optional.ofNullable(clazz.cast(regionalParameters()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentBlueprintConfigurationItem, T> g) {
        return obj -> g.apply((EnvironmentBlueprintConfigurationItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentBlueprintConfigurationItem> {
        /**
         * <p>
         * The timestamp of when an environment blueprint was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when an environment blueprint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which an environment blueprint exists.
         * </p>
         * 
         * @param domainId
         *        The identifier of the Amazon DataZone domain in which an environment blueprint exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The enabled Amazon Web Services Regions specified in a blueprint configuration.
         * </p>
         * 
         * @param enabledRegions
         *        The enabled Amazon Web Services Regions specified in a blueprint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledRegions(Collection<String> enabledRegions);

        /**
         * <p>
         * The enabled Amazon Web Services Regions specified in a blueprint configuration.
         * </p>
         * 
         * @param enabledRegions
         *        The enabled Amazon Web Services Regions specified in a blueprint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledRegions(String... enabledRegions);

        /**
         * <p>
         * The identifier of the environment blueprint.
         * </p>
         * 
         * @param environmentBlueprintId
         *        The identifier of the environment blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentBlueprintId(String environmentBlueprintId);

        /**
         * <p>
         * The ARN of the manage access role specified in the environment blueprint configuration.
         * </p>
         * 
         * @param manageAccessRoleArn
         *        The ARN of the manage access role specified in the environment blueprint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageAccessRoleArn(String manageAccessRoleArn);

        /**
         * <p>
         * The ARN of the provisioning role specified in the environment blueprint configuration.
         * </p>
         * 
         * @param provisioningRoleArn
         *        The ARN of the provisioning role specified in the environment blueprint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningRoleArn(String provisioningRoleArn);

        /**
         * <p>
         * The regional parameters of the environment blueprint.
         * </p>
         * 
         * @param regionalParameters
         *        The regional parameters of the environment blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionalParameters(Map<String, ? extends Map<String, String>> regionalParameters);

        /**
         * <p>
         * The timestamp of when the environment blueprint was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the environment blueprint was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String domainId;

        private List<String> enabledRegions = DefaultSdkAutoConstructList.getInstance();

        private String environmentBlueprintId;

        private String manageAccessRoleArn;

        private String provisioningRoleArn;

        private Map<String, Map<String, String>> regionalParameters = DefaultSdkAutoConstructMap.getInstance();

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentBlueprintConfigurationItem model) {
            createdAt(model.createdAt);
            domainId(model.domainId);
            enabledRegions(model.enabledRegions);
            environmentBlueprintId(model.environmentBlueprintId);
            manageAccessRoleArn(model.manageAccessRoleArn);
            provisioningRoleArn(model.provisioningRoleArn);
            regionalParameters(model.regionalParameters);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Collection<String> getEnabledRegions() {
            if (enabledRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledRegions;
        }

        public final void setEnabledRegions(Collection<String> enabledRegions) {
            this.enabledRegions = EnabledRegionListCopier.copy(enabledRegions);
        }

        @Override
        public final Builder enabledRegions(Collection<String> enabledRegions) {
            this.enabledRegions = EnabledRegionListCopier.copy(enabledRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledRegions(String... enabledRegions) {
            enabledRegions(Arrays.asList(enabledRegions));
            return this;
        }

        public final String getEnvironmentBlueprintId() {
            return environmentBlueprintId;
        }

        public final void setEnvironmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
        }

        @Override
        public final Builder environmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
            return this;
        }

        public final String getManageAccessRoleArn() {
            return manageAccessRoleArn;
        }

        public final void setManageAccessRoleArn(String manageAccessRoleArn) {
            this.manageAccessRoleArn = manageAccessRoleArn;
        }

        @Override
        public final Builder manageAccessRoleArn(String manageAccessRoleArn) {
            this.manageAccessRoleArn = manageAccessRoleArn;
            return this;
        }

        public final String getProvisioningRoleArn() {
            return provisioningRoleArn;
        }

        public final void setProvisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
        }

        @Override
        public final Builder provisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getRegionalParameters() {
            if (regionalParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return regionalParameters;
        }

        public final void setRegionalParameters(Map<String, ? extends Map<String, String>> regionalParameters) {
            this.regionalParameters = RegionalParameterMapCopier.copy(regionalParameters);
        }

        @Override
        public final Builder regionalParameters(Map<String, ? extends Map<String, String>> regionalParameters) {
            this.regionalParameters = RegionalParameterMapCopier.copy(regionalParameters);
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public EnvironmentBlueprintConfigurationItem build() {
            return new EnvironmentBlueprintConfigurationItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
