/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of user parameters of an environment blueprint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomParameter implements SdkPojo, Serializable, ToCopyableBuilder<CustomParameter.Builder, CustomParameter> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultValue").getter(getter(CustomParameter::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CustomParameter::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FIELD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldType").getter(getter(CustomParameter::fieldType)).setter(setter(Builder::fieldType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldType").build()).build();

    private static final SdkField<Boolean> IS_EDITABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isEditable").getter(getter(CustomParameter::isEditable)).setter(setter(Builder::isEditable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isEditable").build()).build();

    private static final SdkField<Boolean> IS_OPTIONAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isOptional").getter(getter(CustomParameter::isOptional)).setter(setter(Builder::isOptional))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isOptional").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyName").getter(getter(CustomParameter::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD,
            DESCRIPTION_FIELD, FIELD_TYPE_FIELD, IS_EDITABLE_FIELD, IS_OPTIONAL_FIELD, KEY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultValue;

    private final String description;

    private final String fieldType;

    private final Boolean isEditable;

    private final Boolean isOptional;

    private final String keyName;

    private CustomParameter(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
        this.fieldType = builder.fieldType;
        this.isEditable = builder.isEditable;
        this.isOptional = builder.isOptional;
        this.keyName = builder.keyName;
    }

    /**
     * <p>
     * The default value of the parameter.
     * </p>
     * 
     * @return The default value of the parameter.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The description of the parameter.
     * </p>
     * 
     * @return The description of the parameter.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The filed type of the parameter.
     * </p>
     * 
     * @return The filed type of the parameter.
     */
    public final String fieldType() {
        return fieldType;
    }

    /**
     * <p>
     * Specifies whether the parameter is editable.
     * </p>
     * 
     * @return Specifies whether the parameter is editable.
     */
    public final Boolean isEditable() {
        return isEditable;
    }

    /**
     * <p>
     * Specifies whether the custom parameter is optional.
     * </p>
     * 
     * @return Specifies whether the custom parameter is optional.
     */
    public final Boolean isOptional() {
        return isOptional;
    }

    /**
     * <p>
     * The key name of the parameter.
     * </p>
     * 
     * @return The key name of the parameter.
     */
    public final String keyName() {
        return keyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(fieldType());
        hashCode = 31 * hashCode + Objects.hashCode(isEditable());
        hashCode = 31 * hashCode + Objects.hashCode(isOptional());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomParameter)) {
            return false;
        }
        CustomParameter other = (CustomParameter) obj;
        return Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(description(), other.description())
                && Objects.equals(fieldType(), other.fieldType()) && Objects.equals(isEditable(), other.isEditable())
                && Objects.equals(isOptional(), other.isOptional()) && Objects.equals(keyName(), other.keyName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomParameter").add("DefaultValue", defaultValue())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FieldType", fieldType()).add("IsEditable", isEditable()).add("IsOptional", isOptional())
                .add("KeyName", keyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "fieldType":
            return Optional.ofNullable(clazz.cast(fieldType()));
        case "isEditable":
            return Optional.ofNullable(clazz.cast(isEditable()));
        case "isOptional":
            return Optional.ofNullable(clazz.cast(isOptional()));
        case "keyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomParameter, T> g) {
        return obj -> g.apply((CustomParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomParameter> {
        /**
         * <p>
         * The default value of the parameter.
         * </p>
         * 
         * @param defaultValue
         *        The default value of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The description of the parameter.
         * </p>
         * 
         * @param description
         *        The description of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The filed type of the parameter.
         * </p>
         * 
         * @param fieldType
         *        The filed type of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldType(String fieldType);

        /**
         * <p>
         * Specifies whether the parameter is editable.
         * </p>
         * 
         * @param isEditable
         *        Specifies whether the parameter is editable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEditable(Boolean isEditable);

        /**
         * <p>
         * Specifies whether the custom parameter is optional.
         * </p>
         * 
         * @param isOptional
         *        Specifies whether the custom parameter is optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isOptional(Boolean isOptional);

        /**
         * <p>
         * The key name of the parameter.
         * </p>
         * 
         * @param keyName
         *        The key name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);
    }

    static final class BuilderImpl implements Builder {
        private String defaultValue;

        private String description;

        private String fieldType;

        private Boolean isEditable;

        private Boolean isOptional;

        private String keyName;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomParameter model) {
            defaultValue(model.defaultValue);
            description(model.description);
            fieldType(model.fieldType);
            isEditable(model.isEditable);
            isOptional(model.isOptional);
            keyName(model.keyName);
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFieldType() {
            return fieldType;
        }

        public final void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        public final Builder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public final Boolean getIsEditable() {
            return isEditable;
        }

        public final void setIsEditable(Boolean isEditable) {
            this.isEditable = isEditable;
        }

        @Override
        public final Builder isEditable(Boolean isEditable) {
            this.isEditable = isEditable;
            return this;
        }

        public final Boolean getIsOptional() {
            return isOptional;
        }

        public final void setIsOptional(Boolean isOptional) {
            this.isOptional = isOptional;
        }

        @Override
        public final Builder isOptional(Boolean isOptional) {
            this.isOptional = isOptional;
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        @Override
        public CustomParameter build() {
            return new CustomParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
