/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the credentials required to access an Amazon Redshift cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftCredentialConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftCredentialConfiguration.Builder, RedshiftCredentialConfiguration> {
    private static final SdkField<String> SECRET_MANAGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretManagerArn").getter(getter(RedshiftCredentialConfiguration::secretManagerArn))
            .setter(setter(Builder::secretManagerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretManagerArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_MANAGER_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String secretManagerArn;

    private RedshiftCredentialConfiguration(BuilderImpl builder) {
        this.secretManagerArn = builder.secretManagerArn;
    }

    /**
     * <p>
     * The ARN of a secret manager for an Amazon Redshift cluster.
     * </p>
     * 
     * @return The ARN of a secret manager for an Amazon Redshift cluster.
     */
    public final String secretManagerArn() {
        return secretManagerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretManagerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftCredentialConfiguration)) {
            return false;
        }
        RedshiftCredentialConfiguration other = (RedshiftCredentialConfiguration) obj;
        return Objects.equals(secretManagerArn(), other.secretManagerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftCredentialConfiguration").add("SecretManagerArn", secretManagerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "secretManagerArn":
            return Optional.ofNullable(clazz.cast(secretManagerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftCredentialConfiguration, T> g) {
        return obj -> g.apply((RedshiftCredentialConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftCredentialConfiguration> {
        /**
         * <p>
         * The ARN of a secret manager for an Amazon Redshift cluster.
         * </p>
         * 
         * @param secretManagerArn
         *        The ARN of a secret manager for an Amazon Redshift cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretManagerArn(String secretManagerArn);
    }

    static final class BuilderImpl implements Builder {
        private String secretManagerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftCredentialConfiguration model) {
            secretManagerArn(model.secretManagerArn);
        }

        public final String getSecretManagerArn() {
            return secretManagerArn;
        }

        public final void setSecretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
        }

        @Override
        public final Builder secretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
            return this;
        }

        @Override
        public RedshiftCredentialConfiguration build() {
            return new RedshiftCredentialConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
