/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionTargetsResponse;
import software.amazon.awssdk.services.datazone.model.SubscriptionTargetSummary;

public class ListSubscriptionTargetsIterable
implements SdkIterable<ListSubscriptionTargetsResponse> {
    private final DataZoneClient client;
    private final ListSubscriptionTargetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubscriptionTargetsIterable(DataZoneClient client, ListSubscriptionTargetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSubscriptionTargetsResponseFetcher();
    }

    public Iterator<ListSubscriptionTargetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SubscriptionTargetSummary> items() {
        Function<ListSubscriptionTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSubscriptionTargetsResponseFetcher
    implements SyncPageFetcher<ListSubscriptionTargetsResponse> {
        private ListSubscriptionTargetsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscriptionTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSubscriptionTargetsResponse nextPage(ListSubscriptionTargetsResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionTargetsIterable.this.client.listSubscriptionTargets(ListSubscriptionTargetsIterable.this.firstRequest);
            }
            return ListSubscriptionTargetsIterable.this.client.listSubscriptionTargets((ListSubscriptionTargetsRequest)((Object)ListSubscriptionTargetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

