/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The principal that has the subscription grant for the asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscribedPrincipal implements SdkPojo, Serializable,
        ToCopyableBuilder<SubscribedPrincipal.Builder, SubscribedPrincipal> {
    private static final SdkField<SubscribedProject> PROJECT_FIELD = SdkField
            .<SubscribedProject> builder(MarshallingType.SDK_POJO).memberName("project")
            .getter(getter(SubscribedPrincipal::project)).setter(setter(Builder::project))
            .constructor(SubscribedProject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_FIELD));

    private static final long serialVersionUID = 1L;

    private final SubscribedProject project;

    private final Type type;

    private SubscribedPrincipal(BuilderImpl builder) {
        this.project = builder.project;
        this.type = builder.type;
    }

    /**
     * <p>
     * The project that has the subscription grant.
     * </p>
     * 
     * @return The project that has the subscription grant.
     */
    public final SubscribedProject project() {
        return project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(project());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedPrincipal)) {
            return false;
        }
        SubscribedPrincipal other = (SubscribedPrincipal) obj;
        return Objects.equals(project(), other.project());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubscribedPrincipal").add("Project", project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #project()} initialized to the given value.
     *
     * <p>
     * The project that has the subscription grant.
     * </p>
     * 
     * @param project
     *        The project that has the subscription grant.
     */
    public static SubscribedPrincipal fromProject(SubscribedProject project) {
        return builder().project(project).build();
    }

    /**
     * Create an instance of this class with {@link #project()} initialized to the given value.
     *
     * <p>
     * The project that has the subscription grant.
     * </p>
     * 
     * @param project
     *        The project that has the subscription grant.
     */
    public static SubscribedPrincipal fromProject(Consumer<SubscribedProject.Builder> project) {
        SubscribedProject.Builder builder = SubscribedProject.builder();
        project.accept(builder);
        return fromProject(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscribedPrincipal, T> g) {
        return obj -> g.apply((SubscribedPrincipal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscribedPrincipal> {
        /**
         * <p>
         * The project that has the subscription grant.
         * </p>
         * 
         * @param project
         *        The project that has the subscription grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(SubscribedProject project);

        /**
         * <p>
         * The project that has the subscription grant.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscribedProject.Builder} avoiding the
         * need to create one manually via {@link SubscribedProject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscribedProject.Builder#build()} is called immediately and its
         * result is passed to {@link #project(SubscribedProject)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link SubscribedProject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(SubscribedProject)
         */
        default Builder project(Consumer<SubscribedProject.Builder> project) {
            return project(SubscribedProject.builder().applyMutation(project).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SubscribedProject project;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedPrincipal model) {
            project(model.project);
        }

        public final SubscribedProject.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        public final void setProject(SubscribedProject.BuilderImpl project) {
            Object oldValue = this.project;
            this.project = project != null ? project.build() : null;
            handleUnionValueChange(Type.PROJECT, oldValue, this.project);
        }

        @Override
        public final Builder project(SubscribedProject project) {
            Object oldValue = this.project;
            this.project = project;
            handleUnionValueChange(Type.PROJECT, oldValue, this.project);
            return this;
        }

        @Override
        public SubscribedPrincipal build() {
            return new SubscribedPrincipal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SubscribedPrincipal#type()
     */
    public enum Type {
        PROJECT,

        UNKNOWN_TO_SDK_VERSION
    }
}
