/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the asset for which the subscription grant is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscribedAsset implements SdkPojo, Serializable, ToCopyableBuilder<SubscribedAsset.Builder, SubscribedAsset> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(SubscribedAsset::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> ASSET_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetRevision").getter(getter(SubscribedAsset::assetRevision)).setter(setter(Builder::assetRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetRevision").build()).build();

    private static final SdkField<FailureCause> FAILURE_CAUSE_FIELD = SdkField.<FailureCause> builder(MarshallingType.SDK_POJO)
            .memberName("failureCause").getter(getter(SubscribedAsset::failureCause)).setter(setter(Builder::failureCause))
            .constructor(FailureCause::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCause").build()).build();

    private static final SdkField<Instant> FAILURE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("failureTimestamp").getter(getter(SubscribedAsset::failureTimestamp))
            .setter(setter(Builder::failureTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureTimestamp").build()).build();

    private static final SdkField<Instant> GRANTED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("grantedTimestamp").getter(getter(SubscribedAsset::grantedTimestamp))
            .setter(setter(Builder::grantedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantedTimestamp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SubscribedAsset::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetName").getter(getter(SubscribedAsset::targetName)).setter(setter(Builder::targetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            ASSET_REVISION_FIELD, FAILURE_CAUSE_FIELD, FAILURE_TIMESTAMP_FIELD, GRANTED_TIMESTAMP_FIELD, STATUS_FIELD,
            TARGET_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String assetId;

    private final String assetRevision;

    private final FailureCause failureCause;

    private final Instant failureTimestamp;

    private final Instant grantedTimestamp;

    private final String status;

    private final String targetName;

    private SubscribedAsset(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.assetRevision = builder.assetRevision;
        this.failureCause = builder.failureCause;
        this.failureTimestamp = builder.failureTimestamp;
        this.grantedTimestamp = builder.grantedTimestamp;
        this.status = builder.status;
        this.targetName = builder.targetName;
    }

    /**
     * <p>
     * The identifier of the asset for which the subscription grant is created.
     * </p>
     * 
     * @return The identifier of the asset for which the subscription grant is created.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The revision of the asset for which the subscription grant is created.
     * </p>
     * 
     * @return The revision of the asset for which the subscription grant is created.
     */
    public final String assetRevision() {
        return assetRevision;
    }

    /**
     * <p>
     * The failure cause included in the details of the asset for which the subscription grant is created.
     * </p>
     * 
     * @return The failure cause included in the details of the asset for which the subscription grant is created.
     */
    public final FailureCause failureCause() {
        return failureCause;
    }

    /**
     * <p>
     * The failure timestamp included in the details of the asset for which the subscription grant is created.
     * </p>
     * 
     * @return The failure timestamp included in the details of the asset for which the subscription grant is created.
     */
    public final Instant failureTimestamp() {
        return failureTimestamp;
    }

    /**
     * <p>
     * The timestamp of when the subscription grant to the asset is created.
     * </p>
     * 
     * @return The timestamp of when the subscription grant to the asset is created.
     */
    public final Instant grantedTimestamp() {
        return grantedTimestamp;
    }

    /**
     * <p>
     * The status of the asset for which the subscription grant is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SubscriptionGrantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the asset for which the subscription grant is created.
     * @see SubscriptionGrantStatus
     */
    public final SubscriptionGrantStatus status() {
        return SubscriptionGrantStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the asset for which the subscription grant is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SubscriptionGrantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the asset for which the subscription grant is created.
     * @see SubscriptionGrantStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The target name of the asset for which the subscription grant is created.
     * </p>
     * 
     * @return The target name of the asset for which the subscription grant is created.
     */
    public final String targetName() {
        return targetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(assetRevision());
        hashCode = 31 * hashCode + Objects.hashCode(failureCause());
        hashCode = 31 * hashCode + Objects.hashCode(failureTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(grantedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedAsset)) {
            return false;
        }
        SubscribedAsset other = (SubscribedAsset) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(assetRevision(), other.assetRevision())
                && Objects.equals(failureCause(), other.failureCause())
                && Objects.equals(failureTimestamp(), other.failureTimestamp())
                && Objects.equals(grantedTimestamp(), other.grantedTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(targetName(), other.targetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubscribedAsset").add("AssetId", assetId()).add("AssetRevision", assetRevision())
                .add("FailureCause", failureCause()).add("FailureTimestamp", failureTimestamp())
                .add("GrantedTimestamp", grantedTimestamp()).add("Status", statusAsString()).add("TargetName", targetName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "assetRevision":
            return Optional.ofNullable(clazz.cast(assetRevision()));
        case "failureCause":
            return Optional.ofNullable(clazz.cast(failureCause()));
        case "failureTimestamp":
            return Optional.ofNullable(clazz.cast(failureTimestamp()));
        case "grantedTimestamp":
            return Optional.ofNullable(clazz.cast(grantedTimestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "targetName":
            return Optional.ofNullable(clazz.cast(targetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscribedAsset, T> g) {
        return obj -> g.apply((SubscribedAsset) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscribedAsset> {
        /**
         * <p>
         * The identifier of the asset for which the subscription grant is created.
         * </p>
         * 
         * @param assetId
         *        The identifier of the asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The revision of the asset for which the subscription grant is created.
         * </p>
         * 
         * @param assetRevision
         *        The revision of the asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetRevision(String assetRevision);

        /**
         * <p>
         * The failure cause included in the details of the asset for which the subscription grant is created.
         * </p>
         * 
         * @param failureCause
         *        The failure cause included in the details of the asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCause(FailureCause failureCause);

        /**
         * <p>
         * The failure cause included in the details of the asset for which the subscription grant is created.
         * </p>
         * This is a convenience method that creates an instance of the {@link FailureCause.Builder} avoiding the need
         * to create one manually via {@link FailureCause#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailureCause.Builder#build()} is called immediately and its
         * result is passed to {@link #failureCause(FailureCause)}.
         * 
         * @param failureCause
         *        a consumer that will call methods on {@link FailureCause.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureCause(FailureCause)
         */
        default Builder failureCause(Consumer<FailureCause.Builder> failureCause) {
            return failureCause(FailureCause.builder().applyMutation(failureCause).build());
        }

        /**
         * <p>
         * The failure timestamp included in the details of the asset for which the subscription grant is created.
         * </p>
         * 
         * @param failureTimestamp
         *        The failure timestamp included in the details of the asset for which the subscription grant is
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureTimestamp(Instant failureTimestamp);

        /**
         * <p>
         * The timestamp of when the subscription grant to the asset is created.
         * </p>
         * 
         * @param grantedTimestamp
         *        The timestamp of when the subscription grant to the asset is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantedTimestamp(Instant grantedTimestamp);

        /**
         * <p>
         * The status of the asset for which the subscription grant is created.
         * </p>
         * 
         * @param status
         *        The status of the asset for which the subscription grant is created.
         * @see SubscriptionGrantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionGrantStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the asset for which the subscription grant is created.
         * </p>
         * 
         * @param status
         *        The status of the asset for which the subscription grant is created.
         * @see SubscriptionGrantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionGrantStatus
         */
        Builder status(SubscriptionGrantStatus status);

        /**
         * <p>
         * The target name of the asset for which the subscription grant is created.
         * </p>
         * 
         * @param targetName
         *        The target name of the asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetName(String targetName);
    }

    static final class BuilderImpl implements Builder {
        private String assetId;

        private String assetRevision;

        private FailureCause failureCause;

        private Instant failureTimestamp;

        private Instant grantedTimestamp;

        private String status;

        private String targetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedAsset model) {
            assetId(model.assetId);
            assetRevision(model.assetRevision);
            failureCause(model.failureCause);
            failureTimestamp(model.failureTimestamp);
            grantedTimestamp(model.grantedTimestamp);
            status(model.status);
            targetName(model.targetName);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetRevision() {
            return assetRevision;
        }

        public final void setAssetRevision(String assetRevision) {
            this.assetRevision = assetRevision;
        }

        @Override
        public final Builder assetRevision(String assetRevision) {
            this.assetRevision = assetRevision;
            return this;
        }

        public final FailureCause.Builder getFailureCause() {
            return failureCause != null ? failureCause.toBuilder() : null;
        }

        public final void setFailureCause(FailureCause.BuilderImpl failureCause) {
            this.failureCause = failureCause != null ? failureCause.build() : null;
        }

        @Override
        public final Builder failureCause(FailureCause failureCause) {
            this.failureCause = failureCause;
            return this;
        }

        public final Instant getFailureTimestamp() {
            return failureTimestamp;
        }

        public final void setFailureTimestamp(Instant failureTimestamp) {
            this.failureTimestamp = failureTimestamp;
        }

        @Override
        public final Builder failureTimestamp(Instant failureTimestamp) {
            this.failureTimestamp = failureTimestamp;
            return this;
        }

        public final Instant getGrantedTimestamp() {
            return grantedTimestamp;
        }

        public final void setGrantedTimestamp(Instant grantedTimestamp) {
            this.grantedTimestamp = grantedTimestamp;
        }

        @Override
        public final Builder grantedTimestamp(Instant grantedTimestamp) {
            this.grantedTimestamp = grantedTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriptionGrantStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetName() {
            return targetName;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        @Override
        public SubscribedAsset build() {
            return new SubscribedAsset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
