/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the form entry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FormEntryInput implements SdkPojo, Serializable, ToCopyableBuilder<FormEntryInput.Builder, FormEntryInput> {
    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("required").getter(getter(FormEntryInput::required)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()).build();

    private static final SdkField<String> TYPE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeIdentifier").getter(getter(FormEntryInput::typeIdentifier)).setter(setter(Builder::typeIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeIdentifier").build()).build();

    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeRevision").getter(getter(FormEntryInput::typeRevision)).setter(setter(Builder::typeRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUIRED_FIELD,
            TYPE_IDENTIFIER_FIELD, TYPE_REVISION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean required;

    private final String typeIdentifier;

    private final String typeRevision;

    private FormEntryInput(BuilderImpl builder) {
        this.required = builder.required;
        this.typeIdentifier = builder.typeIdentifier;
        this.typeRevision = builder.typeRevision;
    }

    /**
     * <p>
     * Specifies whether a form entry is required.
     * </p>
     * 
     * @return Specifies whether a form entry is required.
     */
    public final Boolean required() {
        return required;
    }

    /**
     * <p>
     * The type ID of the form entry.
     * </p>
     * 
     * @return The type ID of the form entry.
     */
    public final String typeIdentifier() {
        return typeIdentifier;
    }

    /**
     * <p>
     * The type revision of the form entry.
     * </p>
     * 
     * @return The type revision of the form entry.
     */
    public final String typeRevision() {
        return typeRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(required());
        hashCode = 31 * hashCode + Objects.hashCode(typeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(typeRevision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormEntryInput)) {
            return false;
        }
        FormEntryInput other = (FormEntryInput) obj;
        return Objects.equals(required(), other.required()) && Objects.equals(typeIdentifier(), other.typeIdentifier())
                && Objects.equals(typeRevision(), other.typeRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FormEntryInput").add("Required", required()).add("TypeIdentifier", typeIdentifier())
                .add("TypeRevision", typeRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "required":
            return Optional.ofNullable(clazz.cast(required()));
        case "typeIdentifier":
            return Optional.ofNullable(clazz.cast(typeIdentifier()));
        case "typeRevision":
            return Optional.ofNullable(clazz.cast(typeRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FormEntryInput, T> g) {
        return obj -> g.apply((FormEntryInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FormEntryInput> {
        /**
         * <p>
         * Specifies whether a form entry is required.
         * </p>
         * 
         * @param required
         *        Specifies whether a form entry is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Boolean required);

        /**
         * <p>
         * The type ID of the form entry.
         * </p>
         * 
         * @param typeIdentifier
         *        The type ID of the form entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeIdentifier(String typeIdentifier);

        /**
         * <p>
         * The type revision of the form entry.
         * </p>
         * 
         * @param typeRevision
         *        The type revision of the form entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeRevision(String typeRevision);
    }

    static final class BuilderImpl implements Builder {
        private Boolean required;

        private String typeIdentifier;

        private String typeRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(FormEntryInput model) {
            required(model.required);
            typeIdentifier(model.typeIdentifier);
            typeRevision(model.typeRevision);
        }

        public final Boolean getRequired() {
            return required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final String getTypeIdentifier() {
            return typeIdentifier;
        }

        public final void setTypeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        @Override
        public final Builder typeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            return this;
        }

        public final String getTypeRevision() {
            return typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        @Override
        public FormEntryInput build() {
            return new FormEntryInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
