/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the search results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchInventoryResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchInventoryResultItem.Builder, SearchInventoryResultItem> {
    private static final SdkField<AssetItem> ASSET_ITEM_FIELD = SdkField.<AssetItem> builder(MarshallingType.SDK_POJO)
            .memberName("assetItem").getter(getter(SearchInventoryResultItem::assetItem)).setter(setter(Builder::assetItem))
            .constructor(AssetItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetItem").build()).build();

    private static final SdkField<DataProductSummary> DATA_PRODUCT_ITEM_FIELD = SdkField
            .<DataProductSummary> builder(MarshallingType.SDK_POJO).memberName("dataProductItem")
            .getter(getter(SearchInventoryResultItem::dataProductItem)).setter(setter(Builder::dataProductItem))
            .constructor(DataProductSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProductItem").build()).build();

    private static final SdkField<GlossaryItem> GLOSSARY_ITEM_FIELD = SdkField.<GlossaryItem> builder(MarshallingType.SDK_POJO)
            .memberName("glossaryItem").getter(getter(SearchInventoryResultItem::glossaryItem))
            .setter(setter(Builder::glossaryItem)).constructor(GlossaryItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryItem").build()).build();

    private static final SdkField<GlossaryTermItem> GLOSSARY_TERM_ITEM_FIELD = SdkField
            .<GlossaryTermItem> builder(MarshallingType.SDK_POJO).memberName("glossaryTermItem")
            .getter(getter(SearchInventoryResultItem::glossaryTermItem)).setter(setter(Builder::glossaryTermItem))
            .constructor(GlossaryTermItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTermItem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ITEM_FIELD,
            DATA_PRODUCT_ITEM_FIELD, GLOSSARY_ITEM_FIELD, GLOSSARY_TERM_ITEM_FIELD));

    private static final long serialVersionUID = 1L;

    private final AssetItem assetItem;

    private final DataProductSummary dataProductItem;

    private final GlossaryItem glossaryItem;

    private final GlossaryTermItem glossaryTermItem;

    private final Type type;

    private SearchInventoryResultItem(BuilderImpl builder) {
        this.assetItem = builder.assetItem;
        this.dataProductItem = builder.dataProductItem;
        this.glossaryItem = builder.glossaryItem;
        this.glossaryTermItem = builder.glossaryTermItem;
        this.type = builder.type;
    }

    /**
     * <p>
     * The asset item included in the search results.
     * </p>
     * 
     * @return The asset item included in the search results.
     */
    public final AssetItem assetItem() {
        return assetItem;
    }

    /**
     * <p>
     * The data product item included in the search results.
     * </p>
     * 
     * @return The data product item included in the search results.
     */
    public final DataProductSummary dataProductItem() {
        return dataProductItem;
    }

    /**
     * <p>
     * The glossary item included in the search results.
     * </p>
     * 
     * @return The glossary item included in the search results.
     */
    public final GlossaryItem glossaryItem() {
        return glossaryItem;
    }

    /**
     * <p>
     * The glossary term item included in the search results.
     * </p>
     * 
     * @return The glossary term item included in the search results.
     */
    public final GlossaryTermItem glossaryTermItem() {
        return glossaryTermItem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetItem());
        hashCode = 31 * hashCode + Objects.hashCode(dataProductItem());
        hashCode = 31 * hashCode + Objects.hashCode(glossaryItem());
        hashCode = 31 * hashCode + Objects.hashCode(glossaryTermItem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchInventoryResultItem)) {
            return false;
        }
        SearchInventoryResultItem other = (SearchInventoryResultItem) obj;
        return Objects.equals(assetItem(), other.assetItem()) && Objects.equals(dataProductItem(), other.dataProductItem())
                && Objects.equals(glossaryItem(), other.glossaryItem())
                && Objects.equals(glossaryTermItem(), other.glossaryTermItem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchInventoryResultItem").add("AssetItem", assetItem())
                .add("DataProductItem", dataProductItem()).add("GlossaryItem", glossaryItem())
                .add("GlossaryTermItem", glossaryTermItem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetItem":
            return Optional.ofNullable(clazz.cast(assetItem()));
        case "dataProductItem":
            return Optional.ofNullable(clazz.cast(dataProductItem()));
        case "glossaryItem":
            return Optional.ofNullable(clazz.cast(glossaryItem()));
        case "glossaryTermItem":
            return Optional.ofNullable(clazz.cast(glossaryTermItem()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #assetItem()} initialized to the given value.
     *
     * <p>
     * The asset item included in the search results.
     * </p>
     * 
     * @param assetItem
     *        The asset item included in the search results.
     */
    public static SearchInventoryResultItem fromAssetItem(AssetItem assetItem) {
        return builder().assetItem(assetItem).build();
    }

    /**
     * Create an instance of this class with {@link #assetItem()} initialized to the given value.
     *
     * <p>
     * The asset item included in the search results.
     * </p>
     * 
     * @param assetItem
     *        The asset item included in the search results.
     */
    public static SearchInventoryResultItem fromAssetItem(Consumer<AssetItem.Builder> assetItem) {
        AssetItem.Builder builder = AssetItem.builder();
        assetItem.accept(builder);
        return fromAssetItem(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dataProductItem()} initialized to the given value.
     *
     * <p>
     * The data product item included in the search results.
     * </p>
     * 
     * @param dataProductItem
     *        The data product item included in the search results.
     */
    public static SearchInventoryResultItem fromDataProductItem(DataProductSummary dataProductItem) {
        return builder().dataProductItem(dataProductItem).build();
    }

    /**
     * Create an instance of this class with {@link #dataProductItem()} initialized to the given value.
     *
     * <p>
     * The data product item included in the search results.
     * </p>
     * 
     * @param dataProductItem
     *        The data product item included in the search results.
     */
    public static SearchInventoryResultItem fromDataProductItem(Consumer<DataProductSummary.Builder> dataProductItem) {
        DataProductSummary.Builder builder = DataProductSummary.builder();
        dataProductItem.accept(builder);
        return fromDataProductItem(builder.build());
    }

    /**
     * Create an instance of this class with {@link #glossaryItem()} initialized to the given value.
     *
     * <p>
     * The glossary item included in the search results.
     * </p>
     * 
     * @param glossaryItem
     *        The glossary item included in the search results.
     */
    public static SearchInventoryResultItem fromGlossaryItem(GlossaryItem glossaryItem) {
        return builder().glossaryItem(glossaryItem).build();
    }

    /**
     * Create an instance of this class with {@link #glossaryItem()} initialized to the given value.
     *
     * <p>
     * The glossary item included in the search results.
     * </p>
     * 
     * @param glossaryItem
     *        The glossary item included in the search results.
     */
    public static SearchInventoryResultItem fromGlossaryItem(Consumer<GlossaryItem.Builder> glossaryItem) {
        GlossaryItem.Builder builder = GlossaryItem.builder();
        glossaryItem.accept(builder);
        return fromGlossaryItem(builder.build());
    }

    /**
     * Create an instance of this class with {@link #glossaryTermItem()} initialized to the given value.
     *
     * <p>
     * The glossary term item included in the search results.
     * </p>
     * 
     * @param glossaryTermItem
     *        The glossary term item included in the search results.
     */
    public static SearchInventoryResultItem fromGlossaryTermItem(GlossaryTermItem glossaryTermItem) {
        return builder().glossaryTermItem(glossaryTermItem).build();
    }

    /**
     * Create an instance of this class with {@link #glossaryTermItem()} initialized to the given value.
     *
     * <p>
     * The glossary term item included in the search results.
     * </p>
     * 
     * @param glossaryTermItem
     *        The glossary term item included in the search results.
     */
    public static SearchInventoryResultItem fromGlossaryTermItem(Consumer<GlossaryTermItem.Builder> glossaryTermItem) {
        GlossaryTermItem.Builder builder = GlossaryTermItem.builder();
        glossaryTermItem.accept(builder);
        return fromGlossaryTermItem(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchInventoryResultItem, T> g) {
        return obj -> g.apply((SearchInventoryResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchInventoryResultItem> {
        /**
         * <p>
         * The asset item included in the search results.
         * </p>
         * 
         * @param assetItem
         *        The asset item included in the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetItem(AssetItem assetItem);

        /**
         * <p>
         * The asset item included in the search results.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetItem.Builder} avoiding the need to
         * create one manually via {@link AssetItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetItem.Builder#build()} is called immediately and its result
         * is passed to {@link #assetItem(AssetItem)}.
         * 
         * @param assetItem
         *        a consumer that will call methods on {@link AssetItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetItem(AssetItem)
         */
        default Builder assetItem(Consumer<AssetItem.Builder> assetItem) {
            return assetItem(AssetItem.builder().applyMutation(assetItem).build());
        }

        /**
         * <p>
         * The data product item included in the search results.
         * </p>
         * 
         * @param dataProductItem
         *        The data product item included in the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProductItem(DataProductSummary dataProductItem);

        /**
         * <p>
         * The data product item included in the search results.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataProductSummary.Builder} avoiding the
         * need to create one manually via {@link DataProductSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataProductSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #dataProductItem(DataProductSummary)}.
         * 
         * @param dataProductItem
         *        a consumer that will call methods on {@link DataProductSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataProductItem(DataProductSummary)
         */
        default Builder dataProductItem(Consumer<DataProductSummary.Builder> dataProductItem) {
            return dataProductItem(DataProductSummary.builder().applyMutation(dataProductItem).build());
        }

        /**
         * <p>
         * The glossary item included in the search results.
         * </p>
         * 
         * @param glossaryItem
         *        The glossary item included in the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryItem(GlossaryItem glossaryItem);

        /**
         * <p>
         * The glossary item included in the search results.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlossaryItem.Builder} avoiding the need
         * to create one manually via {@link GlossaryItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlossaryItem.Builder#build()} is called immediately and its
         * result is passed to {@link #glossaryItem(GlossaryItem)}.
         * 
         * @param glossaryItem
         *        a consumer that will call methods on {@link GlossaryItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glossaryItem(GlossaryItem)
         */
        default Builder glossaryItem(Consumer<GlossaryItem.Builder> glossaryItem) {
            return glossaryItem(GlossaryItem.builder().applyMutation(glossaryItem).build());
        }

        /**
         * <p>
         * The glossary term item included in the search results.
         * </p>
         * 
         * @param glossaryTermItem
         *        The glossary term item included in the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTermItem(GlossaryTermItem glossaryTermItem);

        /**
         * <p>
         * The glossary term item included in the search results.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlossaryTermItem.Builder} avoiding the
         * need to create one manually via {@link GlossaryTermItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlossaryTermItem.Builder#build()} is called immediately and its
         * result is passed to {@link #glossaryTermItem(GlossaryTermItem)}.
         * 
         * @param glossaryTermItem
         *        a consumer that will call methods on {@link GlossaryTermItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glossaryTermItem(GlossaryTermItem)
         */
        default Builder glossaryTermItem(Consumer<GlossaryTermItem.Builder> glossaryTermItem) {
            return glossaryTermItem(GlossaryTermItem.builder().applyMutation(glossaryTermItem).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AssetItem assetItem;

        private DataProductSummary dataProductItem;

        private GlossaryItem glossaryItem;

        private GlossaryTermItem glossaryTermItem;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SearchInventoryResultItem model) {
            assetItem(model.assetItem);
            dataProductItem(model.dataProductItem);
            glossaryItem(model.glossaryItem);
            glossaryTermItem(model.glossaryTermItem);
        }

        public final AssetItem.Builder getAssetItem() {
            return assetItem != null ? assetItem.toBuilder() : null;
        }

        public final void setAssetItem(AssetItem.BuilderImpl assetItem) {
            Object oldValue = this.assetItem;
            this.assetItem = assetItem != null ? assetItem.build() : null;
            handleUnionValueChange(Type.ASSET_ITEM, oldValue, this.assetItem);
        }

        @Override
        public final Builder assetItem(AssetItem assetItem) {
            Object oldValue = this.assetItem;
            this.assetItem = assetItem;
            handleUnionValueChange(Type.ASSET_ITEM, oldValue, this.assetItem);
            return this;
        }

        public final DataProductSummary.Builder getDataProductItem() {
            return dataProductItem != null ? dataProductItem.toBuilder() : null;
        }

        public final void setDataProductItem(DataProductSummary.BuilderImpl dataProductItem) {
            Object oldValue = this.dataProductItem;
            this.dataProductItem = dataProductItem != null ? dataProductItem.build() : null;
            handleUnionValueChange(Type.DATA_PRODUCT_ITEM, oldValue, this.dataProductItem);
        }

        @Override
        public final Builder dataProductItem(DataProductSummary dataProductItem) {
            Object oldValue = this.dataProductItem;
            this.dataProductItem = dataProductItem;
            handleUnionValueChange(Type.DATA_PRODUCT_ITEM, oldValue, this.dataProductItem);
            return this;
        }

        public final GlossaryItem.Builder getGlossaryItem() {
            return glossaryItem != null ? glossaryItem.toBuilder() : null;
        }

        public final void setGlossaryItem(GlossaryItem.BuilderImpl glossaryItem) {
            Object oldValue = this.glossaryItem;
            this.glossaryItem = glossaryItem != null ? glossaryItem.build() : null;
            handleUnionValueChange(Type.GLOSSARY_ITEM, oldValue, this.glossaryItem);
        }

        @Override
        public final Builder glossaryItem(GlossaryItem glossaryItem) {
            Object oldValue = this.glossaryItem;
            this.glossaryItem = glossaryItem;
            handleUnionValueChange(Type.GLOSSARY_ITEM, oldValue, this.glossaryItem);
            return this;
        }

        public final GlossaryTermItem.Builder getGlossaryTermItem() {
            return glossaryTermItem != null ? glossaryTermItem.toBuilder() : null;
        }

        public final void setGlossaryTermItem(GlossaryTermItem.BuilderImpl glossaryTermItem) {
            Object oldValue = this.glossaryTermItem;
            this.glossaryTermItem = glossaryTermItem != null ? glossaryTermItem.build() : null;
            handleUnionValueChange(Type.GLOSSARY_TERM_ITEM, oldValue, this.glossaryTermItem);
        }

        @Override
        public final Builder glossaryTermItem(GlossaryTermItem glossaryTermItem) {
            Object oldValue = this.glossaryTermItem;
            this.glossaryTermItem = glossaryTermItem;
            handleUnionValueChange(Type.GLOSSARY_TERM_ITEM, oldValue, this.glossaryTermItem);
            return this;
        }

        @Override
        public SearchInventoryResultItem build() {
            return new SearchInventoryResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SearchInventoryResultItem#type()
     */
    public enum Type {
        ASSET_ITEM,

        DATA_PRODUCT_ITEM,

        GLOSSARY_ITEM,

        GLOSSARY_TERM_ITEM,

        UNKNOWN_TO_SDK_VERSION
    }
}
