/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotificationsRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListNotificationsRequest.Builder, ListNotificationsRequest> {
    private static final SdkField<Instant> AFTER_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("afterTimestamp").getter(getter(ListNotificationsRequest::afterTimestamp))
            .setter(setter(Builder::afterTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("afterTimestamp").build())
            .build();

    private static final SdkField<Instant> BEFORE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("beforeTimestamp").getter(getter(ListNotificationsRequest::beforeTimestamp))
            .setter(setter(Builder::beforeTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("beforeTimestamp").build())
            .build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListNotificationsRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListNotificationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListNotificationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<List<String>> SUBJECTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subjects")
            .getter(getter(ListNotificationsRequest::subjects))
            .setter(setter(Builder::subjects))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("subjects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskStatus").getter(getter(ListNotificationsRequest::taskStatusAsString))
            .setter(setter(Builder::taskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("taskStatus").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ListNotificationsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFTER_TIMESTAMP_FIELD,
            BEFORE_TIMESTAMP_FIELD, DOMAIN_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SUBJECTS_FIELD,
            TASK_STATUS_FIELD, TYPE_FIELD));

    private final Instant afterTimestamp;

    private final Instant beforeTimestamp;

    private final String domainIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> subjects;

    private final String taskStatus;

    private final String type;

    private ListNotificationsRequest(BuilderImpl builder) {
        super(builder);
        this.afterTimestamp = builder.afterTimestamp;
        this.beforeTimestamp = builder.beforeTimestamp;
        this.domainIdentifier = builder.domainIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.subjects = builder.subjects;
        this.taskStatus = builder.taskStatus;
        this.type = builder.type;
    }

    /**
     * <p>
     * The time after which you want to list notifications.
     * </p>
     * 
     * @return The time after which you want to list notifications.
     */
    public final Instant afterTimestamp() {
        return afterTimestamp;
    }

    /**
     * <p>
     * The time before which you want to list notifications.
     * </p>
     * 
     * @return The time before which you want to list notifications.
     */
    public final Instant beforeTimestamp() {
        return beforeTimestamp;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The maximum number of notifications to return in a single call to <code>ListNotifications</code>. When the number
     * of notifications to be listed is greater than the value of <code>MaxResults</code>, the response contains a
     * <code>NextToken</code> value that you can use in a subsequent call to <code>ListNotifications</code> to list the
     * next set of notifications.
     * </p>
     * 
     * @return The maximum number of notifications to return in a single call to <code>ListNotifications</code>. When
     *         the number of notifications to be listed is greater than the value of <code>MaxResults</code>, the
     *         response contains a <code>NextToken</code> value that you can use in a subsequent call to
     *         <code>ListNotifications</code> to list the next set of notifications.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of notifications is greater than the default value for the <code>MaxResults</code> parameter, or
     * if you explicitly specify a value for <code>MaxResults</code> that is less than the number of notifications, the
     * response includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code>
     * value in a subsequent call to <code>ListNotifications</code> to list the next set of notifications.
     * </p>
     * 
     * @return When the number of notifications is greater than the default value for the <code>MaxResults</code>
     *         parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number
     *         of notifications, the response includes a pagination token named <code>NextToken</code>. You can specify
     *         this <code>NextToken</code> value in a subsequent call to <code>ListNotifications</code> to list the next
     *         set of notifications.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subjects property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubjects() {
        return subjects != null && !(subjects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subjects of notifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubjects} method.
     * </p>
     * 
     * @return The subjects of notifications.
     */
    public final List<String> subjects() {
        return subjects;
    }

    /**
     * <p>
     * The task status of notifications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return The task status of notifications.
     * @see TaskStatus
     */
    public final TaskStatus taskStatus() {
        return TaskStatus.fromValue(taskStatus);
    }

    /**
     * <p>
     * The task status of notifications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return The task status of notifications.
     * @see TaskStatus
     */
    public final String taskStatusAsString() {
        return taskStatus;
    }

    /**
     * <p>
     * The type of notifications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of notifications.
     * @see NotificationType
     */
    public final NotificationType type() {
        return NotificationType.fromValue(type);
    }

    /**
     * <p>
     * The type of notifications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of notifications.
     * @see NotificationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(afterTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(beforeTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubjects() ? subjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationsRequest)) {
            return false;
        }
        ListNotificationsRequest other = (ListNotificationsRequest) obj;
        return Objects.equals(afterTimestamp(), other.afterTimestamp())
                && Objects.equals(beforeTimestamp(), other.beforeTimestamp())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasSubjects() == other.hasSubjects() && Objects.equals(subjects(), other.subjects())
                && Objects.equals(taskStatusAsString(), other.taskStatusAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNotificationsRequest").add("AfterTimestamp", afterTimestamp())
                .add("BeforeTimestamp", beforeTimestamp()).add("DomainIdentifier", domainIdentifier())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("Subjects", hasSubjects() ? subjects() : null)
                .add("TaskStatus", taskStatusAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "afterTimestamp":
            return Optional.ofNullable(clazz.cast(afterTimestamp()));
        case "beforeTimestamp":
            return Optional.ofNullable(clazz.cast(beforeTimestamp()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "subjects":
            return Optional.ofNullable(clazz.cast(subjects()));
        case "taskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationsRequest, T> g) {
        return obj -> g.apply((ListNotificationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListNotificationsRequest> {
        /**
         * <p>
         * The time after which you want to list notifications.
         * </p>
         * 
         * @param afterTimestamp
         *        The time after which you want to list notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterTimestamp(Instant afterTimestamp);

        /**
         * <p>
         * The time before which you want to list notifications.
         * </p>
         * 
         * @param beforeTimestamp
         *        The time before which you want to list notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeTimestamp(Instant beforeTimestamp);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The maximum number of notifications to return in a single call to <code>ListNotifications</code>. When the
         * number of notifications to be listed is greater than the value of <code>MaxResults</code>, the response
         * contains a <code>NextToken</code> value that you can use in a subsequent call to
         * <code>ListNotifications</code> to list the next set of notifications.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of notifications to return in a single call to <code>ListNotifications</code>. When
         *        the number of notifications to be listed is greater than the value of <code>MaxResults</code>, the
         *        response contains a <code>NextToken</code> value that you can use in a subsequent call to
         *        <code>ListNotifications</code> to list the next set of notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of notifications is greater than the default value for the <code>MaxResults</code> parameter,
         * or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
         * notifications, the response includes a pagination token named <code>NextToken</code>. You can specify this
         * <code>NextToken</code> value in a subsequent call to <code>ListNotifications</code> to list the next set of
         * notifications.
         * </p>
         * 
         * @param nextToken
         *        When the number of notifications is greater than the default value for the <code>MaxResults</code>
         *        parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the
         *        number of notifications, the response includes a pagination token named <code>NextToken</code>. You
         *        can specify this <code>NextToken</code> value in a subsequent call to <code>ListNotifications</code>
         *        to list the next set of notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The subjects of notifications.
         * </p>
         * 
         * @param subjects
         *        The subjects of notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjects(Collection<String> subjects);

        /**
         * <p>
         * The subjects of notifications.
         * </p>
         * 
         * @param subjects
         *        The subjects of notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjects(String... subjects);

        /**
         * <p>
         * The task status of notifications.
         * </p>
         * 
         * @param taskStatus
         *        The task status of notifications.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder taskStatus(String taskStatus);

        /**
         * <p>
         * The task status of notifications.
         * </p>
         * 
         * @param taskStatus
         *        The task status of notifications.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder taskStatus(TaskStatus taskStatus);

        /**
         * <p>
         * The type of notifications.
         * </p>
         * 
         * @param type
         *        The type of notifications.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of notifications.
         * </p>
         * 
         * @param type
         *        The type of notifications.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder type(NotificationType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private Instant afterTimestamp;

        private Instant beforeTimestamp;

        private String domainIdentifier;

        private Integer maxResults;

        private String nextToken;

        private List<String> subjects = DefaultSdkAutoConstructList.getInstance();

        private String taskStatus;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationsRequest model) {
            super(model);
            afterTimestamp(model.afterTimestamp);
            beforeTimestamp(model.beforeTimestamp);
            domainIdentifier(model.domainIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            subjects(model.subjects);
            taskStatus(model.taskStatus);
            type(model.type);
        }

        public final Instant getAfterTimestamp() {
            return afterTimestamp;
        }

        public final void setAfterTimestamp(Instant afterTimestamp) {
            this.afterTimestamp = afterTimestamp;
        }

        @Override
        public final Builder afterTimestamp(Instant afterTimestamp) {
            this.afterTimestamp = afterTimestamp;
            return this;
        }

        public final Instant getBeforeTimestamp() {
            return beforeTimestamp;
        }

        public final void setBeforeTimestamp(Instant beforeTimestamp) {
            this.beforeTimestamp = beforeTimestamp;
        }

        @Override
        public final Builder beforeTimestamp(Instant beforeTimestamp) {
            this.beforeTimestamp = beforeTimestamp;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getSubjects() {
            if (subjects instanceof SdkAutoConstructList) {
                return null;
            }
            return subjects;
        }

        public final void setSubjects(Collection<String> subjects) {
            this.subjects = NotificationSubjectsCopier.copy(subjects);
        }

        @Override
        public final Builder subjects(Collection<String> subjects) {
            this.subjects = NotificationSubjectsCopier.copy(subjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjects(String... subjects) {
            subjects(Arrays.asList(subjects));
            return this;
        }

        public final String getTaskStatus() {
            return taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(TaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NotificationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNotificationsRequest build() {
            return new ListNotificationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
