/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListNotificationsRequest;
import software.amazon.awssdk.services.datazone.model.ListNotificationsResponse;
import software.amazon.awssdk.services.datazone.model.NotificationOutput;

public class ListNotificationsPublisher
implements SdkPublisher<ListNotificationsResponse> {
    private final DataZoneAsyncClient client;
    private final ListNotificationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNotificationsPublisher(DataZoneAsyncClient client, ListNotificationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNotificationsPublisher(DataZoneAsyncClient client, ListNotificationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNotificationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNotificationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NotificationOutput> notifications() {
        Function<ListNotificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.notifications() != null) {
                return response.notifications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNotificationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNotificationsResponseFetcher
    implements AsyncPageFetcher<ListNotificationsResponse> {
        private ListNotificationsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNotificationsResponse> nextPage(ListNotificationsResponse previousPage) {
            if (previousPage == null) {
                return ListNotificationsPublisher.this.client.listNotifications(ListNotificationsPublisher.this.firstRequest);
            }
            return ListNotificationsPublisher.this.client.listNotifications((ListNotificationsRequest)((Object)ListNotificationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

