/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFormTypeRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateFormTypeRequest.Builder, CreateFormTypeRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateFormTypeRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateFormTypeRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<Model> MODEL_FIELD = SdkField.<Model> builder(MarshallingType.SDK_POJO).memberName("model")
            .getter(getter(CreateFormTypeRequest::model)).setter(setter(Builder::model)).constructor(Model::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateFormTypeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNING_PROJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectIdentifier").getter(getter(CreateFormTypeRequest::owningProjectIdentifier))
            .setter(setter(Builder::owningProjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectIdentifier").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateFormTypeRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DOMAIN_IDENTIFIER_FIELD, MODEL_FIELD, NAME_FIELD, OWNING_PROJECT_IDENTIFIER_FIELD, STATUS_FIELD));

    private final String description;

    private final String domainIdentifier;

    private final Model model;

    private final String name;

    private final String owningProjectIdentifier;

    private final String status;

    private CreateFormTypeRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.model = builder.model;
        this.name = builder.name;
        this.owningProjectIdentifier = builder.owningProjectIdentifier;
        this.status = builder.status;
    }

    /**
     * <p>
     * The description of this Amazon DataZone metadata form type.
     * </p>
     * 
     * @return The description of this Amazon DataZone metadata form type.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which this metadata form type is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which this metadata form type is created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The model of this Amazon DataZone metadata form type.
     * </p>
     * 
     * @return The model of this Amazon DataZone metadata form type.
     */
    public final Model model() {
        return model;
    }

    /**
     * <p>
     * The name of this Amazon DataZone metadata form type.
     * </p>
     * 
     * @return The name of this Amazon DataZone metadata form type.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone project that owns this metadata form type.
     * </p>
     * 
     * @return The ID of the Amazon DataZone project that owns this metadata form type.
     */
    public final String owningProjectIdentifier() {
        return owningProjectIdentifier;
    }

    /**
     * <p>
     * The status of this Amazon DataZone metadata form type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FormTypeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this Amazon DataZone metadata form type.
     * @see FormTypeStatus
     */
    public final FormTypeStatus status() {
        return FormTypeStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of this Amazon DataZone metadata form type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FormTypeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this Amazon DataZone metadata form type.
     * @see FormTypeStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFormTypeRequest)) {
            return false;
        }
        CreateFormTypeRequest other = (CreateFormTypeRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(model(), other.model()) && Objects.equals(name(), other.name())
                && Objects.equals(owningProjectIdentifier(), other.owningProjectIdentifier())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFormTypeRequest")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier())
                .add("Model", model() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OwningProjectIdentifier", owningProjectIdentifier()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "model":
            return Optional.ofNullable(clazz.cast(model()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owningProjectIdentifier":
            return Optional.ofNullable(clazz.cast(owningProjectIdentifier()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFormTypeRequest, T> g) {
        return obj -> g.apply((CreateFormTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFormTypeRequest> {
        /**
         * <p>
         * The description of this Amazon DataZone metadata form type.
         * </p>
         * 
         * @param description
         *        The description of this Amazon DataZone metadata form type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which this metadata form type is created.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain in which this metadata form type is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The model of this Amazon DataZone metadata form type.
         * </p>
         * 
         * @param model
         *        The model of this Amazon DataZone metadata form type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(Model model);

        /**
         * <p>
         * The model of this Amazon DataZone metadata form type.
         * </p>
         * This is a convenience method that creates an instance of the {@link Model.Builder} avoiding the need to
         * create one manually via {@link Model#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Model.Builder#build()} is called immediately and its result is
         * passed to {@link #model(Model)}.
         * 
         * @param model
         *        a consumer that will call methods on {@link Model.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #model(Model)
         */
        default Builder model(Consumer<Model.Builder> model) {
            return model(Model.builder().applyMutation(model).build());
        }

        /**
         * <p>
         * The name of this Amazon DataZone metadata form type.
         * </p>
         * 
         * @param name
         *        The name of this Amazon DataZone metadata form type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the Amazon DataZone project that owns this metadata form type.
         * </p>
         * 
         * @param owningProjectIdentifier
         *        The ID of the Amazon DataZone project that owns this metadata form type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectIdentifier(String owningProjectIdentifier);

        /**
         * <p>
         * The status of this Amazon DataZone metadata form type.
         * </p>
         * 
         * @param status
         *        The status of this Amazon DataZone metadata form type.
         * @see FormTypeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormTypeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of this Amazon DataZone metadata form type.
         * </p>
         * 
         * @param status
         *        The status of this Amazon DataZone metadata form type.
         * @see FormTypeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormTypeStatus
         */
        Builder status(FormTypeStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String description;

        private String domainIdentifier;

        private Model model;

        private String name;

        private String owningProjectIdentifier;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFormTypeRequest model) {
            super(model);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            model(model.model);
            name(model.name);
            owningProjectIdentifier(model.owningProjectIdentifier);
            status(model.status);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Model.Builder getModel() {
            return model != null ? model.toBuilder() : null;
        }

        public final void setModel(Model.BuilderImpl model) {
            this.model = model != null ? model.build() : null;
        }

        @Override
        public final Builder model(Model model) {
            this.model = model;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectIdentifier() {
            return owningProjectIdentifier;
        }

        public final void setOwningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
        }

        @Override
        public final Builder owningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FormTypeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFormTypeRequest build() {
            return new CreateFormTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
