/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteProjectMembershipRequest extends DataZoneRequest implements
        ToCopyableBuilder<DeleteProjectMembershipRequest.Builder, DeleteProjectMembershipRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(DeleteProjectMembershipRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<Member> MEMBER_FIELD = SdkField.<Member> builder(MarshallingType.SDK_POJO).memberName("member")
            .getter(getter(DeleteProjectMembershipRequest::member)).setter(setter(Builder::member)).constructor(Member::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build();

    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectIdentifier").getter(getter(DeleteProjectMembershipRequest::projectIdentifier))
            .setter(setter(Builder::projectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            MEMBER_FIELD, PROJECT_IDENTIFIER_FIELD));

    private final String domainIdentifier;

    private final Member member;

    private final String projectIdentifier;

    private DeleteProjectMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.member = builder.member;
        this.projectIdentifier = builder.projectIdentifier;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain where project membership is deleted.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain where project membership is deleted.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The project member whose project membership is deleted.
     * </p>
     * 
     * @return The project member whose project membership is deleted.
     */
    public final Member member() {
        return member;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone project the membership to which is deleted.
     * </p>
     * 
     * @return The ID of the Amazon DataZone project the membership to which is deleted.
     */
    public final String projectIdentifier() {
        return projectIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(member());
        hashCode = 31 * hashCode + Objects.hashCode(projectIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProjectMembershipRequest)) {
            return false;
        }
        DeleteProjectMembershipRequest other = (DeleteProjectMembershipRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier()) && Objects.equals(member(), other.member())
                && Objects.equals(projectIdentifier(), other.projectIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteProjectMembershipRequest").add("DomainIdentifier", domainIdentifier())
                .add("Member", member()).add("ProjectIdentifier", projectIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "member":
            return Optional.ofNullable(clazz.cast(member()));
        case "projectIdentifier":
            return Optional.ofNullable(clazz.cast(projectIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteProjectMembershipRequest, T> g) {
        return obj -> g.apply((DeleteProjectMembershipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteProjectMembershipRequest> {
        /**
         * <p>
         * The ID of the Amazon DataZone domain where project membership is deleted.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain where project membership is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The project member whose project membership is deleted.
         * </p>
         * 
         * @param member
         *        The project member whose project membership is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder member(Member member);

        /**
         * <p>
         * The project member whose project membership is deleted.
         * </p>
         * This is a convenience method that creates an instance of the {@link Member.Builder} avoiding the need to
         * create one manually via {@link Member#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Member.Builder#build()} is called immediately and its result is
         * passed to {@link #member(Member)}.
         * 
         * @param member
         *        a consumer that will call methods on {@link Member.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #member(Member)
         */
        default Builder member(Consumer<Member.Builder> member) {
            return member(Member.builder().applyMutation(member).build());
        }

        /**
         * <p>
         * The ID of the Amazon DataZone project the membership to which is deleted.
         * </p>
         * 
         * @param projectIdentifier
         *        The ID of the Amazon DataZone project the membership to which is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectIdentifier(String projectIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private Member member;

        private String projectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProjectMembershipRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            member(model.member);
            projectIdentifier(model.projectIdentifier);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Member.Builder getMember() {
            return member != null ? member.toBuilder() : null;
        }

        public final void setMember(Member.BuilderImpl member) {
            this.member = member != null ? member.build() : null;
        }

        @Override
        public final Builder member(Member member) {
            this.member = member;
            return this;
        }

        public final String getProjectIdentifier() {
            return projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProjectMembershipRequest build() {
            return new DeleteProjectMembershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
