/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubscriptionTargetResponse extends DataZoneResponse implements
        ToCopyableBuilder<CreateSubscriptionTargetResponse.Builder, CreateSubscriptionTargetResponse> {
    private static final SdkField<List<String>> APPLICABLE_ASSET_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("applicableAssetTypes")
            .getter(getter(CreateSubscriptionTargetResponse::applicableAssetTypes))
            .setter(setter(Builder::applicableAssetTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicableAssetTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTHORIZED_PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("authorizedPrincipals")
            .getter(getter(CreateSubscriptionTargetResponse::authorizedPrincipals))
            .setter(setter(Builder::authorizedPrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizedPrincipals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CreateSubscriptionTargetResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(CreateSubscriptionTargetResponse::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(CreateSubscriptionTargetResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(CreateSubscriptionTargetResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateSubscriptionTargetResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> MANAGE_ACCESS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("manageAccessRole").getter(getter(CreateSubscriptionTargetResponse::manageAccessRole))
            .setter(setter(Builder::manageAccessRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageAccessRole").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateSubscriptionTargetResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectId").getter(getter(CreateSubscriptionTargetResponse::projectId))
            .setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(CreateSubscriptionTargetResponse::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<List<SubscriptionTargetForm>> SUBSCRIPTION_TARGET_CONFIG_FIELD = SdkField
            .<List<SubscriptionTargetForm>> builder(MarshallingType.LIST)
            .memberName("subscriptionTargetConfig")
            .getter(getter(CreateSubscriptionTargetResponse::subscriptionTargetConfig))
            .setter(setter(Builder::subscriptionTargetConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionTargetConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubscriptionTargetForm> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubscriptionTargetForm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateSubscriptionTargetResponse::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(CreateSubscriptionTargetResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(CreateSubscriptionTargetResponse::updatedBy))
            .setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICABLE_ASSET_TYPES_FIELD,
            AUTHORIZED_PRINCIPALS_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DOMAIN_ID_FIELD, ENVIRONMENT_ID_FIELD, ID_FIELD,
            MANAGE_ACCESS_ROLE_FIELD, NAME_FIELD, PROJECT_ID_FIELD, PROVIDER_FIELD, SUBSCRIPTION_TARGET_CONFIG_FIELD, TYPE_FIELD,
            UPDATED_AT_FIELD, UPDATED_BY_FIELD));

    private final List<String> applicableAssetTypes;

    private final List<String> authorizedPrincipals;

    private final Instant createdAt;

    private final String createdBy;

    private final String domainId;

    private final String environmentId;

    private final String id;

    private final String manageAccessRole;

    private final String name;

    private final String projectId;

    private final String provider;

    private final List<SubscriptionTargetForm> subscriptionTargetConfig;

    private final String type;

    private final Instant updatedAt;

    private final String updatedBy;

    private CreateSubscriptionTargetResponse(BuilderImpl builder) {
        super(builder);
        this.applicableAssetTypes = builder.applicableAssetTypes;
        this.authorizedPrincipals = builder.authorizedPrincipals;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.domainId = builder.domainId;
        this.environmentId = builder.environmentId;
        this.id = builder.id;
        this.manageAccessRole = builder.manageAccessRole;
        this.name = builder.name;
        this.projectId = builder.projectId;
        this.provider = builder.provider;
        this.subscriptionTargetConfig = builder.subscriptionTargetConfig;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicableAssetTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicableAssetTypes() {
        return applicableAssetTypes != null && !(applicableAssetTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The asset types that can be included in the subscription target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicableAssetTypes} method.
     * </p>
     * 
     * @return The asset types that can be included in the subscription target.
     */
    public final List<String> applicableAssetTypes() {
        return applicableAssetTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedPrincipals property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorizedPrincipals() {
        return authorizedPrincipals != null && !(authorizedPrincipals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The authorised principals of the subscription target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedPrincipals} method.
     * </p>
     * 
     * @return The authorised principals of the subscription target.
     */
    public final List<String> authorizedPrincipals() {
        return authorizedPrincipals;
    }

    /**
     * <p>
     * The timestamp of when the subscription target was created.
     * </p>
     * 
     * @return The timestamp of when the subscription target was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who created the subscription target.
     * </p>
     * 
     * @return The Amazon DataZone user who created the subscription target.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which the subscription target was created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which the subscription target was created.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The ID of the environment in which the subscription target was created.
     * </p>
     * 
     * @return The ID of the environment in which the subscription target was created.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The ID of the subscription target.
     * </p>
     * 
     * @return The ID of the subscription target.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The manage access role with which the subscription target was created.
     * </p>
     * 
     * @return The manage access role with which the subscription target was created.
     */
    public final String manageAccessRole() {
        return manageAccessRole;
    }

    /**
     * <p>
     * The name of the subscription target.
     * </p>
     * 
     * @return The name of the subscription target.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * ???
     * </p>
     * 
     * @return ???
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * The provider of the subscription target.
     * </p>
     * 
     * @return The provider of the subscription target.
     */
    public final String provider() {
        return provider;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubscriptionTargetConfig property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSubscriptionTargetConfig() {
        return subscriptionTargetConfig != null && !(subscriptionTargetConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration of the subscription target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscriptionTargetConfig} method.
     * </p>
     * 
     * @return The configuration of the subscription target.
     */
    public final List<SubscriptionTargetForm> subscriptionTargetConfig() {
        return subscriptionTargetConfig;
    }

    /**
     * <p>
     * The type of the subscription target.
     * </p>
     * 
     * @return The type of the subscription target.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The timestamp of when the subscription target was updated.
     * </p>
     * 
     * @return The timestamp of when the subscription target was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who updated the subscription target.
     * </p>
     * 
     * @return The Amazon DataZone user who updated the subscription target.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicableAssetTypes() ? applicableAssetTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedPrincipals() ? authorizedPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(manageAccessRole());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscriptionTargetConfig() ? subscriptionTargetConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionTargetResponse)) {
            return false;
        }
        CreateSubscriptionTargetResponse other = (CreateSubscriptionTargetResponse) obj;
        return hasApplicableAssetTypes() == other.hasApplicableAssetTypes()
                && Objects.equals(applicableAssetTypes(), other.applicableAssetTypes())
                && hasAuthorizedPrincipals() == other.hasAuthorizedPrincipals()
                && Objects.equals(authorizedPrincipals(), other.authorizedPrincipals())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(domainId(), other.domainId()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(id(), other.id()) && Objects.equals(manageAccessRole(), other.manageAccessRole())
                && Objects.equals(name(), other.name()) && Objects.equals(projectId(), other.projectId())
                && Objects.equals(provider(), other.provider())
                && hasSubscriptionTargetConfig() == other.hasSubscriptionTargetConfig()
                && Objects.equals(subscriptionTargetConfig(), other.subscriptionTargetConfig())
                && Objects.equals(type(), other.type()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubscriptionTargetResponse")
                .add("ApplicableAssetTypes", hasApplicableAssetTypes() ? applicableAssetTypes() : null)
                .add("AuthorizedPrincipals", hasAuthorizedPrincipals() ? authorizedPrincipals() : null)
                .add("CreatedAt", createdAt()).add("CreatedBy", createdBy()).add("DomainId", domainId())
                .add("EnvironmentId", environmentId()).add("Id", id()).add("ManageAccessRole", manageAccessRole())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("ProjectId", projectId())
                .add("Provider", provider())
                .add("SubscriptionTargetConfig", hasSubscriptionTargetConfig() ? subscriptionTargetConfig() : null)
                .add("Type", type()).add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicableAssetTypes":
            return Optional.ofNullable(clazz.cast(applicableAssetTypes()));
        case "authorizedPrincipals":
            return Optional.ofNullable(clazz.cast(authorizedPrincipals()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "manageAccessRole":
            return Optional.ofNullable(clazz.cast(manageAccessRole()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "subscriptionTargetConfig":
            return Optional.ofNullable(clazz.cast(subscriptionTargetConfig()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriptionTargetResponse, T> g) {
        return obj -> g.apply((CreateSubscriptionTargetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSubscriptionTargetResponse> {
        /**
         * <p>
         * The asset types that can be included in the subscription target.
         * </p>
         * 
         * @param applicableAssetTypes
         *        The asset types that can be included in the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicableAssetTypes(Collection<String> applicableAssetTypes);

        /**
         * <p>
         * The asset types that can be included in the subscription target.
         * </p>
         * 
         * @param applicableAssetTypes
         *        The asset types that can be included in the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicableAssetTypes(String... applicableAssetTypes);

        /**
         * <p>
         * The authorised principals of the subscription target.
         * </p>
         * 
         * @param authorizedPrincipals
         *        The authorised principals of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedPrincipals(Collection<String> authorizedPrincipals);

        /**
         * <p>
         * The authorised principals of the subscription target.
         * </p>
         * 
         * @param authorizedPrincipals
         *        The authorised principals of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedPrincipals(String... authorizedPrincipals);

        /**
         * <p>
         * The timestamp of when the subscription target was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the subscription target was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon DataZone user who created the subscription target.
         * </p>
         * 
         * @param createdBy
         *        The Amazon DataZone user who created the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which the subscription target was created.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon DataZone domain in which the subscription target was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The ID of the environment in which the subscription target was created.
         * </p>
         * 
         * @param environmentId
         *        The ID of the environment in which the subscription target was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The ID of the subscription target.
         * </p>
         * 
         * @param id
         *        The ID of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The manage access role with which the subscription target was created.
         * </p>
         * 
         * @param manageAccessRole
         *        The manage access role with which the subscription target was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageAccessRole(String manageAccessRole);

        /**
         * <p>
         * The name of the subscription target.
         * </p>
         * 
         * @param name
         *        The name of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * ???
         * </p>
         * 
         * @param projectId
         *        ???
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * The provider of the subscription target.
         * </p>
         * 
         * @param provider
         *        The provider of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The configuration of the subscription target.
         * </p>
         * 
         * @param subscriptionTargetConfig
         *        The configuration of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionTargetConfig(Collection<SubscriptionTargetForm> subscriptionTargetConfig);

        /**
         * <p>
         * The configuration of the subscription target.
         * </p>
         * 
         * @param subscriptionTargetConfig
         *        The configuration of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionTargetConfig(SubscriptionTargetForm... subscriptionTargetConfig);

        /**
         * <p>
         * The configuration of the subscription target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm.Builder#build()} is called
         * immediately and its result is passed to {@link #subscriptionTargetConfig(List<SubscriptionTargetForm>)}.
         * 
         * @param subscriptionTargetConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriptionTargetConfig(java.util.Collection<SubscriptionTargetForm>)
         */
        Builder subscriptionTargetConfig(Consumer<SubscriptionTargetForm.Builder>... subscriptionTargetConfig);

        /**
         * <p>
         * The type of the subscription target.
         * </p>
         * 
         * @param type
         *        The type of the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The timestamp of when the subscription target was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the subscription target was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The Amazon DataZone user who updated the subscription target.
         * </p>
         * 
         * @param updatedBy
         *        The Amazon DataZone user who updated the subscription target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private List<String> applicableAssetTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> authorizedPrincipals = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private String createdBy;

        private String domainId;

        private String environmentId;

        private String id;

        private String manageAccessRole;

        private String name;

        private String projectId;

        private String provider;

        private List<SubscriptionTargetForm> subscriptionTargetConfig = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionTargetResponse model) {
            super(model);
            applicableAssetTypes(model.applicableAssetTypes);
            authorizedPrincipals(model.authorizedPrincipals);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            domainId(model.domainId);
            environmentId(model.environmentId);
            id(model.id);
            manageAccessRole(model.manageAccessRole);
            name(model.name);
            projectId(model.projectId);
            provider(model.provider);
            subscriptionTargetConfig(model.subscriptionTargetConfig);
            type(model.type);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final Collection<String> getApplicableAssetTypes() {
            if (applicableAssetTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return applicableAssetTypes;
        }

        public final void setApplicableAssetTypes(Collection<String> applicableAssetTypes) {
            this.applicableAssetTypes = ApplicableAssetTypesCopier.copy(applicableAssetTypes);
        }

        @Override
        public final Builder applicableAssetTypes(Collection<String> applicableAssetTypes) {
            this.applicableAssetTypes = ApplicableAssetTypesCopier.copy(applicableAssetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicableAssetTypes(String... applicableAssetTypes) {
            applicableAssetTypes(Arrays.asList(applicableAssetTypes));
            return this;
        }

        public final Collection<String> getAuthorizedPrincipals() {
            if (authorizedPrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizedPrincipals;
        }

        public final void setAuthorizedPrincipals(Collection<String> authorizedPrincipals) {
            this.authorizedPrincipals = AuthorizedPrincipalIdentifiersCopier.copy(authorizedPrincipals);
        }

        @Override
        public final Builder authorizedPrincipals(Collection<String> authorizedPrincipals) {
            this.authorizedPrincipals = AuthorizedPrincipalIdentifiersCopier.copy(authorizedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedPrincipals(String... authorizedPrincipals) {
            authorizedPrincipals(Arrays.asList(authorizedPrincipals));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getManageAccessRole() {
            return manageAccessRole;
        }

        public final void setManageAccessRole(String manageAccessRole) {
            this.manageAccessRole = manageAccessRole;
        }

        @Override
        public final Builder manageAccessRole(String manageAccessRole) {
            this.manageAccessRole = manageAccessRole;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final List<SubscriptionTargetForm.Builder> getSubscriptionTargetConfig() {
            List<SubscriptionTargetForm.Builder> result = SubscriptionTargetFormsCopier
                    .copyToBuilder(this.subscriptionTargetConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscriptionTargetConfig(Collection<SubscriptionTargetForm.BuilderImpl> subscriptionTargetConfig) {
            this.subscriptionTargetConfig = SubscriptionTargetFormsCopier.copyFromBuilder(subscriptionTargetConfig);
        }

        @Override
        public final Builder subscriptionTargetConfig(Collection<SubscriptionTargetForm> subscriptionTargetConfig) {
            this.subscriptionTargetConfig = SubscriptionTargetFormsCopier.copy(subscriptionTargetConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionTargetConfig(SubscriptionTargetForm... subscriptionTargetConfig) {
            subscriptionTargetConfig(Arrays.asList(subscriptionTargetConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionTargetConfig(Consumer<SubscriptionTargetForm.Builder>... subscriptionTargetConfig) {
            subscriptionTargetConfig(Stream.of(subscriptionTargetConfig)
                    .map(c -> SubscriptionTargetForm.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public CreateSubscriptionTargetResponse build() {
            return new CreateSubscriptionTargetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
